/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.display2d.GridPointData;

public class TestData {
    public static double dipole(double x, double y) {
        double r1 = Math.sqrt((x - 1.0) * (x - 1.0) + y * y);
        double r2 = Math.sqrt((x + 1.0) * (x + 1.0) + y * y);
        if (r1 == 0.0 || r2 == 0.0) {
            return 0.0;
        }
        return 1.0 / r1 - 1.0 / r2;
    }

    public static double gaussian(double x, double y, double sigma) {
        double rSqr = x * x + y * y;
        return Math.exp(-rSqr / sigma / sigma / 2.0);
    }

    public static double saddle(double x, double y) {
        double rSqr = x * x - y * y;
        return Math.exp(rSqr);
    }

    public static double[][][] dipoleScalarField(GridPointData pointdata) {
        double[][][] data = pointdata.getData();
        int i = 0;
        int mx = data.length;
        while (i < mx) {
            int j = 0;
            int my = data[0].length;
            while (j < my) {
                data[i][j][2] = TestData.dipole(data[i][j][0], data[i][j][1]);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static double[][][] gaussianScalarField(GridPointData pointdata) {
        double[][][] data = pointdata.getData();
        int i = 0;
        int mx = data.length;
        while (i < mx) {
            int j = 0;
            int my = data[0].length;
            while (j < my) {
                data[i][j][2] = TestData.gaussian(data[i][j][0], data[i][j][1], 1.0);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static void randomScalarField(GridPointData pointdata) {
        double[][][] data = pointdata.getData();
        int i = 0;
        int mx = data.length;
        while (i < mx) {
            int j = 0;
            int my = data[0].length;
            while (j < my) {
                data[i][j][2] = Math.random();
                ++j;
            }
            ++i;
        }
    }

    public static double[] dipoleVector(double x, double y) {
        double[] vec = new double[2];
        double r1 = Math.sqrt((x - 1.0) * (x - 1.0) + y * y);
        double r2 = Math.sqrt((x + 1.0) * (x + 1.0) + y * y);
        if (r1 == 0.0 || r2 == 0.0) {
            return vec;
        }
        vec[0] = (x - 1.0) / r1 / r1 - (x + 1.0) / r2 / r2;
        vec[1] = y / r1 / r1 - y / r2 / r2;
        return vec;
    }

    public static double[][][] circulatingVectorField(int nx, int ny) {
        double[][][] data = new double[nx][ny][5];
        double xmin = -10.0;
        double xmax = 10.0;
        double ymin = -10.0;
        double ymax = 10.0;
        double x = xmin;
        double y = ymin;
        double stepx = (xmax - xmin) / (double)(nx - 1);
        double stepy = (ymax - ymin) / (double)(ny - 1);
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                data[i][j][0] = x;
                data[i][j][1] = y;
                double r = Math.sqrt(x * x + y * y);
                data[i][j][2] = -y / r;
                data[i][j][3] = x / r;
                data[i][j][4] = r;
                y += stepy;
                ++j;
            }
            y = ymin;
            x += stepx;
            ++i;
        }
        return data;
    }

    public static double[][][] dipoleVectorField(int nx, int ny, double xmin, double xmax, double ymin, double ymax) {
        double[][][] data = new double[nx][ny][5];
        double x = xmin;
        double y = ymin;
        double stepx = (xmax - xmin) / (double)(nx - 1);
        double stepy = (ymax - ymin) / (double)(ny - 1);
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                data[i][j][0] = x;
                data[i][j][1] = y;
                double[] vec = TestData.dipoleVector(x, y);
                double mag = Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]);
                data[i][j][2] = vec[0] / mag;
                data[i][j][3] = vec[1] / mag;
                data[i][j][4] = mag;
                y += stepy;
                ++j;
            }
            y = ymin;
            x += stepx;
            ++i;
        }
        return data;
    }
}

