/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.FlatData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class GridPlot
extends MeasuredImage
implements Plot2D {
    boolean autoscaleZ = true;
    boolean symmetricZ = false;
    GridData griddata;
    int[] rgbData;
    Grid grid;
    ColorMapper colorMap;
    private int ampIndex = 0;

    public GridPlot(GridData griddata) {
        this.setGridData(griddata);
    }

    public GridPlot() {
    }

    @Override
    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
    }

    @Override
    public GridData getGridData() {
        return this.griddata;
    }

    @Override
    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        if (this.colorMap == null) {
            this.colorMap = new ColorMapper(100, -1.0, 1.0, 0);
        }
        if (this.griddata == null) {
            return;
        }
        int nx = this.griddata.getNx();
        int ny = this.griddata.getNy();
        this.rgbData = new int[nx * ny];
        this.image = new BufferedImage(nx, ny, 2);
        Grid newgrid = new Grid(nx, ny);
        newgrid.setColor(Color.lightGray);
        if (this.grid != null) {
            newgrid.setColor(this.grid.getColor());
            newgrid.setVisible(this.grid.isVisible());
        } else {
            newgrid.setColor(Color.lightGray);
        }
        this.grid = newgrid;
        this.update();
    }

    @Override
    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    @Override
    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    @Override
    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    @Override
    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    @Override
    public void setAll(Object obj) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        this.update();
    }

    @Override
    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.setMinMax(xmin, xmax, ymin, ymax);
        this.update();
    }

    private void copyData(double[][] val) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != val.length || this.griddata.getNy() != val[0].length) {
            this.griddata = new ArrayData(val.length, val[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] data = this.griddata.getData()[0];
        int ny = data[0].length;
        int i = 0;
        int nx = data.length;
        while (i < nx) {
            System.arraycopy(val[i], 0, data[i], 0, ny);
            ++i;
        }
    }

    @Override
    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    @Override
    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(floor, ceil);
        }
    }

    @Override
    public void setSymmetricZ(boolean symmetric) {
        this.symmetricZ = symmetric;
    }

    @Override
    public boolean isSymmetricZ() {
        return this.symmetricZ;
    }

    @Override
    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    @Override
    public double getFloor() {
        return this.colorMap.getFloor();
    }

    @Override
    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    @Override
    public void setPaletteType(int type) {
        this.colorMap.setPaletteType(type);
    }

    @Override
    public void setColorPalette(Color[] colors) {
        this.colorMap.setColorPalette(colors);
    }

    @Override
    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.colorMap.setFloorCeilColor(floorColor, ceilColor);
    }

    @Override
    public void setShowGridLines(boolean showGrid) {
        if (this.grid != null) {
            this.grid.setVisible(showGrid);
        }
    }

    @Override
    public void setGridLineColor(Color c) {
        if (this.grid != null) {
            this.grid.setColor(c);
        }
    }

    @Override
    public void setExpandedZ(boolean expanded, double expansionFactor) {
        if (expanded && expansionFactor > 0.0) {
            ZExpansion zMap = new ZExpansion(expansionFactor);
            this.colorMap.setZMap(zMap);
        } else {
            this.colorMap.setZMap(null);
        }
    }

    @Override
    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            double ceil = minmax[1];
            double floor = minmax[0];
            if (this.symmetricZ) {
                ceil = Math.max(Math.abs(minmax[1]), Math.abs(minmax[0]));
                floor = -ceil;
            }
            this.colorMap.setScale(floor, ceil);
        }
        this.recolorImage();
        this.colorMap.updateLegend(null);
    }

    protected void recolorImage() {
        if (this.griddata == null) {
            return;
        }
        if (this.griddata.isCellData()) {
            double dx = this.griddata.getDx();
            double dy = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - dx / 2.0;
            this.xmax = this.griddata.getRight() + dx / 2.0;
            this.ymin = this.griddata.getBottom() + dy / 2.0;
            this.ymax = this.griddata.getTop() - dy / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        if (this.grid != null) {
            this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        }
        double[][][] data = this.griddata.getData();
        int nx = this.griddata.getNx();
        int ny = this.griddata.getNy();
        if (this.griddata instanceof GridPointData) {
            int index = this.ampIndex + 2;
            int j = 0;
            int count = 0;
            while (j < ny) {
                int i = 0;
                while (i < nx) {
                    this.rgbData[count] = this.colorMap.doubleToColor(data[i][j][index]).getRGB();
                    ++count;
                    ++i;
                }
                ++j;
            }
            this.image.setRGB(0, 0, nx, ny, this.rgbData, 0, nx);
        } else if (this.griddata instanceof ArrayData) {
            int j = 0;
            int count = 0;
            while (j < ny) {
                int i = 0;
                while (i < nx) {
                    this.rgbData[count] = this.colorMap.doubleToColor(data[this.ampIndex][i][j]).getRGB();
                    ++count;
                    ++i;
                }
                ++j;
            }
            this.image.setRGB(0, 0, nx, ny, this.rgbData, 0, nx);
        } else if (this.griddata instanceof FlatData) {
            int stride = data[0][0].length / (nx * ny);
            int j = 0;
            int count = 0;
            while (j < ny) {
                int offset = j * nx * stride;
                int i = 0;
                while (i < nx) {
                    this.rgbData[count] = this.colorMap.doubleToColor(data[0][0][offset + i * stride + this.ampIndex]).getRGB();
                    ++count;
                    ++i;
                }
                ++j;
            }
            this.image.setRGB(0, 0, nx, ny, this.rgbData, 0, nx);
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        super.draw(panel, g);
        this.grid.draw(panel, g);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            @Override
            public Object createObject(XMLControl control) {
                return new GridPlot(null);
            }

            @Override
            public void saveObject(XMLControl control, Object obj) {
                super.saveObject(control, obj);
                GridPlot plot = (GridPlot)obj;
                control.setValue("color map", plot.colorMap);
            }

            @Override
            public Object loadObject(XMLControl control, Object obj) {
                super.loadObject(control, obj);
                GridPlot plot = (GridPlot)obj;
                plot.colorMap = (ColorMapper)control.getObject("color map");
                return plot;
            }
        };
    }
}

