/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class ComplexGridPlot
extends MeasuredImage
implements Plot2D {
    boolean autoscaleZ = true;
    GridData griddata;
    int[] rgbData;
    Grid grid;
    ComplexColorMapper colorMap;
    private int ampIndex = 0;
    private int reIndex = 1;
    private int imIndex = 2;

    public ComplexGridPlot() {
        this((GridData)null);
    }

    public ComplexGridPlot(GridData _griddata) {
        this.griddata = _griddata;
        this.colorMap = new ComplexColorMapper(1.0);
        if (this.griddata == null) {
            return;
        }
        this.setGridData(this.griddata);
    }

    @Override
    public GridData getGridData() {
        return this.griddata;
    }

    @Override
    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    @Override
    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    @Override
    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    @Override
    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    @Override
    public void setAll(Object obj) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        this.update();
    }

    @Override
    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][][] val = (double[][][])obj;
        this.copyComplexData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.update();
    }

    private void copyComplexData(double[][][] vals) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != vals[0].length || this.griddata.getNy() != vals[0][0].length) {
            this.griddata = new ArrayData(vals[0].length, vals[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] mag = this.griddata.getData()[0];
        double[][] reData = this.griddata.getData()[1];
        double[][] imData = this.griddata.getData()[2];
        int ny = vals[0][0].length;
        int i = 0;
        int nx = vals[0].length;
        while (i < nx) {
            System.arraycopy(vals[0][i], 0, reData[i], 0, ny);
            System.arraycopy(vals[1][i], 0, imData[i], 0, ny);
            int j = 0;
            while (j < ny) {
                mag[i][j] = Math.sqrt(vals[0][i][j] * vals[0][i][j] + vals[1][i][j] * vals[1][i][j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        int nx = this.griddata.getNx();
        int ny = this.griddata.getNy();
        this.rgbData = new int[nx * ny];
        this.image = new BufferedImage(nx, ny, 2);
        Grid newgrid = new Grid(nx, ny);
        if (this.grid != null) {
            newgrid.setColor(this.grid.getColor());
            newgrid.setVisible(this.grid.isVisible());
        } else {
            newgrid.setColor(Color.lightGray);
        }
        this.grid = newgrid;
        this.update();
    }

    @Override
    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    @Override
    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(ceil);
        }
    }

    @Override
    public void setSymmetricZ(boolean symmetric) {
    }

    @Override
    public boolean isSymmetricZ() {
        return false;
    }

    @Override
    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    @Override
    public double getFloor() {
        return 0.0;
    }

    @Override
    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    @Override
    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.colorMap.setCeilColor(ceilColor);
    }

    @Override
    public void setShowGridLines(boolean showGrid) {
        if (this.grid == null) {
            this.grid = new Grid(1, 1);
        }
        this.grid.setVisible(showGrid);
    }

    @Override
    public void update() {
        if (this.autoscaleZ) {
            double[] minmax = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(minmax[1]);
        }
        this.recolorImage();
    }

    @Override
    public void setExpandedZ(boolean expanded, double expansionFactor) {
        if (expanded && expansionFactor > 0.0) {
            ZExpansion zMap = new ZExpansion(expansionFactor);
            this.colorMap.setZMap(zMap);
        } else {
            this.colorMap.setZMap(null);
        }
    }

    protected void recolorImage() {
        if (this.griddata == null) {
            return;
        }
        if (this.griddata.isCellData()) {
            double dx = this.griddata.getDx();
            double dy = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - dx / 2.0;
            this.xmax = this.griddata.getRight() + dx / 2.0;
            this.ymin = this.griddata.getBottom() + dy / 2.0;
            this.ymax = this.griddata.getTop() - dy / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        double[][][] data = this.griddata.getData();
        int nx = this.griddata.getNx();
        int ny = this.griddata.getNy();
        double[] samples = new double[3];
        if (this.griddata instanceof GridPointData) {
            int ampIndex = this.ampIndex + 2;
            int reIndex = this.reIndex + 2;
            int imIndex = this.imIndex + 2;
            int iy = 0;
            int count = 0;
            while (iy < ny) {
                int ix = 0;
                while (ix < nx) {
                    samples[0] = data[ix][iy][ampIndex];
                    samples[1] = data[ix][iy][reIndex];
                    samples[2] = data[ix][iy][imIndex];
                    this.rgbData[count] = this.colorMap.samplesToColor(samples).getRGB();
                    ++count;
                    ++ix;
                }
                ++iy;
            }
        } else if (this.griddata instanceof ArrayData) {
            int iy = 0;
            int count = 0;
            while (iy < ny) {
                int ix = 0;
                while (ix < nx) {
                    samples[0] = data[this.ampIndex][ix][iy];
                    samples[1] = data[this.reIndex][ix][iy];
                    samples[2] = data[this.imIndex][ix][iy];
                    this.rgbData[count] = this.colorMap.samplesToColor(samples).getRGB();
                    ++count;
                    ++ix;
                }
                ++iy;
            }
        }
        this.image.setRGB(0, 0, nx, ny, this.rgbData, 0, nx);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        super.draw(panel, g);
        this.grid.draw(panel, g);
    }

    @Override
    public void setColorPalette(Color[] colors) {
    }

    @Override
    public void setPaletteType(int type) {
    }

    @Override
    public void setGridLineColor(Color c) {
        if (this.grid == null) {
            this.grid = new Grid(1, 1);
        }
        this.grid.setColor(c);
    }

    @Override
    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
        this.reIndex = indexes[1];
        this.imIndex = indexes[2];
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            @Override
            public Object createObject(XMLControl control) {
                return new ComplexGridPlot(null);
            }
        };
    }
}

