/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.ZExpansion;

public class ComplexColorMapper {
    static final double PI2 = Math.PI * 2;
    static final double COLOR_ERR = 1.0E-9;
    private double ceil;
    private Color ceilColor = Color.lightGray;
    private JFrame legendFrame;
    int[] reds = new int[256];
    int[] greens = new int[256];
    int[] blues = new int[256];
    protected ZExpansion zMap = null;

    public ComplexColorMapper(double _ceil) {
        this.ceil = _ceil;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
        this.initColors();
    }

    public static JFrame showPhaseLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setPreferredGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        JFrame legendFrame = new JFrame("Complex Phase");
        legendFrame.setResizable(false);
        legendFrame.setContentPane(dp);
        int numPts = 360;
        GridPointData pointdata = new GridPointData(numPts, 1, 3);
        double[][][] data = pointdata.getData();
        double theta = -Math.PI;
        double delta = Math.PI * 2 / (double)numPts;
        int i = 0;
        int n = data.length;
        while (i < n) {
            data[i][0][2] = 0.999;
            data[i][0][3] = Math.cos(theta);
            data[i][0][4] = Math.sin(theta);
            theta += delta;
            ++i;
        }
        pointdata.setScale(-Math.PI, Math.PI, 0.0, 1.0);
        ComplexGridPlot plot = new ComplexGridPlot(pointdata);
        plot.setShowGridLines(false);
        plot.update();
        dp.addDrawable(plot);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        legendFrame.pack();
        legendFrame.setVisible(true);
        return legendFrame;
    }

    public JFrame showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 66));
        dp.setPreferredGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame("Complex Phase");
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        int numPts = 360;
        GridPointData pointdata = new GridPointData(numPts, 1, 3);
        double[][][] data = pointdata.getData();
        double theta = -Math.PI;
        double delta = Math.PI * 2 / (double)numPts;
        int i = 0;
        int n = data.length;
        while (i < n) {
            data[i][0][2] = 0.999;
            data[i][0][3] = Math.cos(theta);
            data[i][0][4] = Math.sin(theta);
            theta += delta;
            ++i;
        }
        pointdata.setScale(-Math.PI, Math.PI, 0.0, 1.0);
        ComplexGridPlot plot = new ComplexGridPlot(pointdata);
        plot.setShowGridLines(false);
        plot.update();
        dp.addDrawable(plot);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setScale(double _ceil) {
        this.ceil = _ceil;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
    }

    public byte[] samplesToComponents(double[] samples, byte[] rgb) {
        Color color = this.samplesToColor(samples);
        rgb[0] = (byte)color.getRed();
        rgb[1] = (byte)color.getGreen();
        rgb[2] = (byte)color.getBlue();
        return rgb;
    }

    public Color phaseToColor(double phi) {
        float b = 1.0f;
        float h = (float)((Math.PI + phi) / (Math.PI * 2));
        int index = (int)(255.0f * h);
        return new Color((int)(b * (float)this.reds[index]), (int)(b * (float)this.greens[index]), (int)(b * (float)this.blues[index]));
    }

    public Color complexToColor(double re, double im) {
        float b = 1.0f;
        float h = (float)((Math.PI + Math.atan2(im, re)) / (Math.PI * 2));
        int index = (int)(255.0f * h);
        return new Color((int)(b * (float)this.reds[index]), (int)(b * (float)this.greens[index]), (int)(b * (float)this.blues[index]));
    }

    public Color samplesToColor(double[] samples) {
        double zval = samples[0];
        if (this.zMap != null) {
            zval = this.zMap.evaluate(zval);
        }
        if (zval <= 0.0) {
            return Color.black;
        }
        if (this.zMap == null && zval > this.ceil + 1.0E-9) {
            return this.ceilColor;
        }
        zval = Math.min(zval, this.ceil);
        float b = (float)(zval / this.ceil);
        float h = (float)((Math.PI + Math.atan2(samples[2], samples[1])) / (Math.PI * 2));
        int index = (int)(255.0f * h);
        return new Color((int)(b * (float)this.reds[index]), (int)(b * (float)this.greens[index]), (int)(b * (float)this.blues[index]));
    }

    public Color pointToColor(double[] vertex) {
        double zval = vertex[2];
        if (this.zMap != null) {
            zval = this.zMap.evaluate(zval);
        }
        if (zval <= 0.0) {
            return Color.black;
        }
        if (zval > this.ceil + 1.0E-9) {
            return this.ceilColor;
        }
        float b = (float)(zval / this.ceil);
        float h = (float)((Math.PI + Math.atan2(vertex[4], vertex[3])) / (Math.PI * 2));
        int index = (int)(255.0f * h);
        return new Color((int)(b * (float)this.reds[index]), (int)(b * (float)this.greens[index]), (int)(b * (float)this.blues[index]));
    }

    public void setZMap(ZExpansion map) {
        this.zMap = map;
        if (this.zMap != null) {
            this.zMap.setMinMax(0.0, this.ceil);
        }
    }

    public double getCeil() {
        return this.ceil;
    }

    public Color getCeilColor() {
        return this.ceilColor;
    }

    public void setCeilColor(Color _ceilColor) {
        this.ceilColor = _ceilColor;
    }

    private void initColors() {
        double pi = Math.PI;
        int i = 0;
        while (i < 256) {
            double val = Math.abs(Math.sin(pi * (double)i / 255.0));
            this.blues[i] = (int)(255.0 * val * val);
            val = Math.abs(Math.sin(pi * (double)i / 255.0 + pi / 3.0));
            this.greens[i] = (int)(255.0 * val * val * Math.sqrt(val));
            val = Math.abs(Math.sin(pi * (double)i / 255.0 + 2.0 * pi / 3.0));
            this.reds[i] = (int)(255.0 * val * val);
            ++i;
        }
    }
}

