/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;

public class PrintUtils {
    private PrintUtils() {
    }

    public static void saveComponentAsEPS(Component c) throws IOException {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String format = "application/postscript";
        StreamPrintServiceFactory factory = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, format)[0];
        JFileChooser chooser = OSPRuntime.getChooser();
        if (chooser.showSaveDialog(c) != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        FileOutputStream out = new FileOutputStream(f);
        StreamPrintService service = factory.getPrintService(out);
        PrintUtils.printToService(c, service, null);
        out.close();
    }

    public static void printComponent(Component c) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        HashPrintRequestAttributeSet printAttributes = new HashPrintRequestAttributeSet();
        printAttributes.add(OrientationRequested.PORTRAIT);
        printAttributes.add(Chromaticity.MONOCHROME);
        printAttributes.add(PrintQuality.HIGH);
        PrintService service = ServiceUI.printDialog(null, 100, 100, services, null, null, printAttributes);
        if (service == null) {
            return;
        }
        PrintUtils.printToService(c, service, printAttributes);
    }

    public static void printToService(Component c, PrintService service, PrintRequestAttributeSet printAttributes) {
        PrintableComponent printable = new PrintableComponent(c);
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        SimpleDoc doc = new SimpleDoc(printable, flavor, null);
        DocPrintJob job = service.createPrintJob();
        final JOptionPane pane = new JOptionPane(DisplayRes.getString("PrintUtils.Printing.Message"), -1);
        JDialog dialog = pane.createDialog(c, DisplayRes.getString("PrintUtils.PrintDialog.Title"));
        job.addPrintJobListener(new PrintJobAdapter(){

            @Override
            public void printJobCompleted(PrintJobEvent e) {
                pane.setMessage(DisplayRes.getString("PrintUtils.PrintComplete.Message"));
            }

            @Override
            public void printDataTransferCompleted(PrintJobEvent e) {
                pane.setMessage(DisplayRes.getString("PrintUtils.PrintTransferred.Message"));
            }

            @Override
            public void printJobRequiresAttention(PrintJobEvent e) {
                pane.setMessage(DisplayRes.getString("PrintUtils.OutOfPaper.Message"));
            }

            @Override
            public void printJobFailed(PrintJobEvent e) {
                pane.setMessage(DisplayRes.getString("PrintUtils.PrintFailed.Message"));
            }
        });
        dialog.setModal(false);
        dialog.setVisible(true);
        try {
            job.print(doc, printAttributes);
        }
        catch (PrintException e) {
            pane.setMessage(e.toString());
        }
    }

    public static class PrintableComponent
    implements Printable {
        Component c;

        public PrintableComponent(Component c) {
            this.c = c;
        }

        @Override
        public int print(Graphics g, PageFormat format, int pagenum) {
            double factor;
            if (pagenum > 0) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(format.getImageableX(), format.getImageableY());
            Dimension size = this.c.getSize();
            double pageWidth = format.getImageableWidth();
            double pageHeight = format.getImageableHeight();
            if ((double)size.width > pageWidth) {
                factor = pageWidth / (double)size.width;
                g2.scale(factor, factor);
                pageWidth /= factor;
                pageHeight /= factor;
            }
            if ((double)size.height > pageHeight) {
                factor = pageHeight / (double)size.height;
                g2.scale(factor, factor);
                pageWidth /= factor;
                pageHeight /= factor;
            }
            g2.translate((pageWidth - (double)size.width) / 2.0, (pageHeight - (double)size.height) / 2.0);
            g2.drawRect(-1, -1, size.width + 2, size.height + 2);
            g2.setClip(0, 0, size.width, size.height);
            this.c.paint(g);
            return 0;
        }
    }
}

