/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataTableModel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.SortDecorator;
import org.opensourcephysics.display.TeXParser;

public class DataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final String NO_PATTERN = DisplayRes.getString("DataTable.FormatDialog.NoFormat");
    public static String rowName = DisplayRes.getString("DataTable.Header.Row");
    private final SortDecorator decorator;
    protected HashMap<String, PrecisionRenderer> precisionRenderersByColumnName = new HashMap();
    protected HashMap<String, UnitRenderer> unitRenderersByColumnName = new HashMap();
    DataTableModel dataTableModel;
    protected RowNumberRenderer rowNumberRenderer;
    int maximumFractionDigits = 3;
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    protected int labelColumnWidth = 40;
    protected int minimumDataColumnWidth = 24;
    protected NumberFormatDialog formatDialog;
    protected int clickCountToSort = 1;
    protected int sortedColumn;

    public DataTable() {
        this(new DefaultDataTableModel());
    }

    public DataTable(DataTableModel model) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(model);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader header = this.getTableHeader();
        header.setForeground(Color.blue);
        HeaderRenderer headerRenderer = new HeaderRenderer(this.getTableHeader().getDefaultRenderer());
        this.getTableHeader().setDefaultRenderer(headerRenderer);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.decorator = new SortDecorator(this.getModel());
        this.setModel(this.decorator);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel tcm;
                int vc;
                int mc;
                if (!(OSPRuntime.isPopupTrigger(e) || e.isControlDown() || e.isShiftDown() || e.getClickCount() != DataTable.this.clickCountToSort || DataTable.this.sortedColumn == (mc = DataTable.this.convertColumnIndexToModel(vc = (tcm = DataTable.this.getColumnModel()).getColumnIndexAtX(e.getX()))))) {
                    DataTable.this.decorator.sort(mc);
                    DataTable.this.sortedColumn = mc;
                }
            }
        });
    }

    public void setMaximumFractionDigits(String columnName, int maximumFractionDigits) {
        this.precisionRenderersByColumnName.put(columnName, new PrecisionRenderer(maximumFractionDigits));
    }

    public void setFormatPattern(String columnName, String pattern) {
        if (pattern == null || pattern.equals("")) {
            this.precisionRenderersByColumnName.remove(columnName);
        } else {
            this.precisionRenderersByColumnName.put(columnName, new PrecisionRenderer(pattern));
        }
        this.firePropertyChange("format", null, columnName);
    }

    public void setUnits(String columnName, String units, String tooltip) {
        if (units == null) {
            this.unitRenderersByColumnName.remove(columnName);
        } else {
            TableCellRenderer renderer = this.getDefaultRenderer(Double.class);
            for (String next : this.precisionRenderersByColumnName.keySet()) {
                if (!next.equals(columnName)) continue;
                renderer = this.precisionRenderersByColumnName.get(columnName);
            }
            UnitRenderer unitRenderer = new UnitRenderer(renderer, units, tooltip);
            this.unitRenderersByColumnName.put(columnName, unitRenderer);
        }
    }

    public String getFormatPattern(String columnName) {
        PrecisionRenderer r = this.precisionRenderersByColumnName.get(columnName);
        return r == null ? "" : r.pattern;
    }

    public String[] getFormattedColumnNames() {
        return this.precisionRenderersByColumnName.keySet().toArray(new String[0]);
    }

    public Object getFormattedValueAt(int row, int col) {
        Object value = this.getValueAt(row, col);
        if (value == null) {
            return null;
        }
        TableCellRenderer renderer = this.getCellRenderer(row, col);
        Component c = renderer.getTableCellRendererComponent(this, value, false, false, 0, 0);
        if (c instanceof JLabel) {
            int n;
            String units;
            String s = ((JLabel)c).getText().trim();
            if (renderer instanceof UnitRenderer && !"".equals(units = ((UnitRenderer)renderer).units) && (n = s.lastIndexOf(units)) > -1) {
                s = s.substring(0, n);
            }
            return s;
        }
        return value;
    }

    public NumberFormatDialog getFormatDialog(String[] names, String[] selected) {
        if (this.formatDialog == null) {
            this.formatDialog = new NumberFormatDialog();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.formatDialog.getBounds().width) / 2;
            int y = (dim.height - this.formatDialog.getBounds().height) / 2;
            this.formatDialog.setLocation(x, y);
        }
        this.formatDialog.setColumns(names, selected);
        return this.formatDialog;
    }

    public void sort(int col) {
        this.decorator.sort(col);
        this.sortedColumn = col;
    }

    public int getSortedColumn() {
        return this.decorator.getSortedColumn();
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.setDefaultRenderer(Double.class, new PrecisionRenderer(maximumFractionDigits));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setRowNumberVisible(boolean _rowNumberVisible) {
        if (this.dataTableModel.isRowNumberVisible() != _rowNumberVisible) {
            if (_rowNumberVisible && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(_rowNumberVisible);
        }
    }

    public void setModel(DataTableModel _model) {
        super.setModel(_model);
        this.dataTableModel = _model;
    }

    public void setStride(TableModel tableModel, int stride) {
        this.dataTableModel.setStride(tableModel, stride);
    }

    public void setColumnVisible(TableModel tableModel, int columnIndex, boolean b) {
        this.dataTableModel.setColumnVisible(tableModel, columnIndex, b);
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer baseRenderer;
        UnitRenderer unitRenderer;
        block9: {
            int i = this.convertColumnIndexToModel(column);
            if (i == 0 && this.dataTableModel.isRowNumberVisible()) {
                return this.rowNumberRenderer;
            }
            unitRenderer = null;
            baseRenderer = null;
            try {
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                for (String columnName : this.unitRenderersByColumnName.keySet()) {
                    if (!tableColumn.getHeaderValue().equals(columnName)) continue;
                    unitRenderer = this.unitRenderersByColumnName.get(columnName);
                    break;
                }
                baseRenderer = tableColumn.getCellRenderer();
                if (baseRenderer != null) break block9;
                for (String columnName : this.precisionRenderersByColumnName.keySet()) {
                    if (tableColumn.getHeaderValue().equals(columnName)) {
                        baseRenderer = this.precisionRenderersByColumnName.get(columnName);
                    } else {
                        if (!tableColumn.getHeaderValue().equals(String.valueOf(columnName) + "'")) continue;
                        baseRenderer = this.precisionRenderersByColumnName.get(columnName);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (baseRenderer == null) {
            baseRenderer = this.getDefaultRenderer(this.getColumnClass(column));
        }
        if (unitRenderer != null) {
            unitRenderer.setBaseRenderer(baseRenderer);
            return unitRenderer;
        }
        return baseRenderer;
    }

    public TableCellRenderer getPrecisionRenderer(String columnName) {
        return this.precisionRenderersByColumnName.get(columnName);
    }

    public void setRefreshDelay(int delay) {
        if (delay > 0) {
            this.refreshTimer.setDelay(delay);
            this.refreshTimer.setInitialDelay(delay);
        } else if (delay <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = delay;
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable doRefreshTable = new Runnable(){

                @Override
                public synchronized void run() {
                    DataTable.this.actionPerformed(null);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                doRefreshTable.run();
            } else {
                SwingUtilities.invokeLater(doRefreshTable);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int[] newColumnWidths;
        int[] newModelIndexes;
        int n;
        TableColumnModel model = this.getColumnModel();
        int colCount = model.getColumnCount();
        int[] modelIndexes = new int[colCount];
        int[] columnWidths = new int[colCount];
        ArrayList<Object> columnNames = new ArrayList<Object>();
        int i = 0;
        while (i < colCount) {
            TableColumn column = model.getColumn(i);
            modelIndexes[i] = column.getModelIndex();
            columnWidths[i] = column.getWidth();
            columnNames.add(column.getHeaderValue());
            ++i;
        }
        this.tableChanged(new TableModelEvent(this.dataTableModel, -1));
        int newCount = model.getColumnCount();
        ArrayList<Object> newColumnNames = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < newCount) {
            TableColumn column = model.getColumn(i2);
            newColumnNames.add(column.getHeaderValue());
            ++i2;
        }
        TreeSet<Integer> removedIndexes = new TreeSet<Integer>();
        int i3 = 0;
        while (i3 < colCount) {
            if (!newColumnNames.contains(columnNames.get(i3))) {
                removedIndexes.add(modelIndexes[i3]);
            }
            ++i3;
        }
        TreeSet<Integer> addedIndexes = new TreeSet<Integer>();
        int i4 = 0;
        while (i4 < newCount) {
            if (!columnNames.contains(newColumnNames.get(i4))) {
                addedIndexes.add(i4);
            }
            ++i4;
        }
        while (!removedIndexes.isEmpty()) {
            n = (Integer)removedIndexes.last();
            removedIndexes.remove(n);
            newModelIndexes = new int[colCount - 1];
            newColumnWidths = new int[colCount - 1];
            int k = 0;
            int i5 = 0;
            while (i5 < colCount) {
                if (modelIndexes[i5] != n) {
                    newModelIndexes[k] = modelIndexes[i5] > n ? modelIndexes[i5] - 1 : modelIndexes[i5];
                    newColumnWidths[k] = columnWidths[i5];
                    ++k;
                }
                ++i5;
            }
            modelIndexes = newModelIndexes;
            columnWidths = newColumnWidths;
            colCount = modelIndexes.length;
        }
        while (!addedIndexes.isEmpty()) {
            n = (Integer)addedIndexes.first();
            addedIndexes.remove(n);
            newModelIndexes = new int[colCount + 1];
            newColumnWidths = new int[colCount + 1];
            int i6 = 0;
            while (i6 < colCount) {
                newModelIndexes[i6] = modelIndexes[i6] >= n ? modelIndexes[i6] + 1 : modelIndexes[i6];
                newColumnWidths[i6] = columnWidths[i6];
                ++i6;
            }
            newModelIndexes[colCount] = n;
            newColumnWidths[colCount] = model.getColumn(n).getWidth();
            modelIndexes = newModelIndexes;
            columnWidths = newColumnWidths;
            colCount = modelIndexes.length;
        }
        int targetIndex = 0;
        while (targetIndex < colCount) {
            int i7 = 0;
            while (i7 < colCount) {
                if (model.getColumn(i7).getModelIndex() == modelIndexes[targetIndex]) {
                    model.moveColumn(i7, targetIndex);
                    break;
                }
                ++i7;
            }
            ++targetIndex;
        }
        i4 = 0;
        while (i4 < columnWidths.length) {
            model.getColumn(i4).setPreferredWidth(columnWidths[i4]);
            model.getColumn(i4).setWidth(columnWidths[i4]);
            ++i4;
        }
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add(tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(columnIndex);
            }
            catch (Exception ex) {
                return new TableColumn();
            }
            String headerValue = (String)tableColumn.getHeaderValue();
            if (headerValue == null) {
                return tableColumn;
            }
            if (headerValue.equals(rowName) && tableColumn.getModelIndex() == 0) {
                tableColumn.setMaxWidth(DataTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataTable.this.labelColumnWidth);
                tableColumn.setResizable(false);
            } else {
                tableColumn.setMinWidth(DataTable.this.minimumDataColumnWidth);
            }
            return tableColumn;
        }
    }

    private static class DataTableElement {
        TableModel tableModel;
        boolean[] columnVisibilities;
        int stride = 1;

        public DataTableElement(TableModel t) {
            this.tableModel = t;
        }

        public void setStride(int _stride) {
            this.stride = _stride;
        }

        public void setColumnVisible(int columnIndex, boolean visible) {
            this.ensureCapacity(columnIndex + 1);
            this.columnVisibilities[columnIndex] = visible;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean[] getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public int getColumnCount() {
            int count = 0;
            int numberOfColumns = this.tableModel.getColumnCount();
            this.ensureCapacity(numberOfColumns);
            int i = 0;
            while (i < numberOfColumns) {
                boolean visible = this.columnVisibilities[i];
                if (visible) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tableModel.getValueAt(rowIndex, columnIndex);
        }

        public String getColumnName(int columnIndex) {
            return this.tableModel.getColumnName(columnIndex);
        }

        public Class<?> getColumnClass(int columnIndex) {
            return this.tableModel.getColumnClass(columnIndex);
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        private void ensureCapacity(int minimumCapacity) {
            if (this.columnVisibilities == null) {
                this.columnVisibilities = new boolean[minimumCapacity * 3 / 2 + 1];
                Arrays.fill(this.columnVisibilities, true);
            } else if (this.columnVisibilities.length < minimumCapacity) {
                boolean[] temp = this.columnVisibilities;
                this.columnVisibilities = new boolean[minimumCapacity * 3 / 2 + 1];
                System.arraycopy(temp, 0, this.columnVisibilities, 0, temp.length);
                Arrays.fill(this.columnVisibilities, temp.length, this.columnVisibilities.length, true);
            }
        }
    }

    protected static class DefaultDataTableModel
    implements DataTableModel {
        ArrayList<DataTableElement> dataTableElements = new ArrayList();
        boolean rowNumberVisible = false;

        protected DefaultDataTableModel() {
        }

        @Override
        public void setColumnVisible(TableModel tableModel, int columnIndex, boolean b) {
            DataTableElement dte = this.findElementContaining(tableModel);
            dte.setColumnVisible(columnIndex, b);
        }

        @Override
        public void setStride(TableModel tableModel, int stride) {
            DataTableElement dte = this.findElementContaining(tableModel);
            dte.setStride(stride);
        }

        @Override
        public void setRowNumberVisible(boolean _rowNumberVisible) {
            this.rowNumberVisible = _rowNumberVisible;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (this.dataTableElements.size() == 0) {
                return;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return;
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            int stride = dte.getStride();
            if ((rowIndex *= stride) >= dte.getRowCount()) {
                return;
            }
            dte.tableModel.setValueAt(value, rowIndex, mfr.column);
        }

        @Override
        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return rowName;
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            String name = dte.getColumnName(mfr.column);
            return name;
        }

        @Override
        public int getRowCount() {
            int rowCount = 0;
            int i = 0;
            while (i < this.dataTableElements.size()) {
                DataTableElement dte = this.dataTableElements.get(i);
                int stride = dte.getStride();
                rowCount = Math.max(rowCount, (dte.getRowCount() + stride - 1) / stride);
                ++i;
            }
            return rowCount;
        }

        @Override
        public int getColumnCount() {
            int columnCount = 0;
            int i = 0;
            while (i < this.dataTableElements.size()) {
                DataTableElement dte = this.dataTableElements.get(i);
                columnCount += dte.getColumnCount();
                ++i;
            }
            if (this.rowNumberVisible) {
                ++columnCount;
            }
            return columnCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return new Integer(rowIndex);
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            int stride = dte.getStride();
            if ((rowIndex *= stride) >= dte.getRowCount()) {
                return null;
            }
            return dte.getValueAt(rowIndex, mfr.column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.rowNumberVisible && columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 0 && this.rowNumberVisible) {
                --columnIndex;
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            return dte.getColumnClass(mfr.column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void remove(TableModel tableModel) {
            DataTableElement dte = this.findElementContaining(tableModel);
            this.dataTableElements.remove(dte);
        }

        @Override
        public void clear() {
            this.dataTableElements.clear();
        }

        @Override
        public void add(TableModel tableModel) {
            this.dataTableElements.add(new DataTableElement(tableModel));
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        private DataTableElement findElementContaining(TableModel tableModel) {
            int i = 0;
            while (i < this.dataTableElements.size()) {
                DataTableElement dte = this.dataTableElements.get(i);
                if (dte.tableModel == tableModel) {
                    return dte;
                }
                ++i;
            }
            return null;
        }
    }

    class HeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer renderer;
        DrawingPanel panel = new DrawingPanel();
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -6.0);

        public HeaderRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
            this.textLine.setJustification(0);
            this.panel.addDrawable(this.textLine);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c;
            String name;
            String string = name = value == null ? "" : value.toString();
            if (OSPRuntime.isMac()) {
                name = TeXParser.removeSubscripting(name);
            }
            if (!((c = this.renderer.getTableCellRendererComponent(table, name, isSelected, hasFocus, row, col)) instanceof JComponent)) {
                return c;
            }
            JComponent comp = (JComponent)c;
            int sortCol = DataTable.this.decorator.getSortedColumn();
            Font font = comp.getFont();
            if (OSPRuntime.isMac()) {
                comp.setFont(sortCol != DataTable.this.convertColumnIndexToModel(col) ? font.deriveFont(0) : font.deriveFont(1));
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setHorizontalAlignment(0);
                }
                return comp;
            }
            this.textLine.setText(name);
            Dimension dim = comp.getPreferredSize();
            ++dim.height;
            this.panel.setPreferredSize(dim);
            Border border = comp.getBorder();
            if (border instanceof EmptyBorder) {
                border = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
            }
            this.panel.setBorder(border);
            this.textLine.setFont(sortCol != DataTable.this.convertColumnIndexToModel(col) ? font : font.deriveFont(1));
            this.textLine.setColor(comp.getForeground());
            this.textLine.setBackground(comp.getBackground());
            this.panel.setBackground(comp.getBackground());
            return this.panel;
        }
    }

    private static class ModelFilterResult {
        DataTableElement tableElement;
        int column;

        public ModelFilterResult(DataTableElement _tableElement, int _column) {
            this.tableElement = _tableElement;
            this.column = _column;
        }

        public static ModelFilterResult find(boolean rowNumberVisible, ArrayList<DataTableElement> dataTableElements, int tableColumnIndex) {
            if (rowNumberVisible) {
                --tableColumnIndex;
            }
            int totalColumns = 0;
            int i = 0;
            while (i < dataTableElements.size()) {
                DataTableElement dte = dataTableElements.get(i);
                dte.ensureCapacity(tableColumnIndex);
                int columnCount = dte.getColumnCount();
                if ((totalColumns += columnCount) > tableColumnIndex) {
                    int columnIndex = columnCount + tableColumnIndex - totalColumns;
                    boolean[] visible = dte.getColumnVisibilities();
                    int j = 0;
                    while (j < tableColumnIndex) {
                        if (!visible[j]) {
                            ++columnIndex;
                        }
                        ++j;
                    }
                    return new ModelFilterResult(dte, columnIndex);
                }
                ++i;
            }
            return null;
        }
    }

    public class NumberFormatDialog
    extends JDialog {
        JButton closeButton;
        JButton cancelButton;
        JButton helpButton;
        JButton applyButton;
        JLabel patternLabel;
        JLabel sampleLabel;
        JTextField patternField;
        JTextField sampleField;
        DecimalFormat sampleFormat;
        String[] displayedNames;
        Map<String, String> realNames;
        Map<String, String> prevPatterns;
        JList columnList;
        JScrollPane columnScroller;

        NumberFormatDialog() {
            super(JOptionPane.getFrameForComponent(DataTable.this), true);
            this.realNames = new HashMap<String, String>();
            this.prevPatterns = new HashMap<String, String>();
            this.setLayout(new BorderLayout());
            this.setTitle(DisplayRes.getString("DataTable.NumberFormat.Dialog.Title"));
            this.sampleFormat = (DecimalFormat)NumberFormat.getNumberInstance();
            this.closeButton = new JButton(DisplayRes.getString("Dialog.Button.Close.Text"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.applyButton = new JButton(DisplayRes.getString("Dialog.Button.Apply.Text"));
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(e);
                }
            });
            this.cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] stringArray = NumberFormatDialog.this.displayedNames;
                    int n = NumberFormatDialog.this.displayedNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String displayedName = stringArray[n2];
                        String name = NumberFormatDialog.this.realNames.get(displayedName);
                        DataTable.this.setFormatPattern(name, NumberFormatDialog.this.prevPatterns.get(name));
                        ++n2;
                    }
                    DataTable.this.refreshTable();
                    NumberFormatDialog.this.setVisible(false);
                }
            });
            this.helpButton = new JButton(DisplayRes.getString("GUIUtils.Help"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String tab = "      ";
                    String nl = System.getProperty("line.separator", "/n");
                    JOptionPane.showMessageDialog(((NumberFormatDialog)NumberFormatDialog.this).DataTable.this.formatDialog, String.valueOf(DisplayRes.getString("DataTable.NumberFormat.Help.Message1")) + nl + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message2") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message3") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message4") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message5") + nl + nl + DisplayRes.getString("DataTable.NumberFormat.Help.Message6") + " PI.", DisplayRes.getString("DataTable.NumberFormat.Help.Title"), 1);
                }
            });
            this.patternLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Format"));
            this.sampleLabel = new JLabel(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Sample"));
            this.patternField = new JTextField(6);
            this.patternField.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String pattern = NumberFormatDialog.this.patternField.getText();
                    if (pattern.indexOf(NO_PATTERN) > -1) {
                        pattern = "";
                    }
                    int i = 1;
                    while (i < 10) {
                        pattern = pattern.replaceAll(String.valueOf(i), "0");
                        ++i;
                    }
                    i = pattern.indexOf("0e0");
                    if (i > -1) {
                        pattern = String.valueOf(pattern.substring(0, i)) + "0E0" + pattern.substring(i + 3);
                    }
                    try {
                        Object[] selectedColumns;
                        NumberFormatDialog.this.showNumberFormatAndSample(pattern);
                        Object[] objectArray = selectedColumns = NumberFormatDialog.this.columnList.getSelectedValues();
                        int n = selectedColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object displayedName = objectArray[n2];
                            String name = NumberFormatDialog.this.realNames.get(displayedName.toString());
                            DataTable.this.setFormatPattern(name, pattern);
                            ++n2;
                        }
                        DataTable.this.refreshTable();
                    }
                    catch (RuntimeException ex) {
                        NumberFormatDialog.this.patternField.setBackground(new Color(255, 153, 153));
                        NumberFormatDialog.this.patternField.setText(pattern);
                        return;
                    }
                }
            });
            this.patternField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        NumberFormatDialog.this.patternField.setBackground(Color.white);
                    } else {
                        NumberFormatDialog.this.patternField.setBackground(Color.yellow);
                        Runnable runner = new Runnable(){

                            @Override
                            public void run() {
                                String pattern = (this).NumberFormatDialog.this.patternField.getText();
                                if (pattern.indexOf(NO_PATTERN) > -1) {
                                    pattern = "";
                                }
                                int i = 1;
                                while (i < 10) {
                                    pattern = pattern.replaceAll(String.valueOf(i), "0");
                                    ++i;
                                }
                                i = pattern.indexOf("0e0");
                                if (i > -1) {
                                    pattern = String.valueOf(pattern.substring(0, i)) + "0E0" + pattern.substring(i + 3);
                                }
                                if (pattern.equals("") || pattern.equals(NO_PATTERN)) {
                                    TableCellRenderer renderer = DataTable.this.getDefaultRenderer(Double.class);
                                    Component c = renderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                                    if (c instanceof JLabel) {
                                        String text = ((JLabel)c).getText();
                                        (this).NumberFormatDialog.this.sampleField.setText(text);
                                    }
                                } else {
                                    try {
                                        (this).NumberFormatDialog.this.sampleFormat.applyPattern(pattern);
                                        (this).NumberFormatDialog.this.sampleField.setText((this).NumberFormatDialog.this.sampleFormat.format(Math.PI));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runner);
                    }
                }
            });
            this.patternField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(null);
                }
            });
            this.sampleField = new JTextField(6);
            this.sampleField.setEditable(false);
            this.columnScroller = new JScrollPane();
            this.columnScroller.setPreferredSize(new Dimension(160, 120));
            JPanel formatPanel = new JPanel(new GridLayout());
            JPanel patternPanel = new JPanel();
            patternPanel.add(this.patternLabel);
            patternPanel.add(this.patternField);
            formatPanel.add(patternPanel);
            JPanel samplePanel = new JPanel();
            samplePanel.add(this.sampleLabel);
            samplePanel.add(this.sampleField);
            formatPanel.add(samplePanel);
            this.add((Component)formatPanel, "North");
            JPanel columnPanel = new JPanel(new BorderLayout());
            columnPanel.setBorder(BorderFactory.createTitledBorder(DisplayRes.getString("DataTable.FormatDialog.ApplyTo.Title")));
            columnPanel.add((Component)this.columnScroller, "Center");
            this.add((Component)columnPanel, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.helpButton);
            buttonPanel.add(this.applyButton);
            buttonPanel.add(this.closeButton);
            buttonPanel.add(this.cancelButton);
            this.add((Component)buttonPanel, "South");
            this.pack();
        }

        private void showNumberFormatAndSample(int[] selectedIndices) {
            if (selectedIndices == null || selectedIndices.length == 0) {
                this.showNumberFormatAndSample("");
            } else if (selectedIndices.length == 1) {
                String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
                String pattern = DataTable.this.getFormatPattern(name);
                this.showNumberFormatAndSample(pattern);
            } else {
                String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
                String pattern = DataTable.this.getFormatPattern(name);
                int i = 1;
                while (i < selectedIndices.length) {
                    name = this.realNames.get(this.displayedNames[selectedIndices[i]]);
                    if (!pattern.equals(DataTable.this.getFormatPattern(name))) {
                        pattern = null;
                        break;
                    }
                    ++i;
                }
                this.showNumberFormatAndSample(pattern);
            }
        }

        private void showNumberFormatAndSample(String pattern) {
            if (pattern == null) {
                this.sampleField.setText("");
                this.patternField.setText("");
                return;
            }
            if (pattern.equals("") || pattern.equals(NO_PATTERN)) {
                TableCellRenderer renderer = DataTable.this.getDefaultRenderer(Double.class);
                Component c = renderer.getTableCellRendererComponent(DataTable.this, Math.PI, false, false, 0, 0);
                if (c instanceof JLabel) {
                    String text = ((JLabel)c).getText();
                    this.sampleField.setText(text);
                }
                this.patternField.setText(NO_PATTERN);
            } else {
                this.sampleFormat.applyPattern(pattern);
                this.sampleField.setText(this.sampleFormat.format(Math.PI));
                this.patternField.setText(pattern);
            }
        }

        void setColumns(String[] names, String[] selected) {
            int j;
            this.displayedNames = new String[names.length];
            this.realNames.clear();
            int i = 0;
            while (i < names.length) {
                String s = TeXParser.removeSubscripting(names[i]);
                this.displayedNames[i] = "   " + s + " ";
                this.realNames.put(this.displayedNames[i], names[i]);
                if (selected != null) {
                    j = 0;
                    while (j < selected.length) {
                        if (selected[j] != null && selected[j].equals(names[i])) {
                            selected[j] = this.displayedNames[i];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.prevPatterns.clear();
            String[] stringArray = names;
            j = names.length;
            int s = 0;
            while (s < j) {
                String name = stringArray[s];
                this.prevPatterns.put(name, DataTable.this.getFormatPattern(name));
                ++s;
            }
            this.columnList = new JList<String>(this.displayedNames);
            this.columnList.setLayoutOrientation(2);
            this.columnList.setVisibleRowCount(-1);
            this.columnList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.columnList.getSelectedIndices());
                }
            });
            this.columnScroller.setViewportView(this.columnList);
            this.pack();
            int[] indices = null;
            if (selected != null) {
                indices = new int[selected.length];
                int j2 = 0;
                while (j2 < indices.length) {
                    int i2 = 0;
                    while (i2 < this.displayedNames.length) {
                        if (this.displayedNames[i2].equals(selected[j2])) {
                            indices[j2] = i2;
                            break;
                        }
                        ++i2;
                    }
                    ++j2;
                }
                this.columnList.setSelectedIndices(indices);
            } else {
                this.showNumberFormatAndSample(indices);
            }
        }
    }

    protected static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        NumberFormat numberFormat = NumberFormat.getInstance();
        String pattern;

        public PrecisionRenderer(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        public PrecisionRenderer(String pattern) {
            if (this.numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)this.numberFormat).applyPattern(pattern);
                this.pattern = pattern;
            }
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : this.numberFormat.format(value));
        }

        public void setPrecision(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
        }
    }

    protected static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable _table) {
            this.table = _table;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isRowSelected(row)) {
                int[] i = table.getSelectedColumns();
                if (i.length == 1 && table.convertColumnIndexToModel(i[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(value.toString());
            return this;
        }
    }

    protected static class UnitRenderer
    implements TableCellRenderer {
        TableCellRenderer baseRenderer;
        String units;
        String tooltip;

        public UnitRenderer(TableCellRenderer renderer, String units, String tooltip) {
            this.units = units;
            this.tooltip = tooltip;
            this.setBaseRenderer(renderer);
        }

        public void setBaseRenderer(TableCellRenderer renderer) {
            this.baseRenderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel && this.units != null) {
                JLabel label = (JLabel)c;
                if (label.getText() != null && !label.getText().equals("")) {
                    label.setText(String.valueOf(label.getText()) + this.units);
                }
                label.setToolTipText(this.tooltip);
            }
            return c;
        }
    }
}

