/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.ArrayTableModel;
import org.opensourcephysics.display.CellBorder;

public class ArrayTable
extends JTable
implements ActionListener {
    int refreshDelay = 300;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    ArrayTableModel tableModel;
    ArrayIndexRenderer indexRenderer = new ArrayIndexRenderer();
    ArrayCellRenderer cellRenderer = new ArrayCellRenderer();
    Dictionary<Integer, DecimalFormat> formatDictionary = new Hashtable<Integer, DecimalFormat>();
    String formatPattern = "0.000";
    DecimalFormat defaultFormat = new DecimalFormat(this.formatPattern);
    Object prevValue;

    public ArrayTable(int[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(int[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(double[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(double[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(String[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(String[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(boolean[] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    public ArrayTable(boolean[][] array) {
        this.tableModel = new ArrayTableModel(array);
        this.init();
    }

    protected void init() {
        TableColumn column;
        String name;
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int col;
                int row = e.getFirstRow();
                Object value = ArrayTable.this.getValueAt(row, col = ArrayTable.this.tableModel.showRowNumber ? e.getColumn() + 1 : e.getColumn());
                if (value != null && !value.equals(ArrayTable.this.prevValue)) {
                    ArrayTable.this.firePropertyChange("cell", null, e);
                }
            }
        });
        this.setDefaultRenderer(Object.class, this.cellRenderer);
        this.setColumnSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.indexRenderer);
        this.setAutoResizeMode(0);
        this.setGridColor(Color.BLACK);
        int width = 24;
        if (this.getColumnCount() > 0) {
            name = this.getColumnName(0);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(2 * width);
            column.setWidth(width);
        }
        ((Hashtable)this.formatDictionary).clear();
        width = 60;
        int i = 1;
        int n = this.getColumnCount();
        while (i < n) {
            name = this.getColumnName(i);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setMaxWidth(3 * width);
            column.setWidth(width);
            ++i;
        }
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action prevTabAction = this.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                prevTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (column == 0) {
                        column = 1;
                    } else {
                        ++row;
                    }
                    if (row == rowCount) {
                        row = 0;
                    }
                    if (row == table.getSelectedRow() && column == table.getSelectedColumn()) break;
                }
                table.changeSelection(row, column, false, false);
            }
        };
        this.getActionMap().put(im.get(tab), tabAction);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                table.editCellAt(row, column, e);
                Component comp = table.getEditorComponent();
                if (comp instanceof JTextField) {
                    JTextField field = (JTextField)comp;
                    field.requestFocus();
                    field.selectAll();
                }
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(im.get(enter), enterAction);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean editing = super.editCellAt(row, column, e);
        if (editing) {
            this.prevValue = this.getValueAt(row, column);
        }
        return editing;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.tableChanged(new TableModelEvent(this.tableModel, -1));
    }

    public void setRefreshDelay(int delay) {
        this.refreshTimer.setInitialDelay(delay);
    }

    public void refreshTable() {
        this.refreshTimer.start();
    }

    public void setNumericFormat(String str) {
        if (str != null && !str.equals(this.formatPattern)) {
            this.formatPattern = str;
            this.defaultFormat = new DecimalFormat(str);
            this.refreshTable();
        }
    }

    public void setNumericFormat(String[] str) {
        ((Hashtable)this.formatDictionary).clear();
        int i = 0;
        int n = str.length;
        while (i < n) {
            this.formatDictionary.put(i, new DecimalFormat(str[i]));
            ++i;
        }
        this.refreshTable();
    }

    public void setFirstRowIndex(int index) {
        if (index == this.tableModel.firstRow) {
            return;
        }
        this.tableModel.setFirstRowIndex(index);
        this.refreshTable();
    }

    public void setFirstColIndex(int index) {
        if (index == this.tableModel.firstCol) {
            return;
        }
        this.tableModel.setFirstColIndex(index);
        this.refreshTable();
    }

    public void setRowNumberVisible(boolean vis) {
        if (vis == this.tableModel.showRowNumber) {
            return;
        }
        this.tableModel.setRowNumberVisible(vis);
        this.refreshTable();
    }

    public void setEditable(boolean editable) {
        if (editable == this.tableModel.editable) {
            return;
        }
        this.tableModel.setEditable(editable);
        this.refreshTable();
    }

    public boolean isTransposed() {
        return this.tableModel.isTransposed();
    }

    public void setTransposed(boolean transposed) {
        if (transposed == this.tableModel.transposed) {
            return;
        }
        this.tableModel.transposed = transposed;
        this.refreshTable();
    }

    public void setColumnNames(String[] names) {
        if (this.tableModel.setColumnNames(names)) {
            this.refreshTable();
        }
    }

    public void setColumnLock(int columnIndex, boolean locked) {
        if (this.tableModel.setColumnLock(columnIndex, locked)) {
            this.refreshTable();
        }
    }

    public void setColumnLocks(boolean[] locked) {
        if (this.tableModel.setColumnLocks(locked)) {
            this.refreshTable();
        }
    }

    @Override
    public Font getFont() {
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        return this.indexRenderer.getFont();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.indexRenderer.setFont(font);
        this.cellRenderer.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        this.indexRenderer.setForeground(color);
    }

    public void setDataForeground(Color color) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.cellRenderer.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        this.indexRenderer.setBackground(color);
    }

    public void setDataBackground(Color color) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.cellRenderer.setBackground(color);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.convertColumnIndexToModel(column);
        if (i == 0 && this.tableModel.showRowNumber) {
            return this.indexRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(column));
    }

    static class ArrayCellRenderer
    extends DefaultTableCellRenderer {
        public ArrayCellRenderer() {
            this.setForeground(Color.BLACK);
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean editable = table.isCellEditable(row, column);
            this.setEnabled(editable);
            ArrayTable arrayTable = (ArrayTable)table;
            DecimalFormat cellFormat = arrayTable.formatDictionary.get(column);
            if (cellFormat == null) {
                cellFormat = arrayTable.defaultFormat;
            }
            if (value == null) {
                this.setText("");
            } else if (cellFormat == null) {
                this.setText(value.toString());
            } else {
                try {
                    this.setText(cellFormat.format(value));
                }
                catch (IllegalArgumentException ex) {
                    this.setText(value.toString());
                }
            }
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
            return this;
        }
    }

    static class ArrayIndexRenderer
    extends JLabel
    implements TableCellRenderer {
        public ArrayIndexRenderer() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(0);
            }
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
            }
            this.setPreferredSize(new Dimension(20, 18));
            return this;
        }
    }
}

