/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.Cryptic;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLPropertyElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class XMLControlElement
implements XMLControl {
    public static final int ALWAYS_DECRYPT = 0;
    public static final int PASSWORD_DECRYPT = 3;
    public static final int NEVER_DECRYPT = 5;
    public static int compactArraySize = 0;
    protected static String encoding = "UTF-8";
    protected String className = "java.lang.Object";
    protected Class<?> theClass = null;
    protected String name;
    protected Map<String, Integer> counts = new HashMap<String, Integer>();
    protected Object object;
    protected XMLProperty parent;
    protected int level;
    protected ArrayList<String> propNames = new ArrayList();
    protected ArrayList<XMLProperty> props = new ArrayList();
    protected BufferedReader input;
    protected BufferedWriter output;
    public boolean canWrite;
    protected boolean valid = false;
    protected boolean readFailed = false;
    protected String version;
    protected String doctype = "osp10.dtd";
    private String basepath;
    private String password;
    private int decryptPolicy = 0;

    public XMLControlElement() {
    }

    public XMLControlElement(Class<?> type) {
        this();
        this.setObjectClass(type);
    }

    public XMLControlElement(Object obj) {
        this();
        this.setObjectClass(obj.getClass());
        this.saveObject(obj);
    }

    public XMLControlElement(XMLProperty parent) {
        this();
        this.parent = parent;
        this.level = parent.getLevel();
    }

    public XMLControlElement(String input) {
        this();
        if (input.startsWith("<?xml")) {
            this.readXML(input);
        } else {
            this.read(input);
        }
    }

    public XMLControlElement(XMLControl control) {
        this();
        this.readXML(control.toXML());
    }

    @Override
    public void setLockValues(boolean lock) {
    }

    @Override
    public void setValue(String name, boolean value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "boolean", String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, double value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "double", String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, int value) {
        if (name == null) {
            return;
        }
        this.setXMLProperty(name, "int", String.valueOf(value), false);
    }

    @Override
    public void setValue(String name, Object obj) {
        this.setValue(name, obj, XMLPropertyElement.defaultWriteNullFinalArrayElements);
    }

    public void setValue(String name, Object obj, boolean writeNullFinalElement) {
        if (name == null) {
            return;
        }
        if (obj == null) {
            Iterator<XMLProperty> it = this.props.iterator();
            while (it.hasNext()) {
                XMLProperty prop = it.next();
                if (!name.equals(prop.getPropertyName())) continue;
                it.remove();
                this.propNames.remove(name);
                break;
            }
            return;
        }
        if (obj instanceof Boolean) {
            this.setValue(name, (Boolean)obj);
            return;
        }
        String type = XML.getDataType(obj);
        if (type != null) {
            if (type.equals("int") || type.equals("double")) {
                obj = obj.toString();
            }
            this.setXMLProperty(name, type, obj, writeNullFinalElement);
        }
    }

    @Override
    public boolean getBoolean(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType().equals("boolean")) {
            return "true".equals(prop.getPropertyContent().get(0));
        }
        if (prop != null && prop.getPropertyType().equals("string")) {
            return "true".equals(prop.getPropertyContent().get(0));
        }
        return false;
    }

    @Override
    public double getDouble(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && (prop.getPropertyType().equals("double") || prop.getPropertyType().equals("int") || prop.getPropertyType().equals("string"))) {
            try {
                return Double.parseDouble((String)prop.getPropertyContent().get(0));
            }
            catch (Exception ex) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    @Override
    public int getInt(String name) {
        XMLControl control;
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && (prop.getPropertyType().equals("int") || prop.getPropertyType().equals("string"))) {
            try {
                return Integer.parseInt((String)prop.getPropertyContent().get(0));
            }
            catch (Exception ex) {
                return Integer.MIN_VALUE;
            }
        }
        if (prop != null && prop.getPropertyType().equals("object") && (control = (XMLControl)prop.getPropertyContent().get(0)).getObjectClass() == OSPCombo.class) {
            OSPCombo combo = (OSPCombo)control.loadObject(null);
            return combo.getSelectedIndex();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public String getString(String name) {
        XMLControl control;
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null && prop.getPropertyType().equals("string")) {
            String content = (String)prop.getPropertyContent().get(0);
            if (content.indexOf("<![CDATA[") != -1) {
                content = content.substring(content.indexOf("<![CDATA[") + "<![CDATA[".length(), content.indexOf("]]>"));
            }
            return content;
        }
        if (name.equals("basepath") && this.getRootControl() != null) {
            return this.getRootControl().basepath;
        }
        if (prop != null && prop.getPropertyType().equals("object") && (control = (XMLControl)prop.getPropertyContent().get(0)).getObjectClass() == OSPCombo.class) {
            OSPCombo combo = (OSPCombo)control.loadObject(null);
            return combo.toString();
        }
        return null;
    }

    @Override
    public Object getObject(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            String type = prop.getPropertyType();
            if (type.equals("object")) {
                return this.objectValue(prop);
            }
            if (type.equals("array")) {
                return this.arrayValue(prop);
            }
            if (type.equals("collection")) {
                return this.collectionValue(prop);
            }
            if (type.equals("int")) {
                return new Integer(this.intValue(prop));
            }
            if (type.equals("double")) {
                return new Double(this.doubleValue(prop));
            }
            if (type.equals("boolean")) {
                return new Boolean(this.booleanValue(prop));
            }
            if (type.equals("string")) {
                return this.stringValue(prop);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> arrayList = this.propNames;
        synchronized (arrayList) {
            return new ArrayList<String>(this.propNames);
        }
    }

    @Override
    public String getPropertyType(String name) {
        XMLProperty prop = this.getXMLProperty(name);
        if (prop != null) {
            return prop.getPropertyType();
        }
        return null;
    }

    public void setPassword(String pass) {
        this.password = pass;
        if (this.getObjectClass() != Cryptic.class) {
            this.setValue("xml_password", pass);
        }
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = this.getString("xml_password");
        }
        return this.password;
    }

    public void setDecryptPolicy(int policy) {
        this.decryptPolicy = policy == 5 ? 5 : (policy == 3 ? 3 : 0);
    }

    @Override
    public String read(String name) {
        OSPLog.finest("reading " + name);
        Resource res = ResourceLoader.getResource(name);
        if (res != null) {
            this.read(res.openReader());
            String path = XML.getDirectoryPath(name);
            if (!path.equals("")) {
                ResourceLoader.addSearchPath(path);
                this.basepath = path;
            } else {
                this.basepath = XML.getDirectoryPath(res.getAbsolutePath());
            }
            File file = res.getFile();
            this.canWrite = file != null && file.canWrite();
            return res.getAbsolutePath();
        }
        this.readFailed = true;
        return null;
    }

    @Override
    public void readXML(String xml) {
        this.input = new BufferedReader(new StringReader(xml));
        this.readInput();
        if (!this.failedToRead()) {
            this.canWrite = false;
        }
    }

    @Override
    public void read(Reader in) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.readInput();
        try {
            this.input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String readForClass(String name, Class<?> type) {
        Resource res = ResourceLoader.getResource(name);
        if (res == null) {
            return null;
        }
        this.input = new BufferedReader(res.openReader());
        if (!this.isInputForClass(type)) {
            return null;
        }
        return this.read(name);
    }

    public boolean readXMLForClass(String xml, Class<?> type) {
        this.input = new BufferedReader(new StringReader(xml));
        if (!this.isInputForClass(type)) {
            return false;
        }
        this.readXML(xml);
        return !this.readFailed;
    }

    @Override
    public boolean failedToRead() {
        return this.readFailed;
    }

    @Override
    public String write(String fileName) {
        File file;
        block8: {
            String dir;
            File file2;
            this.canWrite = true;
            int n = fileName.lastIndexOf("/");
            if (n < 0) {
                n = fileName.lastIndexOf("\\");
            }
            if (n > 0 && !(file2 = new File(dir = fileName.substring(0, n + 1))).exists() && !file2.mkdirs()) {
                this.canWrite = false;
                return null;
            }
            file = new File(fileName);
            if (!file.exists() || file.canWrite()) break block8;
            JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            this.canWrite = false;
            return null;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName(encoding);
            this.write(new OutputStreamWriter((OutputStream)stream, charset));
            if (file.exists()) {
                String path = XML.getDirectoryPath(file.getCanonicalPath());
                ResourceLoader.addSearchPath(path);
            }
            if (this.isValid()) {
                fileName = fileName.indexOf("/") != -1 ? String.valueOf(fileName.substring(0, fileName.lastIndexOf("/") + 1)) + this.getDoctype() : (fileName.indexOf("\\") != -1 ? String.valueOf(fileName.substring(0, fileName.lastIndexOf("\\") + 1)) + this.getDoctype() : this.doctype);
                this.writeDocType(new FileWriter(fileName));
            }
            if (file.exists()) {
                return XML.getAbsolutePath(file);
            }
        }
        catch (IOException ex) {
            this.canWrite = false;
            OSPLog.warning(ex.getMessage());
        }
        return null;
    }

    @Override
    public void write(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            String xml = this.toXML();
            if (this.getPassword() != null) {
                Cryptic cryptic = new Cryptic(xml);
                XMLControlElement control = new XMLControlElement(cryptic);
                xml = control.toXML();
            }
            this.output.write(xml);
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    public void writeDocType(Writer out) {
        try {
            this.output = new BufferedWriter(out);
            this.output.write(XML.getDTD(this.getDoctype()));
            this.output.flush();
            this.output.close();
        }
        catch (IOException ex) {
            OSPLog.info(ex.getMessage());
        }
    }

    @Override
    public String toXML() {
        return this.toString();
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid && XML.getDTD(this.getDoctype()) != null;
    }

    public void setVersion(String vers) {
        this.version = vers;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDoctype(String name) {
        XML.getDTD(name);
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setObjectClass(Class<?> type) {
        if (this.object != null && !type.isInstance(this.object)) {
            throw new RuntimeException(this.object + " " + ControlsRes.getString("XMLControlElement.Exception.NotInstanceOf") + " " + type);
        }
        this.className = type.getName();
        this.theClass = type;
    }

    @Override
    public Class<?> getObjectClass() {
        if (this.className == null) {
            return null;
        }
        if (this.theClass != null && this.theClass.getName().equals(this.className)) {
            return this.theClass;
        }
        this.theClass = null;
        try {
            this.theClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassLoader loader = XML.getClassLoader();
        if (loader != null && this.theClass == null) {
            try {
                this.theClass = loader.loadClass(this.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.theClass;
    }

    @Override
    public String getObjectClassName() {
        return this.className;
    }

    @Override
    public void saveObject(Object obj) {
        Class<?> type;
        if (obj == null) {
            obj = this.object;
        }
        if ((type = this.getObjectClass()) == null || type.equals(Object.class)) {
            if (obj == null) {
                return;
            }
            type = obj.getClass();
        }
        if (type.isInstance(obj)) {
            this.object = obj;
            this.className = obj.getClass().getName();
            this.clearValues();
            XML.ObjectLoader loader = XML.getLoader(type);
            loader.saveObject(this, obj);
        }
    }

    @Override
    public Object loadObject(Object obj) {
        return this.loadObject(obj, false, false);
    }

    public Object loadObject(Object obj, boolean autoImport) {
        return this.loadObject(obj, autoImport, false);
    }

    public Object loadObject(Object obj, boolean autoImport, boolean importAll) {
        Class<?> type = this.getObjectClass();
        if (type == null) {
            if (obj != null) {
                int result;
                if (!autoImport && (result = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.UnknownClass.Message")) + " \"" + this.className + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + obj.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 3)) != 0) {
                    return obj;
                }
                if (!this.importInto(obj, importAll)) {
                    return obj;
                }
                type = obj.getClass();
            } else {
                return null;
            }
        }
        try {
            if (XML.getLoader(type).getClass() == XML.getLoader(obj.getClass()).getClass()) {
                autoImport = true;
                importAll = true;
            }
        }
        catch (Exception result) {
            // empty catch block
        }
        if (obj != null && !type.isInstance(obj)) {
            if (!autoImport && (result = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Message")) + " \"" + type.getName() + "\"" + XML.NEW_LINE + ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Query") + " \"" + obj.getClass().getName() + "\"", ControlsRes.getString("XMLControlElement.Dialog.MismatchedClass.Title"), 0, 2)) != 0) {
                return obj;
            }
            if (!this.importInto(obj, importAll)) {
                return obj;
            }
            type = obj.getClass();
        }
        XML.ObjectLoader loader = XML.getLoader(type);
        if (obj == null) {
            if (this.object == null) {
                this.object = loader.createObject(this);
            }
            obj = this.object;
        }
        if (obj == null) {
            return null;
        }
        if (type.isInstance(obj)) {
            this.object = obj = loader.loadObject(this, obj);
        }
        return obj;
    }

    @Override
    public void clearValues() {
        this.props.clear();
        this.propNames.clear();
    }

    @Override
    public void println(String s) {
        System.out.println(s);
    }

    @Override
    public void println() {
        System.out.println();
    }

    @Override
    public void print(String s) {
        System.out.print(s);
    }

    @Override
    public void clearMessages() {
    }

    @Override
    public void calculationDone(String s) {
    }

    @Override
    public String getPropertyName() {
        XMLProperty parent = this.getParentProperty();
        if (this.className == null) {
            if (parent == null) {
                return "null";
            }
            return parent.getPropertyName();
        }
        if (this.isArrayOrCollectionItem()) {
            if (this.name == null) {
                String myName = this.getString("name");
                if (myName != null && !"".equals(myName)) {
                    this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                    this.name = String.valueOf(this.name) + " \"" + myName + "\"";
                } else {
                    XMLProperty root = this;
                    while (root.getParentProperty() != null) {
                        root = root.getParentProperty();
                    }
                    if (root instanceof XMLControlElement) {
                        XMLProperty rootControl = root;
                        this.name = this.className.substring(this.className.lastIndexOf(".") + 1);
                        this.name = ((XMLControlElement)rootControl).addNumbering(this.name);
                    }
                }
            }
            return this.name;
        }
        if (parent != null) {
            return parent.getPropertyName();
        }
        return this.className.substring(this.className.lastIndexOf(".") + 1);
    }

    @Override
    public String getPropertyType() {
        return "object";
    }

    @Override
    public Class<?> getPropertyClass() {
        return this.getObjectClass();
    }

    @Override
    public XMLProperty getParentProperty() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public List<Object> getPropertyContent() {
        return new ArrayList<Object>(this.props);
    }

    @Override
    public XMLControl getChildControl(String name) {
        XMLControl[] children = this.getChildControls();
        int i = 0;
        while (i < children.length) {
            if (children[i].getPropertyName().equals(name)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public XMLControl[] getChildControls() {
        ArrayList<XMLControl> list = new ArrayList<XMLControl>();
        for (XMLProperty prop : this.props) {
            if (!prop.getPropertyType().equals("object")) continue;
            list.add((XMLControl)prop.getPropertyContent().get(0));
        }
        return list.toArray(new XMLControl[0]);
    }

    public XMLControlElement getRootControl() {
        if (this.parent == null) {
            return this;
        }
        XMLProperty prop = this.parent;
        while (prop.getParentProperty() != null) {
            prop = prop.getParentProperty();
        }
        if (prop instanceof XMLControlElement) {
            return (XMLControlElement)prop;
        }
        return null;
    }

    public String addNumbering(String name) {
        Integer count = this.counts.get(name);
        if (count == null) {
            count = new Integer(0);
        }
        count = new Integer(count + 1);
        this.counts.put(name, count);
        return String.valueOf(name) + " " + count.toString();
    }

    @Override
    public void setValue(String stringValue) {
    }

    public String toString() {
        StringBuffer xml = new StringBuffer("");
        if (this.getLevel() == 0) {
            xml.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            if (this.isValid()) {
                xml.append(String.valueOf(XML.NEW_LINE) + "<!DOCTYPE object SYSTEM \"" + this.doctype + "\">");
            }
        }
        xml.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "<object class=\"" + this.className + "\"");
        if (this.version != null && this.getLevel() == 0) {
            xml.append(" version=\"" + this.version + "\"");
        }
        if (this.props.isEmpty()) {
            xml.append("/>");
        } else {
            xml.append(">");
            Iterator<XMLProperty> it = this.props.iterator();
            while (it.hasNext()) {
                xml.append(it.next().toString());
            }
            xml.append(String.valueOf(XML.NEW_LINE) + this.indent(this.getLevel()) + "</object>");
        }
        return xml.toString();
    }

    public <T> List<T> getObjects(Class<T> type) {
        return this.getObjects(type, false);
    }

    public <T> List<T> getObjects(Class<T> type, boolean useChooser) {
        List<XMLProperty> props;
        if (useChooser) {
            String name = type.getName();
            name = name.substring(name.lastIndexOf(".") + 1);
            XMLTreeChooser chooser = new XMLTreeChooser(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Title"), String.valueOf(ControlsRes.getString("XMLControlElement.Chooser.SelectObjectsOfClass.Label")) + " " + name, null);
            props = chooser.choose(this, type);
        } else {
            XMLTree tree = new XMLTree(this);
            tree.setHighlightedClass(type);
            tree.selectHighlightedProperties();
            props = tree.getSelectedProperties();
        }
        ArrayList<T> objects = new ArrayList<T>();
        for (XMLControl xMLControl : props) {
            objects.add(type.cast(xMLControl.loadObject(null)));
        }
        return objects;
    }

    public Object clone() {
        return new XMLControlElement(this);
    }

    private boolean isArrayOrCollectionItem() {
        XMLProperty parent = this.getParentProperty();
        if (parent != null) {
            return (parent = parent.getParentProperty()) != null && "arraycollection".indexOf(parent.getPropertyType()) >= 0;
        }
        return false;
    }

    private boolean importInto(Object obj, boolean importAll) {
        XMLControlElement control = new XMLControlElement(obj);
        Collection<String> list = control.getPropertyNames();
        list.retainAll(this.getPropertyNames());
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (XMLProperty prop : this.props) {
            String propName = prop.getPropertyName();
            if (!list.contains(propName)) continue;
            names.add(propName);
            if (prop.getPropertyType().equals("object")) {
                values.add(prop.getPropertyClass().getSimpleName());
                continue;
            }
            values.add(prop.getPropertyContent().get(0));
        }
        ListChooser chooser = new ListChooser(ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Title"), ControlsRes.getString("XMLControlElement.Chooser.ImportObjects.Label"));
        if (names.isEmpty() || importAll || chooser.choose(names, names, values)) {
            Iterator<XMLProperty> it = this.props.iterator();
            while (it.hasNext()) {
                XMLProperty prop = it.next();
                if (names.contains(prop.getPropertyName())) continue;
                it.remove();
                this.propNames.remove(prop.getPropertyName());
            }
            for (String name : control.getPropertyNames()) {
                if (names.contains(name)) continue;
                String propType = control.getPropertyType(name);
                if (propType.equals("int")) {
                    this.setValue(name, control.getInt(name));
                    continue;
                }
                if (propType.equals("double")) {
                    this.setValue(name, control.getDouble(name));
                    continue;
                }
                if (propType.equals("boolean")) {
                    this.setValue(name, control.getBoolean(name));
                    continue;
                }
                if (propType.equals("string")) {
                    this.setValue(name, control.getString(name));
                    continue;
                }
                this.setValue(name, control.getObject(name));
            }
            return true;
        }
        return false;
    }

    private void setXMLProperty(String name, String type, Object value, boolean writeNullFinalArrayElement) {
        int i = -1;
        if (this.propNames.contains(name)) {
            Iterator<XMLProperty> it = this.props.iterator();
            while (it.hasNext()) {
                ++i;
                XMLProperty prop = it.next();
                if (!prop.getPropertyName().equals(name)) continue;
                it.remove();
                break;
            }
        } else {
            this.propNames.add(name);
        }
        if (i > -1) {
            this.props.add(i, new XMLPropertyElement(this, name, type, value, writeNullFinalArrayElement));
        } else {
            this.props.add(new XMLPropertyElement(this, name, type, value, writeNullFinalArrayElement));
        }
    }

    private XMLProperty getXMLProperty(String name) {
        if (name == null) {
            return null;
        }
        for (XMLProperty prop : this.props) {
            if (!name.equals(prop.getPropertyName())) continue;
            return prop;
        }
        return null;
    }

    private void readInput() {
        String xml;
        block11: {
            this.readFailed = false;
            try {
                String openingTag = this.input.readLine();
                while (openingTag != null && openingTag.indexOf("<object") == -1) {
                    openingTag = this.input.readLine();
                }
                if (openingTag != null) {
                    xml = openingTag;
                    int i = xml.indexOf("version=");
                    if (i != -1) {
                        xml = xml.substring(i + 9);
                        this.version = xml.substring(0, xml.indexOf("\""));
                    }
                    this.readObject(this, openingTag);
                    break block11;
                }
                this.readFailed = true;
                return;
            }
            catch (Exception ex) {
                this.readFailed = true;
                OSPLog.warning("Failed to read xml: " + ex.getMessage());
                return;
            }
        }
        if (Cryptic.class.equals(this.getObjectClass())) {
            Cryptic cryptic = (Cryptic)this.loadObject(null);
            xml = cryptic.decrypt();
            XMLControlElement test = new XMLControlElement(xml);
            if (test.failedToRead()) {
                return;
            }
            String pass = this.password;
            this.password = test.getString("xml_password");
            switch (this.decryptPolicy) {
                case 5: {
                    return;
                }
                case 3: {
                    if (this.password == null || this.password.equals("") || this.password.equals(pass) || Password.verify(this.password, null)) break;
                    return;
                }
            }
            this.clearValues();
            this.object = null;
            this.className = Object.class.getName();
            this.theClass = null;
            this.readXML(xml);
        }
    }

    private boolean isInputForClass(Class<?> type) {
        try {
            String className;
            String xml = this.input.readLine();
            while (xml != null && xml.indexOf("<object") == -1) {
                xml = this.input.readLine();
            }
            if (xml != null && (className = (xml = xml.substring(xml.indexOf("class=") + 7)).substring(0, xml.indexOf("\""))).equals(type.getName())) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private XMLControlElement readObject(XMLControlElement control, String xml) throws IOException {
        String packageName;
        control.clearValues();
        xml = xml.substring(xml.indexOf("class=") + 7);
        String className = xml.substring(0, xml.indexOf("\""));
        int i = className.lastIndexOf(".");
        if (i > -1 && (packageName = className.substring(0, i)).endsWith("org.opensourcephysics.media")) {
            className = String.valueOf(packageName) + ".core" + className.substring(i);
        }
        control.className = className;
        if (xml.indexOf("/>") != -1) {
            this.input.readLine();
            return control;
        }
        XMLControlElement prop = control;
        xml = this.input.readLine();
        while (xml != null) {
            if (xml.indexOf("</object>") != -1) {
                this.input.readLine();
                return control;
            }
            if (xml.indexOf("<property") != -1) {
                XMLPropertyElement child = this.readProperty(new XMLPropertyElement(prop), xml);
                control.props.add(child);
                control.propNames.add(child.getPropertyName());
            }
            xml = this.input.readLine();
        }
        return control;
    }

    private XMLPropertyElement readProperty(XMLPropertyElement prop, String xml) throws IOException {
        prop.name = xml.substring(xml.indexOf("name=") + 6, xml.indexOf("type=") - 2);
        xml = xml.substring(xml.indexOf("type=") + 6);
        prop.type = xml.substring(0, xml.indexOf("\""));
        if (prop.type.equals("array") || prop.type.equals("collection")) {
            String packageName;
            String className = (xml = xml.substring(xml.indexOf("class=") + 7)).substring(0, xml.indexOf("\""));
            int i = className.lastIndexOf(".");
            if (i > -1 && (packageName = className.substring(0, i)).endsWith("org.opensourcephysics.media")) {
                className = String.valueOf(packageName) + ".core" + className.substring(i);
            }
            prop.className = className;
            if (xml.indexOf("/>") != -1) {
                return prop;
            }
            xml = this.input.readLine();
            while (xml.indexOf("<property") != -1) {
                prop.content.add(this.readProperty(new XMLPropertyElement(prop), xml));
                xml = this.input.readLine();
            }
        } else if (prop.type.equals("object")) {
            if (xml.indexOf(">null</property") == -1) {
                XMLControlElement control = this.readObject(new XMLControlElement(prop), this.input.readLine());
                prop.content.add(control);
                prop.className = control.className;
            }
        } else {
            if (xml.indexOf("<![CDATA[") != -1) {
                String s = xml.substring(xml.indexOf("<![CDATA["));
                while (s.indexOf("]]></property>") == -1) {
                    s = String.valueOf(s) + XML.NEW_LINE + this.input.readLine();
                }
                xml = s.substring(0, s.indexOf("]]></property>") + "]]>".length());
            } else {
                String s = xml.substring(xml.indexOf(">") + 1);
                while (s.indexOf("</property>") == -1) {
                    s = String.valueOf(s) + XML.NEW_LINE + this.input.readLine();
                }
                xml = s.substring(0, s.indexOf("</property>"));
            }
            prop.content.add(xml);
        }
        return prop;
    }

    private String indent(int level) {
        String space = "";
        int i = 0;
        while (i < 4 * level) {
            space = String.valueOf(space) + " ";
            ++i;
        }
        return space;
    }

    private Object objectValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("object")) {
            return null;
        }
        if (prop.getPropertyContent().isEmpty()) {
            return null;
        }
        XMLControl control = (XMLControl)prop.getPropertyContent().get(0);
        return control.loadObject(null);
    }

    private double doubleValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("double")) {
            return Double.NaN;
        }
        return Double.parseDouble((String)prop.getPropertyContent().get(0));
    }

    private int intValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("int")) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt((String)prop.getPropertyContent().get(0));
    }

    private boolean booleanValue(XMLProperty prop) {
        return prop.getPropertyContent().get(0).equals("true");
    }

    private String stringValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("string")) {
            return null;
        }
        String content = (String)prop.getPropertyContent().get(0);
        if (content.indexOf("<![CDATA[") != -1) {
            content = content.substring(content.indexOf("<![CDATA[") + "<![CDATA[".length(), content.indexOf("]]>"));
        }
        return content;
    }

    /*
     * Could not resolve type clashes
     */
    private Object arrayValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("array")) {
            return null;
        }
        Class<?> componentType = prop.getPropertyClass().getComponentType();
        List<Object> content = prop.getPropertyContent();
        if (content.isEmpty()) {
            return Array.newInstance(componentType, 0);
        }
        XMLProperty first = (XMLProperty)content.get(0);
        if (first.getPropertyName().equals("array")) {
            Object obj = first.getPropertyContent().get(0);
            if (obj instanceof String) {
                return this.arrayValue((String)obj, componentType);
            }
            return null;
        }
        XMLProperty last = (XMLProperty)content.get(content.size() - 1);
        String index = last.getPropertyName();
        int n = Integer.parseInt(index.substring(1, index.indexOf("]")));
        Object array = Array.newInstance(componentType, n + 1);
        for (XMLProperty next : content) {
            boolean val;
            index = next.getPropertyName();
            n = Integer.parseInt(index.substring(1, index.indexOf("]")));
            String type = next.getPropertyType();
            if (type.equals("object")) {
                Array.set(array, n, this.objectValue(next));
                continue;
            }
            if (type.equals("int")) {
                val = this.intValue(next);
                if (Object.class.isAssignableFrom(componentType)) {
                    Array.set(array, n, new Integer(val ? 1 : 0));
                    continue;
                }
                Array.setInt(array, n, val ? 1 : 0);
                continue;
            }
            if (type.equals("double")) {
                double val2 = this.doubleValue(next);
                if (Object.class.isAssignableFrom(componentType)) {
                    Array.set(array, n, new Double(val2));
                    continue;
                }
                Array.setDouble(array, n, val2);
                continue;
            }
            if (type.equals("boolean")) {
                val = this.booleanValue(next);
                if (Object.class.isAssignableFrom(componentType)) {
                    Array.set(array, n, new Boolean(val));
                    continue;
                }
                Array.setBoolean(array, n, val);
                continue;
            }
            if (type.equals("string")) {
                Array.set(array, n, this.stringValue(next));
                continue;
            }
            if (type.equals("array")) {
                Array.set(array, n, this.arrayValue(next));
                continue;
            }
            if (!type.equals("collection")) continue;
            Array.set(array, n, this.collectionValue(next));
        }
        return array;
    }

    private Object arrayValue(String arrayString, Class<?> componentType) {
        if (!arrayString.startsWith("{") || !arrayString.endsWith("}")) {
            return null;
        }
        String trimmed = arrayString.substring(1, arrayString.length() - 1);
        if (componentType.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            ArrayList<Boolean> isNull = new ArrayList<Boolean>();
            Class<?> arrayType = componentType.getComponentType();
            int i = trimmed.indexOf("{");
            int j = this.indexOfClosingBrace(trimmed, i);
            int k = trimmed.indexOf(",");
            while (j > 0) {
                if (k > -1 && k < i) {
                    isNull.add(true);
                    trimmed = trimmed.substring(k + 1);
                } else {
                    String nextArray = trimmed.substring(i, j + 1);
                    Object obj = this.arrayValue(nextArray, arrayType);
                    list.add(obj);
                    isNull.add(false);
                    trimmed = trimmed.substring(j + 1);
                    if (trimmed.startsWith(",")) {
                        trimmed = trimmed.substring(1);
                    }
                }
                i = trimmed.indexOf("{");
                j = this.indexOfClosingBrace(trimmed, i);
                k = trimmed.indexOf(",");
            }
            while (k > -1) {
                isNull.add(true);
                trimmed = trimmed.substring(k + 1);
                k = trimmed.indexOf(",");
            }
            if (trimmed.length() > 0) {
                isNull.add(true);
            }
            Object array = Array.newInstance(componentType, isNull.size());
            Boolean[] hasNoElement = isNull.toArray(new Boolean[0]);
            Iterator it = list.iterator();
            int n = 0;
            while (n < hasNoElement.length) {
                if (!hasNoElement[n].booleanValue() && it.hasNext()) {
                    Object obj = it.next();
                    Array.set(array, n, obj);
                }
                ++n;
            }
            return array;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (!trimmed.equals("")) {
            int i = trimmed.indexOf(",");
            if (i > -1) {
                list.add(trimmed.substring(0, i));
                trimmed = trimmed.substring(i + 1);
                continue;
            }
            list.add(trimmed);
            break;
        }
        Object array = Array.newInstance(componentType, list.size());
        Iterator it = list.iterator();
        int n = 0;
        while (it.hasNext()) {
            if (componentType == Integer.TYPE) {
                int i = Integer.parseInt((String)it.next());
                Array.setInt(array, n++, i);
                continue;
            }
            if (componentType == Double.TYPE) {
                double x = Double.parseDouble((String)it.next());
                Array.setDouble(array, n++, x);
                continue;
            }
            if (componentType != Boolean.TYPE) continue;
            boolean bool = ((String)it.next()).equals("true");
            Array.setBoolean(array, n++, bool);
        }
        return array;
    }

    private Object collectionValue(XMLProperty prop) {
        if (!prop.getPropertyType().equals("collection")) {
            return null;
        }
        Class<?> classType = prop.getPropertyClass();
        try {
            Collection c = (Collection)classType.newInstance();
            List<Object> content = prop.getPropertyContent();
            for (XMLProperty xMLProperty : content) {
                String type = xMLProperty.getPropertyType();
                if (type.equals("object")) {
                    c.add(this.objectValue(xMLProperty));
                    continue;
                }
                if (type.equals("string")) {
                    c.add(this.stringValue(xMLProperty));
                    continue;
                }
                if (type.equals("array")) {
                    c.add(this.arrayValue(xMLProperty));
                    continue;
                }
                if (!type.equals("collection")) continue;
                c.add(this.collectionValue(xMLProperty));
            }
            return c;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private int indexOfClosingBrace(String arrayString, int indexOfOpeningBrace) {
        int pointer = indexOfOpeningBrace + 1;
        int n = 1;
        int opening = arrayString.indexOf("{", pointer);
        int closing = arrayString.indexOf("}", pointer);
        while (n > 0) {
            if (opening > -1 && opening < closing) {
                ++n;
                pointer = opening + 1;
                opening = arrayString.indexOf("{", pointer);
                continue;
            }
            if (closing > -1) {
                --n;
                pointer = closing + 1;
                closing = arrayString.indexOf("}", pointer);
                continue;
            }
            return -1;
        }
        return pointer - 1;
    }
}

