/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;

public abstract class ControlWindow
extends ControlContainer
implements NeedsUpdate {
    public static final int WINDOW_ADDED = 6;
    public static final int WINDOW_LOCATION = 1;
    public static final int WINDOW_NAME = 6;
    public static final int WINDOW_VISIBLE = 10;
    public static final int WINDOW_SIZE = 11;
    private static boolean keepHidden = false;
    private Window myWindow;
    private LayoutManager myLayout = null;
    private Dimension mySize = null;
    protected boolean waitForReset = false;
    protected boolean startingup = true;
    protected boolean shouldShow = true;
    protected JMenuBar menubar = null;
    private Border originalBorder;
    private boolean notFirstTimeMoved = false;
    private boolean notFirstTimeSized = false;
    private boolean settingDefaultLocation = true;
    private ObjectValue locationValue;
    private ObjectValue sizeValue;
    protected BooleanValue internalValue;
    static ArrayList<ControlWindow> sWindowList = new ArrayList();
    private static List<String> infoList = null;

    public static void setKeepHidden(boolean hidden) {
        keepHidden = hidden;
        for (ControlWindow cWindow : sWindowList) {
            cWindow.reset();
        }
    }

    public static void removeFromWindowList(ControlWindow cWindow) {
        sWindowList.remove(cWindow);
    }

    public ControlWindow() {
        this.setListeners();
        this.originalBorder = this.getRootPane().getBorder();
        this.adjustBorder();
        sWindowList.add(this);
    }

    protected abstract int getVisibleIndex();

    protected abstract int getLocationIndex();

    protected abstract int getSizeIndex();

    protected abstract JRootPane getRootPane();

    public abstract JMenuBar getJMenuBar();

    public void adjustBorder() {
        int borderWidth = EjsControl.getBorderWidthAroundWindows();
        JRootPane rootPane = this.getRootPane();
        if (borderWidth == 0) {
            rootPane.setBorder(this.originalBorder);
        } else {
            if (borderWidth < 0) {
                borderWidth = -1;
            }
            Icon icon = EjsControl.getBorderIconAroundWindows();
            Color color = EjsControl.getBorderColorAroundWindows();
            rootPane.setOpaque(true);
            MatteBorder border = icon == null ? BorderFactory.createMatteBorder(borderWidth, borderWidth, borderWidth, borderWidth, color) : BorderFactory.createMatteBorder(borderWidth, borderWidth, borderWidth, borderWidth, icon);
            String title = EjsControl.getBorderTitleAroundWindows();
            if (title == null) {
                rootPane.setBorder(border);
            } else {
                TitledBorder titledBorder = BorderFactory.createTitledBorder(border, " " + title + " ");
                titledBorder.setTitleJustification(2);
                titledBorder.setTitlePosition(2);
                titledBorder.setTitleColor(EjsControl.getBorderTitleColorAroundWindows());
                rootPane.setBorder(titledBorder);
            }
        }
        this.myWindow.validate();
        this.myWindow.pack();
    }

    @Override
    public boolean acceptsChild(ControlElement _child) {
        if (_child.getVisual() instanceof JMenuBar) {
            return true;
        }
        if (_child.getVisual() instanceof JMenuItem) {
            return false;
        }
        return _child instanceof ControlSwingElement;
    }

    public void updateLocation() {
        Point loc = (Point)this.locationValue.value;
        this.setLocation(loc.x, loc.y);
    }

    private void setLocation(int x, int y) {
        if (x == 0 && y == 0) {
            this.settingDefaultLocation = true;
        }
        if (this.myGroup != null) {
            Point disp = this.myGroup.getDisplacement();
            x += disp.x;
            y += disp.y;
        }
        Rectangle bounds = this.myWindow.getGraphicsConfiguration().getBounds();
        x = Math.max(Math.min(x, bounds.width - 30), 30 - this.myWindow.getWidth());
        y = Math.max(Math.min(y, bounds.height - 30), 30 - this.myWindow.getHeight());
        this.getComponent().setLocation(x += bounds.x, y += bounds.y);
    }

    protected void setListeners() {
        this.myWindow = (Window)this.getComponent();
        this.locationValue = new ObjectValue(this.getComponent().getLocation());
        this.sizeValue = new ObjectValue(this.getContainer().getSize());
        this.myWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                if (ControlWindow.this.isUnderEjs) {
                    if (ControlWindow.this.settingDefaultLocation) {
                        ControlWindow.this.settingDefaultLocation = false;
                        return;
                    }
                    if (ControlWindow.this.isCentered()) {
                        return;
                    }
                }
                Rectangle bounds = ControlWindow.this.myWindow.getGraphicsConfiguration().getBounds();
                Point loc = ControlWindow.this.getComponent().getLocation();
                if (OSPRuntime.isMac() && loc.y < 22) {
                    loc.y = 22;
                    ControlWindow.this.getComponent().setLocation(loc.x, 22);
                    return;
                }
                loc.x -= bounds.x;
                loc.y -= bounds.y;
                ((ControlWindow)ControlWindow.this).locationValue.value = loc;
                if (ControlWindow.this.isUnderEjs && ControlWindow.this.notFirstTimeMoved) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getLocationIndex(), ControlWindow.this.locationValue, false);
                }
                ControlWindow.this.notFirstTimeMoved = true;
            }

            @Override
            public void componentResized(ComponentEvent _e) {
                if (ControlWindow.this.startingup || !ControlWindow.this.notFirstTimeSized) {
                    ControlWindow.this.notFirstTimeSized = true;
                    return;
                }
                ObjectValue objectValue = ControlWindow.this.sizeValue;
                Dimension dimension = ControlWindow.this.getContainer().getSize();
                ControlWindow.this.mySize = dimension;
                objectValue.value = dimension;
                if (ControlWindow.this.isUnderEjs) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getSizeIndex(), ControlWindow.this.sizeValue, false);
                }
                ControlWindow.this.invokeActions(10);
            }

            @Override
            public void componentShown(ComponentEvent _e) {
                ControlWindow.this.invokeActions(20);
            }
        });
        this.myWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ControlWindow.this.whenClosing();
            }
        });
    }

    private boolean isCentered() {
        String loc = this.getProperty("location");
        if (loc == null) {
            return false;
        }
        if ((loc = loc.toLowerCase()).startsWith("\"") && loc.endsWith("\"")) {
            loc = loc.substring(1, loc.length() - 1);
        }
        return "center".equals(loc);
    }

    protected void whenClosing() {
        if (this.getSimulation() != null && this.getSimulation().hasEnded()) {
            return;
        }
        this.internalValue.value = false;
        this.variableChanged(this.getVisibleIndex(), this.internalValue);
        this.invokeActions(21);
    }

    public void dispose() {
        this.setProperty("visible", "false");
        ((Window)this.getComponent()).setVisible(false);
        ((Window)this.getComponent()).dispose();
        sWindowList.remove(this);
    }

    public boolean isVisible() {
        return ((Window)this.getComponent()).isVisible();
    }

    public void show() {
        this.shouldShow = true;
        if (keepHidden) {
            return;
        }
        if (this.startingup && this.waitForReset) {
            return;
        }
        Window w = (Window)this.getComponent();
        if (!w.isVisible()) {
            w.setVisible(true);
            w.repaint();
        }
    }

    public void hide() {
        this.shouldShow = false;
        if (this.startingup && this.waitForReset) {
            return;
        }
        Window w = (Window)this.getComponent();
        if (w.isVisible()) {
            w.setVisible(false);
        }
    }

    @Override
    public void destroy() {
        this.dispose();
        super.destroy();
    }

    public void setWaitForReset(boolean _option) {
        this.waitForReset = _option;
        if (this.waitForReset) {
            ((Window)this.getComponent()).setVisible(false);
        }
    }

    @Override
    public void reset() {
        this.startingup = false;
        if (this.shouldShow) {
            this.show();
        } else {
            this.hide();
        }
        Window w = (Window)this.getComponent();
        w.repaint();
        super.reset();
    }

    @Override
    public void update() {
        this.startingup = false;
    }

    @Override
    public void adjustSize() {
        this.getContainer().setPreferredSize(this.mySize);
        this.myWindow.validate();
        this.myWindow.pack();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("layout");
            infoList.add("location");
            infoList.add("waitForReset");
            infoList.add("onClosing");
            infoList.add("resizeAction");
            infoList.add("onDisplay");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("location")) {
            return "Point|Object|String NO_RESET";
        }
        if (_property.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (_property.equals("waitForReset")) {
            return "boolean";
        }
        if (_property.equals("onClosing")) {
            return "Action CONSTANT";
        }
        if (_property.equals("resizeAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("onDisplay")) {
            return "Action CONSTANT";
        }
        if (_property.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE NO_RESET";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (!(_value.getObject() instanceof LayoutManager)) break;
                LayoutManager layout = (LayoutManager)_value.getObject();
                if (layout != this.myLayout) {
                    this.myLayout = layout;
                    this.getContainer().setLayout(this.myLayout);
                    this.adjustChildren();
                }
                this.myWindow.validate();
                break;
            }
            case 1: {
                Point pos = null;
                if (_value.getObject() instanceof Point) {
                    pos = (Point)_value.getObject();
                } else {
                    String valStr = _value.toString();
                    Value val = ConstantParser.pointConstant(valStr);
                    if (val == null) {
                        return;
                    }
                    pos = (Point)val.getObject();
                }
                this.locationValue.value = pos;
                this.settingDefaultLocation = false;
                if (this.isUnderEjs && this.isCentered()) break;
                this.setLocation(pos.x, pos.y);
                break;
            }
            case 2: {
                this.setWaitForReset(_value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                this.addAction(21, _value.getString());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 5: {
                this.removeAction(20, this.getProperty("onDisplay"));
                this.addAction(20, _value.getString());
                break;
            }
            case 10: {
                this.internalValue.value = _value.getBoolean();
                if (this.internalValue.value) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 11: {
                Dimension size = null;
                Rectangle bounds = EjsControl.getDefaultScreenBounds();
                if (_value instanceof StringValue) {
                    if ("pack".equals(_value.getString())) {
                        this.myWindow.pack();
                        this.mySize = size = this.getContainer().getSize();
                        this.sizeValue.value = size;
                    } else {
                        Value val = ConstantParser.dimensionConstant(_value.getString());
                        if (val == null) {
                            return;
                        }
                        size = (Dimension)val.getObject();
                        if (size.width > bounds.width) {
                            size.width = bounds.width;
                        }
                        if (size.height > bounds.height) {
                            size.height = bounds.height;
                        }
                        this.sizeValue.value = size;
                        if (size.equals(this.mySize)) {
                            return;
                        }
                        this.mySize = size;
                        this.getContainer().setPreferredSize(this.mySize);
                        this.myWindow.validate();
                        this.myWindow.pack();
                    }
                } else if (_value.getObject() instanceof Dimension) {
                    size = (Dimension)_value.getObject();
                    if (size.width > bounds.width) {
                        size.width = bounds.width;
                    }
                    if (size.height > bounds.height) {
                        size.height = bounds.height;
                    }
                    this.sizeValue.value = size;
                    if (size.equals(this.mySize)) {
                        return;
                    }
                    this.mySize = size;
                    this.getContainer().setPreferredSize(this.mySize);
                    this.myWindow.validate();
                    this.myWindow.pack();
                } else {
                    return;
                }
                if (!this.isCentered()) break;
                this.setLocation((bounds.width - size.width) / 2, (bounds.height - size.height) / 2);
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.myWindow.validate();
                break;
            }
            case 1: {
                this.locationValue.value = new Point(0, 0);
                this.setLocation(0, 0);
                break;
            }
            case 2: {
                this.setWaitForReset(false);
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                break;
            }
            case 5: {
                this.removeAction(20, this.getProperty("onDisplay"));
                break;
            }
            case 10: {
                this.internalValue.value = true;
                this.show();
                break;
            }
            case 11: {
                ((Window)this.getComponent()).pack();
                Dimension size = this.getContainer().getSize();
                this.sizeValue.value = size;
                if (!this.isCentered()) break;
                Rectangle bounds = EjsControl.getDefaultScreenBounds();
                this.setLocation((bounds.width - size.width) / 2, (bounds.height - size.height) / 2);
                break;
            }
            default: {
                super.setDefaultValue(_index - 6);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "BORDER";
            }
            case 1: {
                return "0,0";
            }
            case 2: {
                return "false";
            }
            case 3: 
            case 4: 
            case 5: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(_index - 6);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
            case 1: {
                return this.locationValue;
            }
            case 10: {
                return this.internalValue;
            }
            case 11: {
                return this.sizeValue;
            }
        }
        return super.getValue(_index - 6);
    }
}

