/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

public class ControlTextField
extends ControlSwingElement {
    static final int TEXTFIELD_ADDED = 5;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    private static final int FIELD_BACKGROUND = 12;
    private static final int FIELD_FOREGROUND = 11;
    protected boolean inputError = false;
    protected JTextField textfield;
    protected StringValue internalValue;
    protected boolean defaultValueSet;
    protected String defaultValue;
    protected boolean foregroundSet;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    protected int defaultColumns;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.textfield = new JTextField();
        this.textfield.setText("");
        this.defaultValue = this.textfield.getText();
        this.defaultColumns = this.textfield.getColumns();
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.defaultValueSet = false;
        this.internalValue = new StringValue(this.defaultValue);
        this.textfield.setBackground(Color.WHITE);
        this.textfield.setForeground(Color.BLACK);
        this.foregroundSet = false;
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    protected int getVariableIndex() {
        return 0;
    }

    protected int getValueIndex() {
        return 1;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(String _value) {
        if (this.internalValue.value != null && this.internalValue.value.equals(_value)) {
            return;
        }
        this.internalValue.value = _value;
        this.textfield.setText(this.internalValue.value);
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected void setInternalValue(String _value) {
        this.internalValue.value = _value;
        this.variableChanged(this.getVariableIndex(), this.internalValue);
        this.invokeActions();
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("action");
            infoList.add("columns");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "String VARIABLE_EXPECTED";
        }
        if (_property.equals("value")) {
            return "String CONSTANT TRANSLATABLE DEPRECATED";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("columns")) {
            return "int";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setTheValue(_value.getString());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getString();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                if (_value.getBoolean()) {
                    this.textfield.setEditable(true);
                    if (this.foregroundSet) break;
                    this.textfield.setForeground(Color.BLACK);
                    break;
                }
                this.textfield.setEditable(false);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.GRAY);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 4: {
                if (_value.getInteger() == this.textfield.getColumns()) break;
                this.textfield.setColumns(_value.getInteger());
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
                break;
            }
            case 12: {
                super.setValue(7, _value);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 11: {
                super.setValue(6, _value);
                this.foregroundSet = true;
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.textfield.setColumns(this.defaultColumns);
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
                break;
            }
            case 12: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 11: {
                super.setDefaultValue(6);
                this.foregroundSet = false;
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "<no_action>";
            }
            case 4: {
                return Integer.toString(this.defaultColumns);
            }
            default: {
                return super.getDefaultValueString(_index - 5);
            }
            case 12: {
                return "WHITE";
            }
            case 11: 
        }
        return "BLACK/GRAY";
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }

    protected final void setColor(Color aColor) {
        this.textfield.setBackground(aColor);
    }

    protected void decideColors(Color aColor) {
        if (aColor == null) {
            return;
        }
        this.defaultColor = aColor;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    private void acceptValue() {
        this.setInternalValue(this.textfield.getText());
        if (this.isUnderEjs) {
            this.setFieldListValueWithAlternative(this.getVariableIndex(), this.getValueIndex(), this.internalValue);
        }
        if (this.inputError) {
            this.setColor(this.errorColor);
        } else {
            this.setColor(this.defaultColor);
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent _e) {
            if (ControlTextField.this.textfield.isEditable()) {
                ControlTextField.this.acceptValue();
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent _e) {
            this.processKeyEvent(_e, 0);
        }

        @Override
        public void keyReleased(KeyEvent _e) {
            this.processKeyEvent(_e, 1);
        }

        @Override
        public void keyTyped(KeyEvent _e) {
            this.processKeyEvent(_e, 2);
        }

        private void processKeyEvent(KeyEvent _e, int _n) {
            if (!ControlTextField.this.textfield.isEditable()) {
                return;
            }
            if (_e.getKeyChar() != '\n') {
                ControlTextField.this.setColor(ControlTextField.this.editingColor);
            }
            if (_e.getKeyCode() == 27) {
                ControlTextField.this.textfield.setText(ControlTextField.this.internalValue.value);
                ControlTextField.this.setColor(ControlTextField.this.defaultColor);
            }
        }
    }
}

