/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.SurfacePlot;
import org.opensourcephysics.display2d.SurfacePlotMouseController;
import org.opensourcephysics.display2d.TestData;

public class ControlSurfacePlot
extends ControlDrawable2D {
    protected SurfacePlot plot;
    protected GridPointData pointdata;
    protected boolean auto;
    protected int colormode;
    protected double minZ;
    protected double maxZ;
    protected Color floorColor;
    protected Color ceilingColor;
    private SurfacePlotMouseController controller;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.pointdata = new GridPointData(30, 30, 1);
        this.plot = new SurfacePlot(this.pointdata);
        this.auto = true;
        this.minZ = 0.0;
        this.maxZ = 1.0;
        this.plot.setAutoscaleZ(true, 0.0, 1.0);
        this.colormode = 0;
        this.plot.setPaletteType(0);
        this.floorColor = Color.darkGray;
        this.ceilingColor = Color.lightGray;
        this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
        this.plot.setShowGridLines(true);
        this.plot.setGridLineColor(Color.lightGray);
        this.pointdata.setScale(-1.0, 1.0, -1.0, 1.0);
        TestData.gaussianScalarField(this.pointdata);
        this.plot.update();
        return this.plot;
    }

    @Override
    public void setParent(ControlParentOfDrawables _dp) {
        if (this.myParent != null && this.controller != null) {
            this.myParent.getDrawingPanel().removeMouseListener(this.controller);
            this.myParent.getDrawingPanel().removeMouseMotionListener(this.controller);
            this.controller = null;
        }
        if (_dp != null && _dp instanceof ControlDrawablesParent) {
            DrawingPanel panel = ((ControlDrawablesParent)_dp).getDrawingPanel();
            this.controller = new SurfacePlotMouseController(panel, this.plot);
            panel.addMouseListener(this.controller);
            panel.addMouseMotionListener(this.controller);
        }
        super.setParent(_dp);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("data");
            infoList.add("autoscaleZ");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("colormode");
            infoList.add("floorcolor");
            infoList.add("ceilingcolor");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("data")) {
            return "double[][][]";
        }
        if (_property.equals("autoscaleZ")) {
            return "boolean";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("colormode")) {
            return "PlotMode|int";
        }
        if (_property.equals("floorcolor")) {
            return "Color|Object";
        }
        if (_property.equals("ceilingcolor")) {
            return "Color|Object";
        }
        if (_property.equals("showgrid")) {
            return "boolean";
        }
        if (_property.equals("gridcolor")) {
            return "Color|Object";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (!(_value.getObject() instanceof double[][][])) break;
                double[][][] array = (double[][][])_value.getObject();
                int nx = array.length;
                int ny = array[0].length;
                if (nx != this.pointdata.getNx() || ny != this.pointdata.getNy()) {
                    this.pointdata = new GridPointData(nx, ny, 1);
                }
                GridPointData gridPointData = this.pointdata;
                synchronized (gridPointData) {
                    this.pointdata.setData(array);
                    this.plot.setGridData(this.pointdata);
                }
                this.plot.update();
                break;
            }
            case 1: {
                if (this.auto == _value.getBoolean()) break;
                this.auto = _value.getBoolean();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 2: {
                if (_value.getDouble() == this.minZ) break;
                this.minZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 3: {
                if (_value.getDouble() == this.maxZ) break;
                this.maxZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 4: {
                if (this.colormode == _value.getInteger()) break;
                this.colormode = _value.getInteger();
                this.plot.setPaletteType(this.colormode);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 5: {
                if (!(_value.getObject() instanceof Color) || this.floorColor == (Color)_value.getObject()) break;
                this.floorColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 6: {
                if (!(_value.getObject() instanceof Color) || this.ceilingColor == (Color)_value.getObject()) break;
                this.ceilingColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                this.plot.setShowGridLines(_value.getBoolean());
                break;
            }
            case 8: {
                if (!(_value.getObject() instanceof Color)) break;
                this.plot.setGridLineColor((Color)_value.getObject());
                break;
            }
            case 9: {
                this.plot.setVisible(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 10, _value);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                TestData.gaussianScalarField(this.pointdata);
                break;
            }
            case 1: {
                this.auto = true;
                this.plot.setAutoscaleZ(true, this.minZ, this.maxZ);
                break;
            }
            case 2: {
                this.minZ = -1.0;
                this.plot.setAutoscaleZ(this.auto, -1.0, this.maxZ);
                break;
            }
            case 3: {
                this.maxZ = 1.0;
                this.plot.setAutoscaleZ(this.auto, this.minZ, 1.0);
                break;
            }
            case 4: {
                this.colormode = 0;
                this.plot.setPaletteType(0);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 5: {
                this.floorColor = Color.darkGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 6: {
                this.ceilingColor = Color.lightGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                this.plot.setShowGridLines(true);
                break;
            }
            case 8: {
                this.plot.setGridLineColor(Color.lightGray);
                break;
            }
            case 9: {
                this.plot.setVisible(true);
                break;
            }
            default: {
                super.setDefaultValue(_index - 10);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "-1.0";
            }
            case 3: {
                return "1.0";
            }
            case 4: {
                return "SPECTRUM";
            }
            case 5: {
                return "DARKGRAY";
            }
            case 6: {
                return "LIGHTGRAY";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "LIGHTGRAY";
            }
            case 9: {
                return "true";
            }
        }
        return super.getDefaultValueString(_index - 10);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(_index - 10);
    }
}

