/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.TestData;

public class ControlGridPlot
extends ControlDrawable2D {
    protected GridPlot plot;
    protected GridPointData pointdata;
    protected boolean auto;
    protected int levels;
    protected int colormode;
    protected double minZ;
    protected double maxZ;
    protected Color floorColor;
    protected Color ceilingColor;
    private Color[] palette = new Color[1];
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.pointdata = new GridPointData(30, 30, 1);
        this.plot = new GridPlot(this.pointdata);
        this.auto = true;
        this.minZ = 0.0;
        this.maxZ = 1.0;
        this.plot.setAutoscaleZ(true, 0.0, 1.0);
        this.colormode = 0;
        this.plot.setPaletteType(0);
        this.levels = 10;
        this.plot.setColorPalette(ColorMapper.getColorPalette(10, this.colormode));
        this.floorColor = Color.darkGray;
        this.ceilingColor = Color.lightGray;
        this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
        this.plot.setShowGridLines(true);
        this.plot.setGridLineColor(Color.lightGray);
        this.pointdata.setScale(-1.0, 1.0, -1.0, 1.0);
        TestData.gaussianScalarField(this.pointdata);
        this.plot.update();
        return this.plot;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("data");
            infoList.add("autoscaleZ");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("levels");
            infoList.add("colormode");
            infoList.add("floorcolor");
            infoList.add("ceilingcolor");
            infoList.add("showgrid");
            infoList.add("gridcolor");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("data")) {
            return "double[][][]";
        }
        if (_property.equals("autoscaleZ")) {
            return "boolean";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("levels")) {
            return "int";
        }
        if (_property.equals("colormode")) {
            return "ColorMode|int|Object[]";
        }
        if (_property.equals("floorcolor")) {
            return "Color|Object";
        }
        if (_property.equals("ceilingcolor")) {
            return "Color|Object";
        }
        if (_property.equals("showgrid")) {
            return "boolean";
        }
        if (_property.equals("gridcolor")) {
            return "Color|Object";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (!(_value.getObject() instanceof double[][][])) break;
                double[][][] array = (double[][][])_value.getObject();
                int nx = array.length;
                int ny = array[0].length;
                if (nx != this.pointdata.getNx() || ny != this.pointdata.getNy()) {
                    this.pointdata = new GridPointData(nx, ny, 1);
                }
                GridPointData gridPointData = this.pointdata;
                synchronized (gridPointData) {
                    this.pointdata.setData(array);
                    this.plot.setGridData(this.pointdata);
                }
                this.plot.update();
                break;
            }
            case 1: {
                if (this.auto == _value.getBoolean()) break;
                this.auto = _value.getBoolean();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 2: {
                if (_value.getDouble() == this.minZ) break;
                this.minZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 3: {
                if (_value.getDouble() == this.maxZ) break;
                this.maxZ = _value.getDouble();
                this.plot.setAutoscaleZ(this.auto, this.minZ, this.maxZ);
                break;
            }
            case 4: {
                if (_value.getInteger() == this.levels || this.colormode < 0) break;
                this.levels = _value.getInteger();
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 5: {
                if (_value.getObject() instanceof Object[]) {
                    this.colormode = -1;
                    Object[] newPalette = (Object[])_value.getObject();
                    if (newPalette.length != this.palette.length) {
                        this.palette = new Color[newPalette.length];
                    }
                    boolean differentPalette = false;
                    int i = 0;
                    int n = this.palette.length;
                    while (i < n) {
                        if (this.palette[i] != (Color)newPalette[i]) {
                            this.palette[i] = (Color)newPalette[i];
                            differentPalette = true;
                        }
                        ++i;
                    }
                    if (!differentPalette) break;
                    this.plot.setColorPalette(this.palette);
                    this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                    break;
                }
                if (this.colormode == _value.getInteger()) break;
                this.colormode = _value.getInteger();
                this.plot.setPaletteType(this.colormode);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 6: {
                if (!(_value.getObject() instanceof Color) || this.floorColor == (Color)_value.getObject()) break;
                this.floorColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                if (!(_value.getObject() instanceof Color) || this.ceilingColor == (Color)_value.getObject()) break;
                this.ceilingColor = (Color)_value.getObject();
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 8: {
                this.plot.setShowGridLines(_value.getBoolean());
                break;
            }
            case 9: {
                if (!(_value.getObject() instanceof Color)) break;
                this.plot.setGridLineColor((Color)_value.getObject());
                break;
            }
            case 10: {
                this.plot.setVisible(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 11, _value);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                TestData.gaussianScalarField(this.pointdata);
                break;
            }
            case 1: {
                this.auto = true;
                this.plot.setAutoscaleZ(true, this.minZ, this.maxZ);
                break;
            }
            case 2: {
                this.minZ = -1.0;
                this.plot.setAutoscaleZ(this.auto, -1.0, this.maxZ);
                break;
            }
            case 3: {
                this.maxZ = 1.0;
                this.plot.setAutoscaleZ(this.auto, this.minZ, 1.0);
                break;
            }
            case 4: {
                this.levels = 10;
                if (this.colormode < 0) break;
                this.plot.setColorPalette(ColorMapper.getColorPalette(this.levels, this.colormode));
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 5: {
                this.colormode = 0;
                this.plot.setPaletteType(0);
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 6: {
                this.floorColor = Color.darkGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 7: {
                this.ceilingColor = Color.lightGray;
                this.plot.setFloorCeilColor(this.floorColor, this.ceilingColor);
                break;
            }
            case 8: {
                this.plot.setShowGridLines(true);
                break;
            }
            case 9: {
                this.plot.setGridLineColor(Color.lightGray);
                break;
            }
            case 10: {
                this.plot.setVisible(true);
                break;
            }
            default: {
                super.setDefaultValue(_index - 11);
            }
        }
        if (this.isUnderEjs) {
            this.plot.update();
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "-1.0";
            }
            case 3: {
                return "1.0";
            }
            case 4: {
                return "10";
            }
            case 5: {
                return "SPECTRUM";
            }
            case 6: {
                return "DARKGRAY";
            }
            case 7: {
                return "LIGHTGRAY";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "LIGHTGRAY";
            }
            case 10: {
                return "true";
            }
        }
        return super.getDefaultValueString(_index - 11);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        return super.getValue(_index - 11);
    }
}

