/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.Function;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlDrawable3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;

public abstract class ControlElementSet
extends ControlDrawable3D
implements InteractionListener {
    protected static final int SET_ADDED = 36;
    protected static final int IMAGE = 1;
    protected static final int TEXT = 2;
    protected static final int RADIUS = 3;
    protected static final int POSITION = 33;
    protected static final int POSITION_X = 4;
    protected static final int POSITION_Y = 5;
    protected static final int POSITION_Z = 6;
    protected static final int SIZE = 34;
    protected static final int SIZE_X = 7;
    protected static final int SIZE_Y = 8;
    protected static final int SIZE_Z = 9;
    protected static final int ENABLED = 11;
    protected static final int ENABLED_SECONDARY = 12;
    protected static final int STYLE = 18;
    protected static final int PRIMARY_COLOR = 22;
    protected static final int SECONDARY_COLOR = 23;
    protected static final int ELEMENT_SELECTED = 31;
    protected static final int MEASURED = 35;
    protected ElementSet elementSet;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValue;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[][] thePos = null;
    protected double[][] theSize = null;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double scalez = 1.0;
    protected double lineWidth = 1.0;
    protected Font font;
    protected Font defaultFont;
    protected int sensitivity = AbstractInteractiveElement.SENSIBILITY;
    protected boolean numberOfElements_isSet = false;
    private int[] posSpot;
    private int[] sizeSpot;
    private int fullPosition;
    private int fullSize;
    private int elementSelectedSpot;
    protected Function elementFunction = new MyFunction();
    private static List<String> infoList = null;

    public ControlElementSet() {
        this.allposValues = new ObjectValue[3];
        this.theXs = this.elementSet.getXs();
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.theYs = this.elementSet.getYs();
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.theZs = this.elementSet.getZs();
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValue = new ObjectValue[3];
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0] = new ObjectValue(this.theSizeXs);
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1] = new ObjectValue(this.theSizeYs);
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2] = new ObjectValue(this.theSizeZs);
        this.elementSet.addListener(this);
        this.defaultFont = this.font = this.elementSet.elementAt(0).getStyle().getFont();
        int disp = this.getPropertiesDisplacement();
        this.posSpot = new int[]{4 + disp, 5 + disp, 6 + disp};
        this.sizeSpot = new int[]{7 + disp, 8 + disp, 9 + disp};
        this.fullPosition = 33 + disp;
        this.fullSize = 34 + disp;
        this.elementSelectedSpot = 31 + disp;
    }

    protected abstract int getPropertiesDisplacement();

    protected int[] getPosSpot() {
        return this.posSpot;
    }

    protected int[] getSizeSpot() {
        return this.sizeSpot;
    }

    protected int getFullPositionSpot() {
        return this.fullPosition;
    }

    protected int getFullSizeSpot() {
        return this.fullSize;
    }

    protected int getElementSpot() {
        return this.elementSelectedSpot;
    }

    @Override
    public Object getObject(String _name) {
        if (_name.equals("elementSelected")) {
            return this.elementFunction;
        }
        return null;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("elementnumber");
            infoList.add("image");
            infoList.add("text");
            infoList.add("radius");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizex");
            infoList.add("sizey");
            infoList.add("sizez");
            infoList.add("visible");
            infoList.add("enabled");
            infoList.add("enabledSecondary");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("scalez");
            infoList.add("group");
            infoList.add("groupEnabled");
            infoList.add("style");
            infoList.add("elementposition");
            infoList.add("angle");
            infoList.add("resolution");
            infoList.add("color");
            infoList.add("secondaryColor");
            infoList.add("stroke");
            infoList.add("font");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("elementSelected");
            infoList.add("sensitivity");
            infoList.add("position");
            infoList.add("size");
            infoList.add("measured");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("elementnumber")) {
            return "numberOfElements";
        }
        if (_property.equals("angle")) {
            return "rotationAngle";
        }
        if (_property.equals("color")) {
            return "fillColor";
        }
        if (_property.equals("secondaryColor")) {
            return "lineColor";
        }
        if (_property.equals("action")) {
            return "releaseAction";
        }
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        if (_property.equals("enabled")) {
            return "enabledPosition";
        }
        if (_property.equals("enabledSecondary")) {
            return "enabledSize";
        }
        if (_property.equals("sizex")) {
            return "sizeX";
        }
        if (_property.equals("sizey")) {
            return "sizeY";
        }
        if (_property.equals("sizez")) {
            return "sizeZ";
        }
        if (_property.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("elementnumber")) {
            return "int PREVIOUS";
        }
        if (_property.equals("x")) {
            return "int|double|double[]";
        }
        if (_property.equals("y")) {
            return "int|double|double[]";
        }
        if (_property.equals("z")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizex")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizey")) {
            return "int|double|double[]";
        }
        if (_property.equals("sizez")) {
            return "int|double|double[]";
        }
        if (_property.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabled")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("enabledSecondary")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("scalex")) {
            return "int|double";
        }
        if (_property.equals("scaley")) {
            return "int|double";
        }
        if (_property.equals("scalez")) {
            return "int|double";
        }
        if (_property.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (_property.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        if (_property.equals("angle")) {
            return "int|int[]|double|double[]";
        }
        if (_property.equals("resolution")) {
            return "Resolution";
        }
        if (_property.equals("color")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("secondaryColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("stroke")) {
            return "int|double|Object";
        }
        if (_property.equals("font")) {
            return "Font|Object ";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("elementSelected")) {
            return "int";
        }
        if (_property.equals("sensitivity")) {
            return "int";
        }
        if (_property.equals("position")) {
            return "double[][]";
        }
        if (_property.equals("size")) {
            return "double[][]";
        }
        if (_property.equals("measured")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    protected void checkNumberOfElements(int newNumber, boolean force) {
        if (this.elementSet.getNumberOfElements() == newNumber && !force) {
            return;
        }
        this.elementSet.setNumberOfElements(newNumber);
        this.theXs = this.elementSet.getXs();
        this.allposValues[0].value = this.theXs;
        this.theYs = this.elementSet.getYs();
        this.allposValues[1].value = this.theYs;
        this.theZs = this.elementSet.getZs();
        this.allposValues[2].value = this.theZs;
        this.theSizeXs = this.elementSet.getSizeXs();
        this.allsizesValue[0].value = this.theSizeXs;
        this.theSizeYs = this.elementSet.getSizeYs();
        this.allsizesValue[1].value = this.theSizeYs;
        this.theSizeZs = this.elementSet.getSizeZs();
        this.allsizesValue[2].value = this.theSizeZs;
        int i = 0;
        while (i < newNumber) {
            InteractiveElement element = this.elementSet.elementAt(i);
            this.theSizeXs[i] = this.scalex != 0.0 ? element.getSizeX() / this.scalex : element.getSizeX();
            this.theSizeYs[i] = this.scaley != 0.0 ? element.getSizeY() / this.scaley : element.getSizeY();
            this.theSizeZs[i] = this.scalez != 0.0 ? element.getSizeZ() / this.scalez : element.getSizeZ();
            element.initializeMemberOfSet();
            element.setSensitivity(this.sensitivity);
            ++i;
        }
        EjsControl group = this.getGroup();
        if (group != null && !group.isReportingChange()) {
            group.propagateValues();
        }
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getInteger() != this.elementSet.getNumberOfElements()) {
                    this.checkNumberOfElements(_value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 33: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.thePos = (double[][])_value.getObject();
                double[][] val = this.thePos;
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(val.length, false);
                }
                int i = 0;
                int n = Math.min(this.theXs.length, val.length);
                while (i < n) {
                    this.theXs[i] = val[i][0];
                    this.elementSet.elementAt(i).setX(this.theXs[i]);
                    ++i;
                }
                if (val[0].length > 1) {
                    i = 0;
                    n = Math.min(this.theYs.length, val.length);
                    while (i < n) {
                        this.theYs[i] = val[i][1];
                        this.elementSet.elementAt(i).setY(this.theYs[i]);
                        ++i;
                    }
                }
                if (val[0].length <= 2) break;
                i = 0;
                n = Math.min(this.theZs.length, val.length);
                while (i < n) {
                    this.theZs[i] = val[i][2];
                    this.elementSet.elementAt(i).setZ(this.theZs[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                this.thePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theXs.length, val.length);
                    while (i < n) {
                        this.theXs[i] = val[i];
                        this.elementSet.elementAt(i).setX(this.theXs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theXs.length;
                    while (i < n) {
                        this.theXs[i] = val;
                        this.elementSet.elementAt(i).setX(this.theXs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                this.thePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theYs.length, val.length);
                    while (i < n) {
                        this.theYs[i] = val[i];
                        this.elementSet.elementAt(i).setY(this.theYs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theYs.length;
                    while (i < n) {
                        this.theYs[i] = val;
                        this.elementSet.elementAt(i).setY(this.theYs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                this.thePos = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theZs.length, val.length);
                    while (i < n) {
                        this.theZs[i] = val[i];
                        this.elementSet.elementAt(i).setZ(this.theZs[i]);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theZs.length;
                    while (i < n) {
                        this.theZs[i] = val;
                        this.elementSet.elementAt(i).setZ(this.theZs[i]);
                        ++i;
                    }
                }
                break;
            }
            case 34: {
                if (!(_value.getObject() instanceof double[][])) break;
                this.theSize = (double[][])_value.getObject();
                double[][] val = this.theSize;
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(val.length, false);
                }
                int i = 0;
                int n = Math.min(this.theSizeXs.length, val.length);
                while (i < n) {
                    this.theSizeXs[i] = val[i][0];
                    this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i]);
                    ++i;
                }
                if (val[0].length > 1) {
                    i = 0;
                    n = Math.min(this.theSizeYs.length, val.length);
                    while (i < n) {
                        this.theSizeYs[i] = val[i][1];
                        this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i]);
                        ++i;
                    }
                }
                if (val[0].length <= 2) break;
                i = 0;
                n = Math.min(this.theSizeZs.length, val.length);
                while (i < n) {
                    this.theSizeZs[i] = val[i][2];
                    this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i]);
                    ++i;
                }
                break;
            }
            case 7: {
                this.theSize = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeXs.length, val.length);
                    while (i < n) {
                        this.theSizeXs[i] = val[i];
                        this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeXs.length;
                    while (i < n) {
                        this.theSizeXs[i] = val;
                        this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                        ++i;
                    }
                }
                break;
            }
            case 8: {
                this.theSize = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeYs.length, val.length);
                    while (i < n) {
                        this.theSizeYs[i] = val[i];
                        this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeYs.length;
                    while (i < n) {
                        this.theSizeYs[i] = val;
                        this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                        ++i;
                    }
                }
                break;
            }
            case 9: {
                this.theSize = null;
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(val.length, false);
                    }
                    int i = 0;
                    int n = Math.min(this.theSizeZs.length, val.length);
                    while (i < n) {
                        this.theSizeZs[i] = val[i];
                        this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.theSizeZs.length;
                    while (i < n) {
                        this.theSizeZs[i] = val;
                        this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                        ++i;
                    }
                }
                break;
            }
            case 10: {
                if (_value.getObject() instanceof boolean[]) {
                    this.elementSet.setVisibles((boolean[])_value.getObject());
                    break;
                }
                this.elementSet.setVisible(_value.getBoolean());
                break;
            }
            case 11: {
                if (_value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])_value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, _value.getBoolean());
                break;
            }
            case 12: {
                if (_value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])_value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, _value.getBoolean());
                break;
            }
            case 13: {
                this.scalex = _value.getDouble();
                int i = 0;
                int n = this.theSizeXs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i] * this.scalex);
                    ++i;
                }
                break;
            }
            case 14: {
                this.scaley = _value.getDouble();
                int i = 0;
                int n = this.theSizeYs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i] * this.scaley);
                    ++i;
                }
                break;
            }
            case 15: {
                this.scalez = _value.getDouble();
                int i = 0;
                int n = this.theSizeZs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i] * this.scalez);
                    ++i;
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setGroupEnabled(_value.getBoolean());
                    ++i;
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setPosition(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setPosition(val);
                        ++i;
                    }
                }
                break;
            }
            case 20: {
                if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setAngle(val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setAngle((double)val[i] * (Math.PI / 180));
                        ++i;
                    }
                } else if (_value instanceof IntegerValue) {
                    double val = (double)_value.getInteger() * (Math.PI / 180);
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setAngle(val);
                        ++i;
                    }
                } else {
                    double val = _value.getDouble();
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setAngle(val);
                        ++i;
                    }
                }
                break;
            }
            case 21: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setResolution((Resolution)_value.getObject());
                    ++i;
                }
                break;
            }
            case 22: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor((Color)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Color val = (Color)_value.getObject();
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor(val);
                        ++i;
                    }
                }
                break;
            }
            case 23: {
                if (_value instanceof IntegerValue) {
                    Color col = DisplayColors.getLineColor(_value.getInteger());
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern(col);
                        ++i;
                    }
                } else if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern(DisplayColors.getLineColor(val[i]));
                        ++i;
                    }
                } else if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern((Paint)val[i]);
                        ++i;
                    }
                } else {
                    if (!(_value.getObject() instanceof Color)) break;
                    Paint fill = (Paint)_value.getObject();
                    if (fill == NULL_COLOR) {
                        fill = null;
                    }
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern(fill);
                        ++i;
                    }
                }
                break;
            }
            case 24: {
                if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke((Stroke)val[i]);
                        ++i;
                    }
                } else if (_value.getObject() instanceof Stroke) {
                    Stroke val = (Stroke)_value.getObject();
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(val);
                        ++i;
                    }
                } else if (_value.getObject() instanceof double[]) {
                    double[] val = (double[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elementSet.getNumberOfElements(), val.length);
                    while (i < n) {
                        BasicStroke stroke = val[i] < 0.0 ? new BasicStroke((float)(-val[i]), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)val[i]);
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(stroke);
                        ++i;
                    }
                } else {
                    if (this.lineWidth == _value.getDouble()) break;
                    this.lineWidth = _value.getDouble();
                    BasicStroke stroke = this.lineWidth < 0.0 ? new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f) : new BasicStroke((float)this.lineWidth);
                    int i = 0;
                    int n = this.elementSet.getNumberOfElements();
                    while (i < n) {
                        this.elementSet.elementAt(i).getStyle().setEdgeStroke(stroke);
                        ++i;
                    }
                }
                break;
            }
            case 25: {
                Font newFont;
                if (!(_value.getObject() instanceof Font) || (newFont = (Font)_value.getObject()) == this.font) break;
                this.font = newFont;
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setFont(newFont);
                    ++i;
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                this.addAction(11, _value.getString());
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                this.addAction(12, _value.getString());
                return;
            }
            case 31: {
                this.selectedValue.value = _value.getInteger();
                break;
            }
            case 32: {
                this.sensitivity = _value.getInteger();
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setSensitivity(this.sensitivity);
                    ++i;
                }
                break;
            }
            case 35: {
                this.elementSet.canBeMeasured(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 36, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.checkNumberOfElements(1, true);
                this.numberOfElements_isSet = false;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 33: {
                this.thePos = null;
                break;
            }
            case 4: {
                int i = 0;
                int n = this.theXs.length;
                while (i < n) {
                    this.theXs[i] = 0.0;
                    this.elementSet.elementAt(i).setX(0.0);
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                int n = this.theYs.length;
                while (i < n) {
                    this.theYs[i] = 0.0;
                    this.elementSet.elementAt(i).setY(0.0);
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                int n = this.theZs.length;
                while (i < n) {
                    this.theZs[i] = 0.0;
                    this.elementSet.elementAt(i).setZ(0.0);
                    ++i;
                }
                break;
            }
            case 34: {
                this.theSize = null;
                break;
            }
            case 7: {
                int i = 0;
                int n = this.theSizeXs.length;
                while (i < n) {
                    this.theSizeXs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeX(0.1 * this.scalex);
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                int n = this.theSizeYs.length;
                while (i < n) {
                    this.theSizeYs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeY(0.1 * this.scaley);
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                int n = this.theSizeZs.length;
                while (i < n) {
                    this.theSizeZs[i] = 0.1;
                    this.elementSet.elementAt(i).setSizeZ(0.1 * this.scalez);
                    ++i;
                }
                break;
            }
            case 10: {
                this.elementSet.setVisible(true);
                break;
            }
            case 11: {
                this.elementSet.setEnabled(0, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(1, false);
                break;
            }
            case 13: {
                this.scalex = 1.0;
                int i = 0;
                int n = this.theSizeXs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeX(this.theSizeXs[i]);
                    ++i;
                }
                break;
            }
            case 14: {
                this.scaley = 1.0;
                int i = 0;
                int n = this.theSizeYs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeY(this.theSizeYs[i]);
                    ++i;
                }
                break;
            }
            case 15: {
                this.scalez = 1.0;
                int i = 0;
                int n = this.theSizeZs.length;
                while (i < n) {
                    this.elementSet.elementAt(i).setSizeZ(this.theSizeZs[i]);
                    ++i;
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setGroupEnabled(true);
                    ++i;
                }
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setPosition(0);
                    ++i;
                }
                break;
            }
            case 20: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setAngle(0.0);
                    ++i;
                }
                break;
            }
            case 21: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setResolution(null);
                    ++i;
                }
                break;
            }
            case 22: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setEdgeColor(Color.black);
                    ++i;
                }
                break;
            }
            case 23: {
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setFillPattern(Color.blue);
                    ++i;
                }
                break;
            }
            case 24: {
                this.lineWidth = 1.0;
                BasicStroke stroke = new BasicStroke((float)1.0);
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setEdgeStroke(stroke);
                    ++i;
                }
                break;
            }
            case 25: {
                this.font = this.defaultFont;
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).getStyle().setFont(this.font);
                    ++i;
                }
                break;
            }
            case 26: {
                this.removeAction(10, this.getProperty("pressaction"));
                return;
            }
            case 27: {
                this.removeAction(1, this.getProperty("dragaction"));
                return;
            }
            case 28: {
                this.removeAction(0, this.getProperty("action"));
                return;
            }
            case 29: {
                this.removeAction(11, this.getProperty("enteredAction"));
                return;
            }
            case 30: {
                this.removeAction(12, this.getProperty("exitedAction"));
                return;
            }
            case 31: {
                this.selectedValue.value = -1;
                break;
            }
            case 32: {
                this.sensitivity = AbstractInteractiveElement.SENSIBILITY;
                int i = 0;
                int n = this.elementSet.getNumberOfElements();
                while (i < n) {
                    this.elementSet.elementAt(i).setSensitivity(this.sensitivity);
                    ++i;
                }
                break;
            }
            case 35: {
                this.elementSet.canBeMeasured(true);
                break;
            }
            default: {
                super.setDefaultValue(_index - 36);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "1";
            }
            case 1: 
            case 2: 
            case 3: {
                return "<none>";
            }
            case 33: {
                return "<none>";
            }
            case 4: 
            case 5: 
            case 6: {
                return "0";
            }
            case 34: {
                return "<none>";
            }
            case 7: 
            case 8: 
            case 9: {
                return "0.1";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
            case 13: 
            case 14: 
            case 15: {
                return "1";
            }
            case 16: {
                return "<none>";
            }
            case 17: {
                return "true";
            }
            case 18: {
                return "<none>";
            }
            case 19: {
                return "CENTERED";
            }
            case 20: {
                return "0";
            }
            case 21: {
                return "<none>";
            }
            case 22: {
                return "BLACK";
            }
            case 23: {
                return "BLUE";
            }
            case 24: {
                return "1";
            }
            case 25: {
                return "<none>";
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return "<no_action>";
            }
            case 31: {
                return "-1";
            }
            case 32: {
                return "" + AbstractInteractiveElement.SENSIBILITY;
            }
            case 35: {
                return "true";
            }
        }
        return super.getDefaultValueString(_index - 36);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 33: {
                return new ObjectValue(this.thePos);
            }
            case 4: {
                return this.allposValues[0];
            }
            case 5: {
                return this.allposValues[1];
            }
            case 6: {
                return this.allposValues[2];
            }
            case 34: {
                return new ObjectValue(this.theSize);
            }
            case 7: {
                return this.allsizesValue[0];
            }
            case 8: {
                return this.allsizesValue[1];
            }
            case 9: {
                return this.allsizesValue[2];
            }
            case 31: {
                return this.selectedValue;
            }
        }
        if (_index < 36) {
            return null;
        }
        return super.getValue(_index - 36);
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2004: {
                this.invokeActions(12);
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                break;
            }
            case 2003: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(11);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.elementSet.getInteractedIndex();
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
                this.invokeActions(10);
            }
            case 2001: {
                InteractionTargetSetElement elementTarget = (InteractionTargetSetElement)_event.getTarget();
                int i = elementTarget.getElementIndex();
                if (elementTarget.getElementTarget().getClass() == InteractionTargetElementSize.class) {
                    this.theSizeXs[i] = this.scalex != 0.0 ? this.elementSet.elementAt(i).getSizeX() / this.scalex : this.elementSet.elementAt(i).getSizeX();
                    this.theSizeYs[i] = this.scaley != 0.0 ? this.elementSet.elementAt(i).getSizeY() / this.scaley : this.elementSet.elementAt(i).getSizeY();
                    this.theSizeZs[i] = this.scalez != 0.0 ? this.elementSet.elementAt(i).getSizeZ() / this.scalez : this.elementSet.elementAt(i).getSizeZ();
                    if (this.theSize != null) {
                        this.theSize[i][0] = this.theSizeXs[i];
                        this.theSize[i][1] = this.theSizeYs[i];
                        if (this.theSize[i].length > 2) {
                            this.theSize[i][2] = this.theSizeZs[i];
                        }
                        ObjectValue objVal = new ObjectValue(this.theSize);
                        this.variableChanged(this.getFullSizeSpot(), objVal);
                        if (!this.isUnderEjs) break;
                        this.setFieldListValue(this.getFullSizeSpot(), objVal);
                        break;
                    }
                    this.variablesChanged(this.getSizeSpot(), this.allsizesValue);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValues(this.getSizeSpot(), this.allsizesValue);
                    break;
                }
                this.theXs[i] = this.elementSet.elementAt(i).getX();
                this.theYs[i] = this.elementSet.elementAt(i).getY();
                this.theZs[i] = this.elementSet.elementAt(i).getZ();
                if (this.thePos != null) {
                    this.thePos[i][0] = this.theXs[i];
                    this.thePos[i][1] = this.theYs[i];
                    if (this.thePos[i].length > 2) {
                        this.thePos[i][2] = this.theZs[i];
                    }
                    ObjectValue objVal = new ObjectValue(this.thePos);
                    this.variableChanged(this.getFullPositionSpot(), objVal);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValue(this.getFullPositionSpot(), objVal);
                    break;
                }
                this.variablesChanged(this.getPosSpot(), this.allposValues);
                if (!this.isUnderEjs) break;
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableExtraChanged(this.getElementSpot(), this.selectedValue);
            }
        }
    }

    private class MyFunction
    extends Function {
        private MyFunction() {
        }

        @Override
        public double eval() {
            return ControlElementSet.this.elementSet.getInteractedIndex();
        }
    }
}

