/*
 * Decompiled with CFR 0.152.
 */
package users.dav.wc.em.MagneticBarField_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ode_solvers.EjsS_ODE;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.rk.CashKarp45;
import org.opensourcephysics.numerics.ode_solvers.symplectic.VelocityVerletSavvy;
import org.opensourcephysics.tools.ResourceLoader;
import users.dav.wc.em.MagneticBarField_pkg.MagneticBarFieldSimulation;
import users.dav.wc.em.MagneticBarField_pkg.MagneticBarFieldView;

public class MagneticBarField
extends Model {
    public MagneticBarFieldSimulation _simulation = null;
    public MagneticBarFieldView _view = null;
    public MagneticBarField _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EjsS_ODE> _privateOdesList = new Hashtable();
    public boolean intensityScale;
    public int nd = 20;
    public double[][] dipoles;
    public String fieldValue = "0";
    public double m = 0.05;
    public double xmax = 1.5;
    public double ymax = 1.0;
    public int nx = 20;
    public int ny = 20;
    public double[][] xField;
    public double[][] yField;
    public double[][] magField;
    public double xMarker = 0.0;
    public double yMarker = -0.2;
    public double xMagnet = 0.0;
    public double yMagnet = -0.2;
    public double xCompass = 0.4;
    public double yCompass = 0.4;
    public double equilibriumTheta = 0.0;
    public boolean hideField = false;
    public double k = 1.0;
    public double b = 0.2;
    public double theta = 0.0;
    public double omega = 0.0;
    public double t = 0.0;
    public double dt = 0.1;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return MagneticBarField._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/users/dav/wc/em/MagneticBarField.xml";
    }

    public static String _getModelDirectory() {
        return "users/dav/wc/em/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(731, 520);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/dav/wc/em/MagneticBarField/barMagnetField.jpg");
        hashSet.add("/users/dav/wc/em/MagneticBarField/circle.gif");
        hashSet.add("/users/dav/wc/em/MagneticBarField/ejsPage.css");
        hashSet.add("/users/dav/wc/em/MagneticBarField/magnet.gif");
        hashSet.add("/users/dav/wc/em/MagneticBarField/MagneticBarField.html");
        hashSet.add("/users/dav/wc/em/MagneticBarField/MagneticBarField.html");
        hashSet.add("/users/dav/wc/em/MagneticBarField/circle.gif");
        hashSet.add("/users/dav/wc/em/MagneticBarField/magnet.gif");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/dav/wc/em/");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("/Users/andreuglasmann/Documents/Davidson College/EJS_Workspace/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("/Users/andreuglasmann/Documents/Davidson College/EJS_Workspace/bin/config/");
        }
        MagneticBarField._addHtmlPageInfo("Magnetic Bar Field", "_default_", "Magnetic Bar Field", "/users/dav/wc/em/MagneticBarField/MagneticBarField.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!MagneticBarField._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        MagneticBarField magneticBarField = new MagneticBarField(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!MagneticBarField._common_initialization(stringArray)) {
            return null;
        }
        MagneticBarField magneticBarField = new MagneticBarField("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)magneticBarField._getView().getComponent("mainFrame");
    }

    public MagneticBarField() {
        this(null, null, null, null, null, false);
    }

    public MagneticBarField(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public MagneticBarField(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new MagneticBarFieldSimulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return MagneticBarField._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return MagneticBarField._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return MagneticBarField._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 2;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.nd = 20;
        this.dipoles = new double[this.nd][2];
        for (int i = 0; i < this.nd; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.dipoles[i][j] = 0.0;
            }
        }
        this.fieldValue = "0";
        this.m = 0.05;
        this.xmax = 1.5;
        this.ymax = 1.0;
        this.nx = 20;
        this.ny = 20;
        this.xField = new double[this.nx][this.ny];
        this.yField = new double[this.nx][this.ny];
        this.magField = new double[this.nx][this.ny];
        this.xMarker = 0.0;
        this.yMarker = -0.2;
        this.xMagnet = 0.0;
        this.yMagnet = -0.2;
        this.xCompass = 0.4;
        this.yCompass = 0.4;
        this.equilibriumTheta = 0.0;
        this.hideField = false;
        this.k = 1.0;
        this.b = 0.2;
        this.theta = 0.0;
        this.omega = 0.0;
        this.t = 0.0;
        this.dt = 0.1;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EjsS_ODE ejsS_ODE : this._privateOdesList.values()) {
            ejsS_ODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_initialization1;
        if (bl) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_evolution1;
        if (bl) {
            this._ODEi_evolution1.step();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_constraints1;
        if (bl) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.dipoles = null;
        this.xField = null;
        this.yField = null;
        this.magField = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EjsS_ODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        double d = 1.0 / (double)(this.nd - 1);
        for (int i = 0; i < this.nd; i += 2) {
            this.dipoles[i][0] = -0.5 + (double)i * d;
            this.dipoles[i][1] = -0.04;
            this.dipoles[i + 1][0] = -0.5 + (double)i * d;
            this.dipoles[i + 1][1] = 0.04;
        }
        this.computeField();
    }

    public void _constraints1() {
        double[] dArray = this.getB(this.xCompass, this.yCompass);
        this.equilibriumTheta = dArray[3];
        this.fieldValue = "|B|=" + this._view.format(this.getB(this.xCompass, this.yCompass)[2], "0.00");
        this.omega = this.omega > 0.0 ? Math.min(this.omega, Math.PI) : Math.max(this.omega, -Math.PI);
    }

    public void computeField() {
        for (int i = 0; i < this.nx; ++i) {
            double d = this._view.vectorField2D.indexToX(i);
            for (int j = 0; j < this.ny; ++j) {
                double d2 = this._view.vectorField2D.indexToY(j);
                double[] dArray = this.getB(d, d2);
                this.xField[i][j] = dArray[0];
                this.yField[i][j] = dArray[1];
                this.magField[i][j] = this.intensityScale ? dArray[2] : 3.0;
            }
        }
    }

    public double[] getB(double d, double d2) {
        double[] dArray = new double[4];
        for (int i = 0; i < this.nd; ++i) {
            double d3 = d - this.dipoles[i][0] - this.xMagnet;
            double d4 = d2 - this.dipoles[i][1] - this.yMagnet;
            double d5 = d3 * d3 + d4 * d4;
            double d6 = Math.sqrt(d5);
            double d7 = d5 * d6;
            double d8 = d3 / d6;
            double d9 = d4 / d6;
            dArray[0] = dArray[0] + this.m * (3.0 * d8 * d8 - 1.0) / d7;
            dArray[1] = dArray[1] + this.m * 3.0 * d9 * d8 / d7;
            if (d5 != 0.0) continue;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        dArray[2] = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[3] = Math.atan2(dArray[1], dArray[0]);
        return dArray;
    }

    public void setRandomLocation() {
        this.xMagnet = -this.xmax + 2.0 * this.xmax * Math.random();
        this.yMagnet = -this.ymax + 2.0 * this.ymax * Math.random();
        this.computeField();
    }

    public double _method_for_vectorFieldPlottingPanel_minimumX() {
        return -this.xmax;
    }

    public double _method_for_vectorFieldPlottingPanel_minimumY() {
        return -this.ymax;
    }

    public double _method_for_vectorField2D_minimumX() {
        return -this.xmax;
    }

    public double _method_for_vectorField2D_minimumY() {
        return -this.ymax;
    }

    public boolean _method_for_vectorField2D_visible() {
        return !this.hideField;
    }

    public boolean _method_for_imageMagnet_visible() {
        return !this.hideField;
    }

    public void _method_for_imageMagnet_dragAction() {
        this.computeField();
    }

    public boolean _method_for_text_visible() {
        return !this.hideField;
    }

    public boolean _method_for_textBoxShape_visible() {
        return !this.hideField;
    }

    public boolean _method_for_fieldText_visible() {
        return !this.hideField;
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public boolean _method_for_hideMagnetButton_variable() {
        return !this.hideField;
    }

    public void _method_for_hideMagnetButton_actionOn() {
        this.hideField = true;
        this.xMarker = -0.8;
        this.yMarker = 0.75;
    }

    public void _method_for_hideMagnetButton_actionOff() {
        this.hideField = false;
        this.computeField();
    }

    public void _method_for_randomizeButton_action() {
        this.setRandomLocation();
    }

    public boolean _method_for_checkPanel_visible() {
        return !this.hideField;
    }

    public void _method_for_intensityCheckBox_action() {
        this.computeField();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    private class _ODE_evolution1
    implements EjsS_ODE,
    VelocityVerletSavvy {
        private SolverEngine __solver = null;
        private InterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            MagneticBarField.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public InterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.ode_solvers.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[3];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (SolverEngine)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new InterpolatorEventSolver(this.__solver, this);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.initialize(MagneticBarField.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != MagneticBarField.this.theta) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = MagneticBarField.this.theta;
            if (this.__state[n] != MagneticBarField.this.omega) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = MagneticBarField.this.omega;
            if (this.__state[n] != MagneticBarField.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = MagneticBarField.this.t;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(MagneticBarField.this._view.getComponent(MagneticBarField.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                MagneticBarField.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (MagneticBarField.this.dt == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(MagneticBarField.this.dt);
            this.__eventSolver.setInternalStepSize(MagneticBarField.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            MagneticBarField.this.theta = this.__state[n++];
            MagneticBarField.this.omega = this.__state[n++];
            MagneticBarField.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = d - MagneticBarField.this.equilibriumTheta;
            int n3 = 0;
            dArray2[n3++] = d2;
            dArray2[n3++] = -MagneticBarField.this.k * Math.sin(d4) - MagneticBarField.this.b * d2;
            dArray2[n3++] = 1.0;
        }
    }
}

