/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTime;

public abstract class SolverEngineDiscreteTimeAdaptive
extends SolverEngineDiscreteTime {
    private static final double FAC1 = 0.33;
    private static final double FAC2 = 6.0;
    private static final double BETA = 0.0;
    private static final double SAFE = 0.9;
    private final double mExpO1 = 1.0 / this.getMethodOrder() - 0.0;
    private double mErrOld = 1.0E-4;
    private double mFactor = 0.0;
    private boolean mEstimate = false;
    private double mActualStepSize;
    private double mAbsoluteTolerance = Double.NaN;
    private double mRelativeTolerance = Double.NaN;
    protected double[] mAbsTol;
    protected double[] mRelTol;

    protected abstract double computeApproximation(double var1);

    protected abstract double getMethodOrder();

    @Override
    protected void allocateOtherArrays() {
        this.mRelTol = new double[this.mDimension];
        this.mAbsTol = new double[this.mDimension];
        this.setTolerances(1.0E-6, 1.0E-6);
    }

    @Override
    public void reinitialize(double[] state) {
        super.reinitialize(state);
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    @Override
    public final void setEstimateFirstStep(boolean estimate) {
        this.mEstimate = estimate;
    }

    @Override
    public void setMaximumStepSize(double stepSize) {
        super.setMaximumStepSize(stepSize);
        this.mActualStepSize = this.limitStepSize(this.mActualStepSize);
    }

    @Override
    public final void setTolerances(double absTol, double relTol) {
        if (this.mAbsoluteTolerance == absTol && this.mRelativeTolerance == relTol) {
            return;
        }
        this.mAbsoluteTolerance = absTol;
        this.mRelativeTolerance = relTol;
        int i = 0;
        while (i < this.mDimension) {
            this.mAbsTol[i] = absTol;
            this.mRelTol[i] = relTol;
            ++i;
        }
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    public final void setTolerances(double[] absTol, double[] relTol) {
        this.mRelativeTolerance = Double.NaN;
        this.mAbsoluteTolerance = Double.NaN;
        System.arraycopy(absTol, 0, this.mAbsTol, 0, this.mDimension);
        System.arraycopy(relTol, 0, this.mRelTol, 0, this.mDimension);
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    @Override
    protected final void computeOneStep(boolean hasDiscontinuities) {
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        int iterations = 0;
        while (iterations < 500) {
            if (hasDiscontinuities) {
                switch (this.computeIntermediateStep(this.mEventSolver, this.mActualStepSize, this.mFinalState)) {
                    case DISCONTINUITY_PRODUCED_ERROR: {
                        this.mFinalTime = Double.NaN;
                        return;
                    }
                    case NO_DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_EXACTLY_ON_STEP: {
                        this.mFinalTime = this.mFinalState[this.mTimeIndex];
                        break;
                    }
                    case DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_JUST_PASSED: {
                        this.mFinalTime = this.findTheDiscontinuity(this.mActualStepSize);
                        this.mActualStepSize = this.mFinalTime - this.mInitialTime;
                    }
                }
                if (Double.isNaN(this.mFinalTime)) {
                    this.mErrorCode = InterpolatorEventSolver.ERROR.DISCONTINUITY_PRODUCED_ERROR;
                    return;
                }
            } else {
                this.computeIntermediateStep(this.mActualStepSize, this.mFinalState);
                this.mFinalTime = this.mFinalState[this.mTimeIndex];
            }
            double err = this.computeApproximation(this.mActualStepSize);
            this.mAccumulatedEvaluations += (long)this.getNumberOfEvaluations();
            if (err <= 1.0) {
                this.mStateHistory.clean(this.mInitialTime);
                this.mStateHistory.addIntervalData(this.computeFinalRateAndCreateIntervalData());
                this.mActualStepSize = iterations > 0 ? this.limitStepSize(this.mActualStepSize > 0.0 ? Math.min(this.mActualStepSize, this.estimatedStepSize(err)) : Math.max(this.mActualStepSize, this.estimatedStepSize(err))) : this.limitStepSize(this.estimatedStepSize(err));
                return;
            }
            this.mActualStepSize = this.limitStepSize(this.mActualStepSize > 0.0 ? Math.min(this.mActualStepSize, this.estimatedStepSize(err)) : Math.max(this.mActualStepSize, this.estimatedStepSize(err)));
            ++iterations;
        }
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.DID_NOT_CONVERGE;
    }

    @Override
    protected double getActualStepSize() {
        return this.mActualStepSize;
    }

    protected final double computeError(double[] state) {
        double error = 0.0;
        int i = 0;
        while (i < this.mDimension) {
            double sk = this.mAbsTol[i] + this.mRelTol[i] * Math.max(Math.abs(this.mFinalState[i]), Math.abs(this.mInitialState[i]));
            double errorI = (this.mFinalState[i] - state[i]) / sk;
            error += errorI * errorI;
            ++i;
        }
        return Math.sqrt(error / (double)this.mDimension);
    }

    private double estimatedStepSize(double err) {
        double fac11 = 0.0;
        if (err != 0.0) {
            fac11 = Math.pow(err, this.mExpO1);
            this.mFactor = fac11 / Math.exp(0.0 * Math.log(this.mErrOld));
            this.mFactor = Math.max(0.16666666666666666, Math.min(3.0303030303030303, this.mFactor / 0.9));
        } else {
            fac11 = 3.0303030303030303;
            this.mFactor = 0.16666666666666666;
        }
        if (err <= 1.0) {
            this.mErrOld = Math.max(err, 1.0E-4);
            return this.mActualStepSize / this.mFactor;
        }
        return this.mActualStepSize / Math.min(3.0303030303030303, fac11 / 0.9);
    }

    private final double limitStepSize(double intendedStep) {
        if (intendedStep >= 0.0) {
            if (this.mODE instanceof DelayDifferentialEquation) {
                double[] delays = ((DelayDifferentialEquation)this.mODE).getDelays(this.mInitialState);
                int i = 0;
                int n = delays.length;
                while (i < n) {
                    intendedStep = Math.min(intendedStep, delays[i] / 2.0);
                    ++i;
                }
            }
            return Math.min(intendedStep, this.mMaximumStepSize);
        }
        if (this.mODE instanceof DelayDifferentialEquation) {
            double[] delays = ((DelayDifferentialEquation)this.mODE).getDelays(this.mInitialState);
            int i = 0;
            int n = delays.length;
            while (i < n) {
                intendedStep = Math.max(intendedStep, delays[i] / 2.0);
                ++i;
            }
        }
        return Math.max(intendedStep, -this.mMaximumStepSize);
    }

    private final double estimateFirstStepSize(double hMax) {
        int i;
        int posneg = hMax < 0.0 ? -1 : 1;
        hMax = Math.abs(hMax);
        double normF = 0.0;
        double normX = 0.0;
        int i2 = 0;
        while (i2 < this.mDimension) {
            double sk = this.mAbsTol[i2] + this.mRelTol[i2] * Math.abs(this.mInitialState[i2]);
            double aux = this.mInitialRate[i2] / sk;
            normF += aux * aux;
            aux = this.mInitialState[i2] / sk;
            normX += aux * aux;
            ++i2;
        }
        double h = normF <= 1.0E-10 || normX <= 1.0E-10 ? 1.0E-6 : Math.sqrt(normX / normF) * 0.01;
        h = (double)posneg * Math.min(h, hMax);
        if (this.mODE instanceof DelayDifferentialEquation) {
            this.mEventSolver.resetDiscontinuities(this.mInitialState);
            int counter = 0;
            boolean done = false;
            while (!done) {
                i = 0;
                while (i < this.mDimension) {
                    this.mFinalState[i] = this.mInitialState[i] + h * this.mInitialRate[i];
                    ++i;
                }
                switch (this.mEventSolver.checkDiscontinuity(this.mFinalState, false)) {
                    case DISCONTINUITY_PRODUCED_ERROR: {
                        return Double.NaN;
                    }
                    case DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_JUST_PASSED: {
                        h /= 2.0;
                        break;
                    }
                    case DISCONTINUITY_EXACTLY_ON_STEP: {
                        done = true;
                        break;
                    }
                    case NO_DISCONTINUITY_ALONG_STEP: {
                        done = true;
                    }
                }
                if (++counter <= 100) continue;
                return Double.NaN;
            }
        } else {
            int i3 = 0;
            while (i3 < this.mDimension) {
                this.mFinalState[i3] = this.mInitialState[i3] + h * this.mInitialRate[i3];
                ++i3;
            }
        }
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        double der2 = 0.0;
        i = 0;
        while (i < this.mDimension) {
            double sk = this.mAbsTol[i] + this.mRelTol[i] * Math.abs(this.mInitialState[i]);
            double aux = (this.mFinalRate[i] - this.mInitialRate[i]) / sk;
            der2 += aux * aux;
            ++i;
        }
        double der12 = Math.max(Math.abs(der2 = Math.sqrt(der2) / h), Math.sqrt(normF));
        double h1 = der12 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(h) * 0.001) : Math.exp(1.0 / this.getMethodOrder() * Math.log(0.01 / der12));
        h = (double)posneg * Math.min(100.0 * h, h1);
        if (hMax != 0.0) {
            h = (double)posneg * Math.min(Math.abs(h), hMax);
        }
        return h;
    }
}

