/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.VectorColorMapper;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementArrow;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.Style;

public class VectorField
extends Group {
    protected double minimumX = Double.NaN;
    protected double maximumX = Double.NaN;
    protected double minimumY = Double.NaN;
    protected double maximumY = Double.NaN;
    protected double vectorSizeX = 1.0;
    protected double vectorSizeY = 1.0;
    protected double vectorAngle = Double.NaN;
    protected double vectorMagnitude = Double.NaN;
    protected double[][] vectorSizeXData;
    protected double[][] vectorSizeYData;
    protected double[][] vectorAngleData;
    protected double[][] vectorMagnitudeData;
    protected boolean autoscaleMagnitude = false;
    protected boolean useColorMapper = false;
    protected double constantLength = Double.NaN;
    protected int levels = -1;
    protected int invisibleLevel = -1;
    protected Color maxColor = Color.RED;
    protected Color minColor = Color.BLUE;
    private boolean positionChanged = true;
    private boolean sizeChanged = true;
    private boolean magChanged = true;
    protected double magConstant = 0.0;
    protected double minMagnitude = 0.0;
    protected double maxMagnitude = 1.0;
    protected double useMinX;
    protected double useMaxX;
    protected double useMinY;
    protected double useMaxY;
    protected Color[] colors;
    protected VectorColorMapper mapper = new VectorColorMapper(16, 1.0);
    protected double[][] vectorLength;
    protected int nX = -1;
    protected int nY = -1;
    private ElementArrow invisibleElement = new ElementArrow();
    private boolean showLegend;
    private int arrowType = 0;

    public VectorField() {
        this.addElement(this.invisibleElement);
        this.setNumberOfLevels(16);
    }

    public void setMinimumX(double min) {
        if (min != this.minimumX) {
            this.minimumX = min;
            this.positionChanged = true;
        }
    }

    public void setMaximumX(double max) {
        if (max != this.maximumX) {
            this.maximumX = max;
            this.positionChanged = true;
        }
    }

    public void setMinimumY(double min) {
        if (min != this.minimumY) {
            this.minimumY = min;
            this.positionChanged = true;
        }
    }

    public void setMaximumY(double max) {
        if (max != this.maximumY) {
            this.maximumY = max;
            this.positionChanged = true;
        }
    }

    public void setVectorSizeXData(double[][] data) {
        this.vectorSizeXData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeX(double size) {
        if (this.vectorSizeX != size) {
            this.vectorSizeX = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeYData(double[][] data) {
        this.vectorSizeYData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeY(double size) {
        if (this.vectorSizeY != size) {
            this.vectorSizeY = size;
            this.sizeChanged = true;
        }
    }

    public void setVectorAngleData(double[][] data) {
        this.vectorAngleData = data;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAngle(double size) {
        if (this.vectorAngle != size) {
            this.vectorAngle = size;
            this.sizeChanged = true;
        }
    }

    public void setConstantLength(double length) {
        if (this.constantLength != length) {
            this.constantLength = length;
            this.sizeChanged = true;
        }
    }

    public void setAutoscaleMagnitude(boolean scale) {
        if (this.autoscaleMagnitude != scale) {
            this.autoscaleMagnitude = scale;
            this.magChanged = true;
        }
    }

    public void setMagnitudeExtrema(double min, double max) {
        if (this.autoscaleMagnitude) {
            this.autoscaleMagnitude = false;
            this.magChanged = true;
        }
        if (this.minMagnitude == min && this.maxMagnitude == max) {
            return;
        }
        this.minMagnitude = min;
        this.maxMagnitude = max;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public double getMagnitudeMinimum() {
        return this.minMagnitude;
    }

    public double getMagnitudeMaximum() {
        return this.maxMagnitude;
    }

    public void setMagnitudeData(double[][] data) {
        this.vectorMagnitudeData = data;
        this.magChanged = true;
        this.checkArrays();
    }

    public void setMagnitude(double magnitude) {
        if (this.vectorMagnitude != magnitude) {
            this.vectorMagnitude = magnitude;
            this.magChanged = true;
        }
    }

    public void setNumberOfLevels(int _lev) {
        if (_lev == this.levels) {
            return;
        }
        this.magChanged = true;
        if (_lev <= 0) {
            this.levels = 0;
            return;
        }
        this.levels = _lev;
        this.colors = new Color[this.levels];
        this.initColors();
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setNumberOfColors(this.levels);
        this.mapper.updateLegend();
    }

    public void setMinColor(Color _aColor) {
        if (_aColor.equals(this.minColor)) {
            return;
        }
        this.minColor = _aColor;
        this.initColors();
        this.magChanged = true;
    }

    public void setMaxColor(Color _aColor) {
        if (_aColor.equals(this.maxColor)) {
            return;
        }
        this.maxColor = _aColor;
        this.initColors();
        this.magChanged = true;
    }

    public void setInvisibleLevel(int level) {
        if (this.invisibleLevel != level) {
            this.invisibleLevel = level;
            this.magChanged = true;
        }
    }

    public void setArrowType(int type) {
        this.arrowType = type;
        for (Element element : this.getElements()) {
            ((ElementArrow)element).setArrowType(type);
        }
    }

    public void setRelativePosition(int position) {
        for (Element element : this.getElements()) {
            element.getStyle().setRelativePosition(position);
        }
    }

    public void setUseColorMapper(boolean _do) {
        this.useColorMapper = _do;
        this.setShowLegend(this.showLegend);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public void setMapperPaletteType(int _type) {
        this.mapper.setPaletteType(_type);
    }

    public VectorColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setShowLegend(boolean _visible) {
        this.showLegend = _visible;
        JFrame legendFrame = this.mapper.getLegendFrame();
        if (legendFrame == null) {
            legendFrame = this.mapper.showLegend();
        }
        legendFrame.setVisible(this.useColorMapper && _visible);
    }

    public double indexToX(int i) {
        if (i < 0 || i >= this.nX) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nX == 1) {
            return (this.useMinX + this.useMaxX) / 2.0;
        }
        return this.useMinX + (double)i * (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
    }

    public double indexToY(int i) {
        if (i < 0 || i >= this.nY) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nY == 1) {
            return (this.useMinY + this.useMaxY) / 2.0;
        }
        return this.useMinY + (double)i * (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
    }

    @Override
    public boolean isMeasured() {
        if (Double.isNaN(this.minimumX) || Double.isNaN(this.maximumX) || Double.isNaN(this.minimumY) || Double.isNaN(this.maximumY)) {
            return false;
        }
        return this.canBeMeasured;
    }

    @Override
    public double getXMin() {
        return this.minimumX;
    }

    @Override
    public double getXMax() {
        return this.maximumX;
    }

    @Override
    public double getYMin() {
        return this.minimumY;
    }

    @Override
    public double getYMax() {
        return this.maximumY;
    }

    @Override
    public double getXMinLogscale() {
        return this.minimumX > 0.0 ? this.minimumX : Double.NaN;
    }

    @Override
    public double getXMaxLogscale() {
        return this.maximumX > 0.0 ? this.maximumX : Double.NaN;
    }

    @Override
    public double getYMinLogscale() {
        return this.minimumY > 0.0 ? this.minimumY : Double.NaN;
    }

    @Override
    public double getYMaxLogscale() {
        return this.maximumY > 0.0 ? this.maximumY : Double.NaN;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (this.prepareField()) {
            super.draw(_panel, _g);
        }
    }

    private void checkExtrema() {
        DrawingPanel panel = (DrawingPanel)this.getPanel().getComponent();
        this.useMinX = Double.isNaN(this.minimumX) ? panel.getPreferredXMin() : this.minimumX;
        this.useMaxX = Double.isNaN(this.maximumX) ? panel.getPreferredXMax() : this.maximumX;
        this.useMinY = Double.isNaN(this.minimumY) ? panel.getPreferredYMin() : this.minimumY;
        this.useMaxY = Double.isNaN(this.maximumY) ? panel.getPreferredYMax() : this.maximumY;
    }

    private void checkArraySize(double[][] data) {
        if (data != null) {
            this.nX = Math.min(this.nX, data.length);
            this.nY = Math.min(this.nY, data[0].length);
        }
    }

    private boolean checkArrays() {
        int total;
        this.nY = Integer.MAX_VALUE;
        this.nX = Integer.MAX_VALUE;
        this.checkArraySize(this.vectorSizeXData);
        this.checkArraySize(this.vectorSizeYData);
        this.checkArraySize(this.vectorAngleData);
        this.checkArraySize(this.vectorMagnitudeData);
        if (this.nX == Integer.MAX_VALUE) {
            this.nX = 0;
        }
        if (this.nY == Integer.MAX_VALUE) {
            this.nY = 0;
        }
        if (this.nX <= 0 || this.nY <= 0) {
            return false;
        }
        if (this.vectorLength == null || this.vectorLength.length != this.nX || this.vectorLength[0].length != this.nY) {
            this.vectorLength = new double[this.nX][this.nY];
        }
        if ((total = this.nX * this.nY) != this.getElements().size() - 1) {
            this.setNumberOfElements(total);
        }
        return true;
    }

    private boolean isAngleSet() {
        return this.vectorAngleData != null || !Double.isNaN(this.vectorAngle);
    }

    private boolean isMagnitudeSet() {
        return this.vectorMagnitudeData != null || !Double.isNaN(this.vectorMagnitude);
    }

    private void setNumberOfElements(int newNumber) {
        Style oldStyle = this.invisibleElement.getStyle();
        this.removeAllElements();
        this.addElement(this.invisibleElement);
        int i = 1;
        while (i <= newNumber) {
            ElementArrow arrow = new ElementArrow();
            oldStyle.copyTo(arrow);
            arrow.setArrowType(this.arrowType);
            this.addElementAtIndex(i, arrow);
            ++i;
        }
        this.magChanged = true;
        this.sizeChanged = true;
        this.positionChanged = true;
    }

    public boolean prepareField() {
        if (!this.isReallyVisible()) {
            return false;
        }
        if (this.nX <= 0 || this.nY <= 0) {
            return false;
        }
        if (this.sizeChanged) {
            if (this.vectorSizeXData != null || this.vectorSizeYData != null || !this.isAngleSet()) {
                int j;
                int el;
                int i;
                double dx;
                if (Double.isNaN(this.constantLength)) {
                    dx = this.vectorSizeX;
                    double dy = this.vectorSizeY;
                    i = 0;
                    el = 1;
                    while (i < this.nX) {
                        j = 0;
                        while (j < this.nY) {
                            if (this.vectorSizeXData != null) {
                                dx = this.vectorSizeXData[i][j];
                            }
                            if (this.vectorSizeYData != null) {
                                dy = this.vectorSizeYData[i][j];
                            }
                            this.vectorLength[i][j] = Math.sqrt(dx * dx + dy * dy);
                            this.getElement(el).setSizeXY(dx, dy);
                            ++j;
                            ++el;
                        }
                        ++i;
                    }
                } else {
                    dx = this.vectorSizeX;
                    double dy = this.vectorSizeY;
                    i = 0;
                    el = 1;
                    while (i < this.nX) {
                        j = 0;
                        while (j < this.nY) {
                            double length;
                            if (this.vectorSizeXData != null) {
                                dx = this.vectorSizeXData[i][j];
                            }
                            if (this.vectorSizeYData != null) {
                                dy = this.vectorSizeYData[i][j];
                            }
                            if ((length = (this.vectorLength[i][j] = Math.sqrt(dx * dx + dy * dy))) == 0.0) {
                                dy = 0.0;
                                dx = 0.0;
                            } else {
                                length = this.constantLength / length;
                                dx *= length;
                                dy *= length;
                            }
                            this.getElement(el).setSizeXY(dx, dy);
                            ++j;
                            ++el;
                        }
                        ++i;
                    }
                }
            } else {
                double alpha = this.vectorAngle;
                int i = 0;
                int el = 1;
                while (i < this.nX) {
                    int j = 0;
                    while (j < this.nY) {
                        if (this.vectorAngleData != null) {
                            alpha = this.vectorAngleData[i][j];
                        }
                        this.vectorLength[i][j] = this.constantLength;
                        this.getElement(el).setSizeXY(this.constantLength * Math.cos(alpha), this.constantLength * Math.sin(alpha));
                        ++j;
                        ++el;
                    }
                    ++i;
                }
            }
            if (!this.isMagnitudeSet()) {
                this.magChanged = true;
            }
        }
        double oldUseMinX = this.useMinX;
        double oldUseMaxX = this.useMaxX;
        double oldUseMinY = this.useMinY;
        double oldUseMaxY = this.useMaxY;
        this.checkExtrema();
        if (this.positionChanged || oldUseMinX != this.useMinX || oldUseMaxX != this.useMaxX || oldUseMinY != this.useMinY || oldUseMaxY != this.useMaxY) {
            double dy;
            double startY;
            double dx;
            double startX;
            if (this.nX <= 1) {
                startX = (this.useMinX + this.useMaxX) / 2.0;
                dx = 0.0;
            } else {
                startX = this.useMinX;
                dx = (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
            }
            if (this.nY <= 1) {
                startY = (this.useMinY + this.useMaxY) / 2.0;
                dy = 0.0;
            } else {
                startY = this.useMinY;
                dy = (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
            }
            int i = 0;
            int el = 1;
            while (i < this.nX) {
                double x = startX + (double)i * dx;
                int j = 0;
                while (j < this.nY) {
                    this.getElement(el).setXY(x, startY + (double)j * dy);
                    ++j;
                    ++el;
                }
                ++i;
            }
        }
        if (this.magChanged) {
            this.processMagnitude();
        }
        this.magChanged = false;
        this.sizeChanged = false;
        this.positionChanged = false;
        this.invisibleElement.setVisible(false);
        return true;
    }

    private void processMagnitude() {
        Component panel = this.getPanel().getComponent();
        if (panel instanceof PlottingPanel) {
            this.mapper.checkPallet(((PlottingPanel)panel).getAxes().getInteriorBackground());
        } else {
            this.mapper.checkPallet(panel.getBackground());
        }
        if (this.levels > 0) {
            double[][] magArray;
            double[][] dArray = magArray = this.isMagnitudeSet() ? this.vectorMagnitudeData : this.vectorLength;
            if (magArray != null) {
                if (this.autoscaleMagnitude) {
                    this.computeMagnitudeExtrema(magArray);
                }
                int i = 0;
                int el = 1;
                while (i < this.nX) {
                    int j = 0;
                    while (j < this.nY) {
                        Element element = this.getElement(el);
                        double mag = magArray[i][j];
                        Color color = this.magToColor(mag);
                        if (color == null) {
                            element.setVisible(false);
                        } else {
                            element.setVisible(true);
                            element.getStyle().setLineColor(color);
                            element.getStyle().setFillColor(color);
                            element.getStyle().setExtraColor(this.magToCompColor(mag));
                        }
                        ++j;
                        ++el;
                    }
                    ++i;
                }
                return;
            }
        }
        Color color = Double.isNaN(this.vectorMagnitude) ? this.minColor : this.magToColor(this.vectorMagnitude);
        Color extraColor = Double.isNaN(this.vectorMagnitude) ? this.maxColor : this.magToCompColor(this.vectorMagnitude);
        int i = 0;
        int el = 1;
        while (i < this.nX) {
            int j = 0;
            while (j < this.nY) {
                Element element = this.getElement(el);
                element.setVisible(true);
                element.getStyle().setLineColor(color);
                element.getStyle().setFillColor(color);
                element.getStyle().setExtraColor(extraColor);
                ++j;
                ++el;
            }
            ++i;
        }
    }

    private void computeMagnitudeExtrema(double[][] temp) {
        if (temp == null) {
            return;
        }
        this.minMagnitude = Double.POSITIVE_INFINITY;
        this.maxMagnitude = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < temp.length) {
            double[] v = temp[i];
            int j = 0;
            while (j < v.length) {
                this.minMagnitude = Math.min(this.minMagnitude, v[j]);
                this.maxMagnitude = Math.max(this.minMagnitude, v[j]);
                ++j;
            }
            ++i;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
    }

    private void initColors() {
        int redStart = this.minColor.getRed();
        int greenStart = this.minColor.getGreen();
        int blueStart = this.minColor.getBlue();
        int alphaStart = this.minColor.getAlpha();
        int redEnd = this.maxColor.getRed();
        int greenEnd = this.maxColor.getGreen();
        int blueEnd = this.maxColor.getBlue();
        int alphaEnd = this.maxColor.getAlpha();
        int i = 0;
        while (i < this.levels) {
            int r = (int)((float)redStart + (float)((redEnd - redStart) * i) * 1.0f / (float)(this.levels - 1));
            int g = (int)((float)greenStart + (float)((greenEnd - greenStart) * i) * 1.0f / (float)(this.levels - 1));
            int b = (int)((float)blueStart + (float)((blueEnd - blueStart) * i) * 1.0f / (float)(this.levels - 1));
            int a = (int)((float)alphaStart + (float)((alphaEnd - alphaStart) * i) * 1.0f / (float)(this.levels - 1));
            this.colors[i] = new Color(r, g, b, a);
            ++i;
        }
    }

    private Color magToColor(double mag) {
        if (this.useColorMapper) {
            return this.mapper.doubleToColor(mag);
        }
        if (this.colors == null || this.levels == 0) {
            return this.minColor;
        }
        int index = (int)(this.magConstant * (mag - this.minMagnitude));
        if (this.invisibleLevel >= 0 && index <= this.invisibleLevel) {
            return null;
        }
        if (index <= 0) {
            return this.colors[0];
        }
        if (index >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[index];
    }

    private Color magToCompColor(double mag) {
        if (this.useColorMapper) {
            return this.mapper.doubleToCompColor(mag);
        }
        if (this.colors == null || this.levels == 0) {
            return this.maxColor;
        }
        int index = (int)(this.magConstant * (this.maxMagnitude - mag));
        if (this.invisibleLevel >= 0 && index <= this.invisibleLevel) {
            return null;
        }
        if (index <= 0) {
            return this.colors[0];
        }
        if (index >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[index];
    }
}

