/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.VectorColorMapper;

public class VectorPlot
implements Plot2D {
    public static final int STROKEDARROW = 0;
    public static final int FILLEDARROW = 1;
    private GeneralPath vectorpath;
    private int arrowType = 0;
    private boolean visible = true;
    private GridData griddata;
    private boolean autoscaleZ = true;
    private boolean scaleArrowToGrid = true;
    private VectorColorMapper colorMap;
    private int ampIndex = 0;
    private int aIndex = 1;
    private int bIndex = 2;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    Grid grid;

    public VectorPlot() {
        this(null);
    }

    public VectorPlot(GridData gridData) {
        this.griddata = gridData;
        this.colorMap = new VectorColorMapper(256, 1.0);
        if (this.griddata == null) {
            return;
        }
        this.grid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    @Override
    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    @Override
    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    @Override
    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    @Override
    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    @Override
    public void setAll(Object object) {
        double[][][] dArray = (double[][][])object;
        this.copyVecData(dArray);
        this.update();
    }

    @Override
    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][][] dArray = (double[][][])object;
        this.copyVecData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyVecData(double[][][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray[0].length || this.griddata.getNy() != dArray[0][0].length) {
            this.griddata = new ArrayData(dArray[0].length, dArray[0][0].length, 3);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        double[][] dArray3 = this.griddata.getData()[1];
        double[][] dArray4 = this.griddata.getData()[2];
        int n = dArray[0][0].length;
        int n2 = 0;
        int n3 = dArray[0].length;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                dArray2[n2][n4] = Math.sqrt(dArray[0][n2][n4] * dArray[0][n2][n4] + dArray[1][n2][n4] * dArray[1][n2][n4]);
                dArray3[n2][n4] = dArray2[n2][n4] == 0.0 ? 0.0 : dArray[0][n2][n4] / dArray2[n2][n4];
                dArray4[n2][n4] = dArray2[n2][n4] == 0.0 ? 0.0 : dArray[1][n2][n4] / dArray2[n2][n4];
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public GridData getGridData() {
        return this.griddata;
    }

    @Override
    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        Grid grid = this.griddata.isCellData() ? new Grid(this.griddata.getNx(), this.griddata.getNy()) : new Grid(this.griddata.getNx() - 1, this.griddata.getNy() - 1);
        grid.setColor(Color.lightGray);
        grid.setVisible(false);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        }
        this.grid = grid;
    }

    @Override
    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
        this.aIndex = nArray[1];
        this.bIndex = nArray[2];
    }

    public void setArrowType(int n) {
        this.arrowType = n;
    }

    @Override
    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    @Override
    public void setColorPalette(Color[] colorArray) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public void setShowGridLines(boolean bl) {
        if (this.grid == null) {
            this.grid = new Grid(0);
        }
        this.grid.setVisible(bl);
    }

    @Override
    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (!this.visible || this.griddata == null) {
            return;
        }
        if (this.grid.isVisible()) {
            this.grid.draw(drawingPanel, graphics);
        }
        this.colorMap.checkPallet(drawingPanel.getBackground());
        GridData gridData = this.griddata;
        double[][][] dArray = gridData.getData();
        double d = gridData.getDx();
        double d2 = gridData.getDy();
        double d3 = gridData.getLeft();
        double d4 = gridData.getTop();
        double d5 = drawingPanel.getAspectRatio();
        float f = (float)Math.abs(drawingPanel.getYPixPerUnit());
        if (this.scaleArrowToGrid) {
            f = Math.max(1.0f, (float)drawingPanel.getSize().width / (float)dArray.length / (float)d5 - 1.0f);
            f = Math.min(18.0f, f * 0.72f);
        }
        switch (this.arrowType) {
            case 0: {
                this.vectorpath = VectorPlot.createVectorPath(f);
                break;
            }
            case 1: {
                this.vectorpath = VectorPlot.createFilledVectorPath(f);
                break;
            }
            default: {
                this.vectorpath = VectorPlot.createVectorPath(f);
            }
        }
        n2 = drawingPanel.getXPixPerUnit() < 0.0 ? (n2 = -1) : 1;
        n = drawingPanel.getYPixPerUnit() < 0.0 ? (n = -1) : 1;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        Color color = drawingPanel.getBackground();
        int n3 = 0;
        int n4 = gridData.getNx();
        while (n3 < n4) {
            int n5 = 0;
            int n6 = gridData.getNy();
            while (n5 < n6) {
                if (gridData instanceof GridPointData) {
                    d9 = dArray[n3][n5][0];
                    d10 = dArray[n3][n5][1];
                    d6 = dArray[n3][n5][this.ampIndex + 2];
                    d7 = dArray[n3][n5][this.aIndex + 2];
                    d8 = dArray[n3][n5][this.bIndex + 2];
                } else if (gridData instanceof ArrayData) {
                    d9 = d3 + (double)n3 * d;
                    d10 = d4 + (double)n5 * d2;
                    d6 = dArray[this.ampIndex][n3][n5];
                    d7 = dArray[this.aIndex][n3][n5];
                    d8 = dArray[this.bIndex][n3][n5];
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color2 = this.colorMap.doubleToColor(d6);
                if (color != color2) {
                    graphics2D.setColor(this.colorMap.doubleToColor(d6));
                    AffineTransform affineTransform = new AffineTransform((double)n2 * d5 * d7, (double)(-n) * d8, (double)n2 * d5 * d8, (double)n * d7, (double)drawingPanel.xToPix(d9), (double)drawingPanel.yToPix(d10));
                    Shape shape = this.vectorpath.createTransformedShape(affineTransform);
                    switch (this.arrowType) {
                        case 0: {
                            graphics2D.draw(shape);
                            break;
                        }
                        case 1: {
                            graphics2D.fill(shape);
                            break;
                        }
                        default: {
                            graphics2D.draw(shape);
                        }
                    }
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void scaleArrowLenghToGrid(boolean bl) {
        this.scaleArrowToGrid = bl;
    }

    @Override
    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(d2);
        }
    }

    @Override
    public void setSymmetricZ(boolean bl) {
    }

    @Override
    public boolean isSymmetricZ() {
        return false;
    }

    @Override
    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    @Override
    public double getFloor() {
        return 0.0;
    }

    @Override
    public double getCeiling() {
        return this.colorMap.getCeiling();
    }

    @Override
    public void setFloorCeilColor(Color color, Color color2) {
    }

    @Override
    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    @Override
    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[1]);
        }
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - d / 2.0;
            this.xmax = this.griddata.getRight() + d / 2.0;
            this.ymin = this.griddata.getBottom() + d2 / 2.0;
            this.ymax = this.griddata.getTop() - d2 / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    @Override
    public void setExpandedZ(boolean bl, double d) {
    }

    static GeneralPath createVectorPath(float f) {
        float f2 = Math.min(15.0f, 1.0f + f / 5.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, 2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, -2.0f * f2 / 3.0f);
        return generalPath;
    }

    static GeneralPath createFilledVectorPath(float f) {
        float f2 = Math.min(15.0f, 1.0f + f / 5.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f / 2.0f, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, -2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f - f2, -1.0f);
        generalPath.moveTo(-f / 2.0f, -1.0f);
        return generalPath;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    @Override
    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            @Override
            public Object createObject(XMLControl xMLControl) {
                return new VectorPlot(null);
            }
        };
    }
}

