/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.PointCharge_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.eckerd.coxaj.elec_distribution.PointCharge_pkg.PointChargeSimulation;
import users.eckerd.coxaj.elec_distribution.PointCharge_pkg.PointChargeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCharge
extends Model {
    public PointChargeSimulation _simulation = null;
    public PointChargeView _view = null;
    public PointCharge _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double q = 1.0;
    public double size = 1.0;
    public double xmin = -this.size;
    public double xmax = this.size;
    public double ymin = -this.size;
    public double ymax = this.size;
    public int nx = 20;
    public int ny = 20;
    public double[][] xField;
    public double[][] yField;
    public double[][] elecField;
    public String fieldValue = "0";
    public double xDetector = 0.5;
    public double yDetector = 0.0;
    public double xSizeArrow = 1.0;
    public double ySizeArrow = 0.0;
    public boolean collectData = false;
    public double[] magRow;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/PointCharge.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(472, 524);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/circle.gif");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/PointCharge.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/circle.gif");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/ejsPage.css");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/ElectricFieldLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/ElectricFieldStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/ElectricFieldStudentWorksheet.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/PointCharge.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/PointChargeWrong/pointCharge.jpg");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        PointCharge._common_initialization(stringArray);
        PointCharge pointCharge = new PointCharge(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        PointCharge._common_initialization(stringArray);
        PointCharge pointCharge = new PointCharge("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)pointCharge._getView().getComponent("mainFrame");
    }

    public PointCharge() {
        this(null, null, null, null, null, false);
    }

    public PointCharge(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public PointCharge(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new PointChargeSimulation(this, string, frame, uRL, bl);
        this._view = (PointChargeView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_constraints1 = true;
        this.q = 1.0;
        this.size = 1.0;
        this.xmin = -this.size;
        this.xmax = this.size;
        this.ymin = -this.size;
        this.ymax = this.size;
        this.nx = 20;
        this.ny = 20;
        this.xField = new double[this.nx][this.ny];
        this.yField = new double[this.nx][this.ny];
        this.elecField = new double[this.nx][this.ny];
        this.fieldValue = "0";
        this.xDetector = 0.5;
        this.yDetector = 0.0;
        this.xSizeArrow = 1.0;
        this.ySizeArrow = 0.0;
        this.collectData = false;
        this.magRow = new double[4];
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.xField = null;
        this.yField = null;
        this.elecField = null;
        this.magRow = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.computeField();
    }

    public void _constraints1() {
        double[] dArray = this.getE(this.xDetector, this.yDetector);
        if (dArray[2] > 0.0) {
            this.xSizeArrow = dArray[0] / dArray[2];
            this.ySizeArrow = dArray[1] / dArray[2];
        } else {
            this.xSizeArrow = 0.0;
            this.ySizeArrow = 0.0;
        }
        this.fieldValue = " E=" + this._view.format(this.getE(this.xDetector, this.yDetector)[2], "0.00");
    }

    public void computeField() {
        for (int i = 0; i < this.nx; ++i) {
            double d = this._view.vectorField2D.indexToX(i);
            for (int j = 0; j < this.ny; ++j) {
                double d2 = this._view.vectorField2D.indexToY(j);
                double[] dArray = this.getE(d, d2);
                this.xField[i][j] = dArray[0];
                this.yField[i][j] = dArray[1];
                this.elecField[i][j] = dArray[2];
            }
        }
    }

    public double[] getE(double d, double d2) {
        double[] dArray = new double[4];
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(d3);
        double d5 = d / d4;
        double d6 = d2 / d4;
        double d7 = d3 * d4;
        if (d3 == 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        } else {
            dArray[0] = this.q * d / d7;
            dArray[1] = this.q * d2 / d7;
        }
        dArray[2] = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        return dArray;
    }

    public void recordData() {
        double d;
        this.collectData = false;
        this.magRow[0] = this.xDetector;
        this.magRow[1] = this.yDetector;
        this.magRow[2] = d = Math.sqrt(this.xDetector * this.xDetector + this.yDetector * this.yDetector);
        this.magRow[3] = this.getE(this.xDetector, this.yDetector)[2];
        this._view.xytrail.addPoint(this.xDetector, d);
        this._view.Etrail.addPoint(d, this.getE(this.xDetector, this.yDetector)[2]);
        this.collectData = true;
    }

    public double _method_for_vectorFieldPlottingPanel_minimumX() {
        return -this.size;
    }

    public double _method_for_vectorFieldPlottingPanel_minimumY() {
        return -this.size;
    }

    public void _method_for_chargeSlider_dragaction() {
        this.computeField();
    }

    public void _method_for_chargeField_action() {
        this.q = Math.max(this.q, 0.0);
        this.computeField();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_pdfButton_action() {
        this._view.showDocument("./PointChargeWrong/ElectricFieldStudentWorksheet.pdf");
    }

    public String[] _method_for_dataTable_columnNames() {
        return new String[]{"#", "x", "y", "r", "E"};
    }

    public void _method_for_recordDataButton_actionOff() {
        this.recordData();
    }

    public void _method_for_dataToolButton_action() {
        this._tools.showDataTool(this._view.Etrail);
    }

    public void _method_for_clearButton_action() {
        this._view.clearData();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }
}

