/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.ElectricMultipoleField_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.eckerd.coxaj.elec_distribution.ElectricMultipoleField_pkg.ElectricMultipoleFieldSimulation;
import users.eckerd.coxaj.elec_distribution.ElectricMultipoleField_pkg.ElectricMultipoleFieldView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectricMultipoleField
extends Model {
    public ElectricMultipoleFieldSimulation _simulation = null;
    public ElectricMultipoleFieldView _view = null;
    public ElectricMultipoleField _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double q = 1.0;
    public double size = 1.0;
    public double xmin = -this.size;
    public double xmax = this.size;
    public double ymin = -this.size;
    public double ymax = this.size;
    public int nx = 20;
    public int ny = 20;
    public double[][] xField;
    public double[][] yField;
    public double[][] elecField;
    public double[][] potential;
    public String fieldValue = "0";
    public String potentialValue = "0";
    public double xDetector = 0.5;
    public double yDetector = 0.0;
    public double xSizeArrow = 1.0;
    public double ySizeArrow = 0.0;
    public boolean showPotential = false;
    public boolean collectData = false;
    public double[] magRow;
    public int pole = 0;
    public String tableLabel = "E";
    public String plotTitle = "Field Vectors";
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(472, 556);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/circle.gif");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ElectricMultipoleField.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/circle.gif");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/Copy of ElectricMultipoleField.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/CoulombPendulumLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/dipole_field.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ejsPage.css");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/electricDipole.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/electricMultipole.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ElectricMultipoleField.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ElectricMultipoleLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ElectricMultipoleStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/ElectricMultipoleField/ElectricMultipoleStudentWorksheet.pdf");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        ElectricMultipoleField._common_initialization(stringArray);
        ElectricMultipoleField electricMultipoleField = new ElectricMultipoleField(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        ElectricMultipoleField._common_initialization(stringArray);
        ElectricMultipoleField electricMultipoleField = new ElectricMultipoleField("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)electricMultipoleField._getView().getComponent("mainFrame");
    }

    public ElectricMultipoleField() {
        this(null, null, null, null, null, false);
    }

    public ElectricMultipoleField(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public ElectricMultipoleField(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new ElectricMultipoleFieldSimulation(this, string, frame, uRL, bl);
        this._view = (ElectricMultipoleFieldView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_constraints1 = true;
        this.q = 1.0;
        this.size = 1.0;
        this.xmin = -this.size;
        this.xmax = this.size;
        this.ymin = -this.size;
        this.ymax = this.size;
        this.nx = 20;
        this.ny = 20;
        this.xField = new double[this.nx][this.ny];
        this.yField = new double[this.nx][this.ny];
        this.elecField = new double[this.nx][this.ny];
        this.potential = new double[this.nx][this.ny];
        this.fieldValue = "0";
        this.potentialValue = "0";
        this.xDetector = 0.5;
        this.yDetector = 0.0;
        this.xSizeArrow = 1.0;
        this.ySizeArrow = 0.0;
        this.showPotential = false;
        this.collectData = false;
        this.magRow = new double[3];
        this.pole = 0;
        this.tableLabel = "E";
        this.plotTitle = "Field Vectors";
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.xField = null;
        this.yField = null;
        this.elecField = null;
        this.potential = null;
        this.magRow = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.computeField();
    }

    public void _constraints1() {
        double[] dArray = this.getE(this.xDetector, this.yDetector);
        this.xSizeArrow = dArray[2] > 0.0 ? dArray[0] / dArray[2] : 0.0;
        this.ySizeArrow = dArray[2] > 0.0 ? dArray[1] / dArray[2] : 0.0;
        this.fieldValue = " E=" + this._view.format(this.getE(this.xDetector, this.yDetector)[2], "0.00");
        this.potentialValue = " V=" + this._view.format(this.getE(this.xDetector, this.yDetector)[3], "0.00");
    }

    public void computeField() {
        for (int i = 0; i < this.nx; ++i) {
            double d = this._view.vectorField2D.indexToX(i);
            for (int j = 0; j < this.ny; ++j) {
                double d2 = this._view.vectorField2D.indexToY(j);
                double[] dArray = this.getE(d, d2);
                this.xField[i][j] = dArray[0];
                this.yField[i][j] = dArray[1];
                this.elecField[i][j] = dArray[2];
                this.potential[i][j] = dArray[3];
            }
        }
    }

    public double[] getE(double d, double d2) {
        double[] dArray = new double[4];
        int n = this.pole > 0 ? 2 : 1;
        int n2 = this.pole > 1 ? 2 : 1;
        for (int i = 0; i < n2; ++i) {
            double d3 = n2 == 1 ? d : d + (-0.05 + (double)i * 0.1);
            for (int j = 0; j < n; ++j) {
                double d4 = n == 1 ? d2 : d2 + (-0.05 + (double)j * 0.1);
                double d5 = 3.0 * this.q * Math.pow(-1.0, j + i);
                double d6 = d3 * d3 + d4 * d4;
                double d7 = Math.sqrt(d6);
                double d8 = d6 * d7;
                if (d6 == 0.0) {
                    dArray[0] = 0.0;
                    dArray[1] = 0.0;
                    dArray[3] = 0.0;
                    continue;
                }
                dArray[0] = dArray[0] + d5 * d3 / d8;
                dArray[1] = dArray[1] + d5 * d4 / d8;
                dArray[3] = dArray[3] + d5 / d7;
            }
        }
        dArray[2] = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        return dArray;
    }

    public void recordData() {
        this.collectData = false;
        this.magRow[0] = this.xDetector;
        this.magRow[1] = this.yDetector;
        this.magRow[2] = this.showPotential ? this.getE(this.xDetector, this.yDetector)[3] : this.getE(this.xDetector, this.yDetector)[2];
        this._view.xytrail.addPoint(this.xDetector, this.yDetector);
        this._view.Etrail.addPoint(this.xDetector, this.getE(this.xDetector, this.yDetector)[2]);
        this._view.Vtrail.addPoint(this.xDetector, this.getE(this.xDetector, this.yDetector)[3]);
        this.collectData = true;
    }

    public double _method_for_multipolePlottingPanel_minimumX() {
        return -this.size;
    }

    public double _method_for_multipolePlottingPanel_minimumY() {
        return -this.size;
    }

    public boolean _method_for_fieldVectorsGroup_visible() {
        return !this.showPotential;
    }

    public void _method_for_chargeSlider_dragaction() {
        this.computeField();
    }

    public void _method_for_chargeField_action() {
        this.q = Math.max(this.q, 0.0);
        this.computeField();
    }

    public void _method_for_fieldPotentialButton_actionOn() {
        this._view.clearData();
        this.plotTitle = "Field Vectors";
        this.tableLabel = "E";
    }

    public void _method_for_fieldPotentialButton_actionOff() {
        this._view.clearData();
        this.plotTitle = "Scalar Potential";
        this.tableLabel = "V";
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_pdfButton_action() {
        this._view.showDocument("./ElectricMultipoleField/ElectricMultipoleStudentWorksheet.pdf");
    }

    public void _method_for_monopoleButton_actionon() {
        this.pole = 0;
        this._view.clearData();
        this.computeField();
    }

    public void _method_for_dipoleButton_actionon() {
        this.pole = 1;
        this._view.clearData();
        this.computeField();
    }

    public void _method_for_quadrupoleButton_actionon() {
        this.pole = 2;
        this._view.clearData();
        this.computeField();
    }

    public String[] _method_for_dataTable_columnNames() {
        return new String[]{"#", "x", "y", this.tableLabel};
    }

    public void _method_for_recordDataButton_actionOff() {
        this.recordData();
    }

    public void _method_for_dataToolButton_action() {
        this._tools.showDataTool(this._view.xytrail, this._view.Etrail, this._view.Vtrail);
    }

    public void _method_for_clearButton_action() {
        this._view.clearData();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }
}

