/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.CoulombPendulum_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.eckerd.coxaj.elec_distribution.CoulombPendulum_pkg.CoulombPendulumSimulation;
import users.eckerd.coxaj.elec_distribution.CoulombPendulum_pkg.CoulombPendulumView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoulombPendulum
extends Model {
    public CoulombPendulumSimulation _simulation = null;
    public CoulombPendulumView _view = null;
    public CoulombPendulum _model = this;
    protected Hashtable<String, __PrivateODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double t;
    public double[] x;
    public double[] y;
    public double[] phi;
    public double[] omega;
    public double[] acc;
    public int[] color;
    public double[] xDrag;
    public double[] yDrag;
    public double qGreen;
    public double qRed;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/CoulombPendulum.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(397, 398);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/chargePendulumImage.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulum.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulumLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulumLessonPlan.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulumStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulumStudentWorksheet.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/ejsPage.css");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombPendulum/CoulombPendulum.html");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        CoulombPendulum._common_initialization(stringArray);
        CoulombPendulum coulombPendulum = new CoulombPendulum(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        CoulombPendulum._common_initialization(stringArray);
        CoulombPendulum coulombPendulum = new CoulombPendulum("drawingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)coulombPendulum._getView().getComponent("drawingFrame");
    }

    public CoulombPendulum() {
        this(null, null, null, null, null, false);
    }

    public CoulombPendulum(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public CoulombPendulum(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new CoulombPendulumSimulation(this, string, frame, uRL, bl);
        this._view = (CoulombPendulumView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.x = new double[2];
        this.y = new double[2];
        this.phi = new double[2];
        this.omega = new double[2];
        this.acc = new double[2];
        this.color = new int[2];
        this.xDrag = new double[2];
        this.yDrag = new double[2];
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        for (__PrivateODE __PrivateODE2 : this._privateOdesList.values()) {
            __PrivateODE2.__initializeSolver();
        }
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.__resetSolver();
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.__stepODE();
        }
    }

    @Override
    public void _updateModel() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.phi = null;
        this.omega = null;
        this.acc = null;
        this.color = null;
        this.xDrag = null;
        this.yDrag = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).__getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).__setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.phi[0] = -1.0;
        this.phi[1] = -2.0;
        for (int i = 0; i < 2; ++i) {
            this.x[i] = Math.cos(this.phi[i]);
            this.y[i] = Math.sin(this.phi[i]);
            this.xDrag[i] = this.x[i] / 2.0;
            this.yDrag[i] = this.y[i] / 2.0;
            this.color[i] = i;
        }
    }

    public void _constraints1() {
        for (int i = 0; i < 2; ++i) {
            this.x[i] = Math.cos(this.phi[i]);
            this.y[i] = Math.sin(this.phi[i]);
            this.xDrag[i] = this.x[i] / 2.0;
            this.yDrag[i] = this.y[i] / 2.0;
        }
    }

    public void newPosition() {
        for (int i = 0; i < 2; ++i) {
            this.phi[i] = Math.atan2(this.yDrag[i], this.xDrag[i]);
            this.t = 0.0;
            this.omega[i] = 0.0;
        }
    }

    public boolean _method_for_dragParticleSet_visible() {
        return this._isPaused();
    }

    public boolean _method_for_dragParticleSet_enabledPosition() {
        return this._isPaused();
    }

    public void _method_for_dragParticleSet_dragAction() {
        this.newPosition();
    }

    public boolean _method_for_dragTextGroup_visible() {
        return this._isPaused();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_pdfButton_action() {
        this._view.showDocument("./CoulombPendulum/CoulombPendulumStudentWorksheet.pdf");
    }

    public double _method_for_phi1_variable() {
        return this.phi[1] * 180.0 / Math.PI + 90.0;
    }

    public double _method_for_phi0_variable() {
        return this.phi[0] * 180.0 / Math.PI + 90.0;
    }

    public void _method_for_dampButton_action() {
        for (int i = 0; i < 2; ++i) {
            this.omega[i] = 0.0;
        }
    }

    public void _method_for_greenChargeField_action() {
        this.qGreen = Math.max(this.qGreen, 1.0);
        this.qGreen = Math.min(this.qGreen, 4.0);
    }

    public void _method_for_redCurrentField_action() {
        this.qRed = Math.max(this.qRed, 1.0);
        this.qRed = Math.min(this.qRed, 4.0);
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements __PrivateODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustReinitialize = true;
        private double[] _phi;
        private double[] _omega;

        _ODE_evolution1() {
            this.__instantiateSolver();
            CoulombPendulum.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver __getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void __setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        private void __instantiateSolver() {
            this.__state = new double[1 + CoulombPendulum.this.phi.length + CoulombPendulum.this.omega.length];
            this._phi = new double[CoulombPendulum.this.phi.length];
            this._omega = new double[CoulombPendulum.this.omega.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
        }

        @Override
        public void __initializeSolver() {
            this.__pushState();
            this.__eventSolver.initialize(0.05);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__mustReinitialize = true;
        }

        private void __pushState() {
            int n;
            int n2;
            int n3 = 0;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < CoulombPendulum.this.phi.length) {
                    if (this.__state[n] != CoulombPendulum.this.phi[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(CoulombPendulum.this.phi, 0, this.__state, n3, CoulombPendulum.this.phi.length);
            n3 += CoulombPendulum.this.phi.length;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < CoulombPendulum.this.omega.length) {
                    if (this.__state[n] != CoulombPendulum.this.omega[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(CoulombPendulum.this.omega, 0, this.__state, n3, CoulombPendulum.this.omega.length);
            if (this.__state[n3 += CoulombPendulum.this.omega.length] != CoulombPendulum.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = CoulombPendulum.this.t;
        }

        private boolean __arraysChanged() {
            if (CoulombPendulum.this.phi.length != this._phi.length) {
                return true;
            }
            return CoulombPendulum.this.omega.length != this._omega.length;
        }

        public void __resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            CoulombPendulumSimulation cfr_ignored_0 = CoulombPendulum.this._simulation;
            CoulombPendulumSimulation cfr_ignored_1 = CoulombPendulum.this._simulation;
            int n = JOptionPane.showConfirmDialog(CoulombPendulum.this._view.getComponent(CoulombPendulum.this._simulation.getMainWindow()), CoulombPendulumSimulation.getEjsString("ODEError.Continue"), CoulombPendulumSimulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                CoulombPendulum.this._pause();
            }
        }

        void __stepODE() {
            if (this.__arraysChanged()) {
                this.__initializeSolver();
            }
            this.__eventSolver.setStepSize(0.05);
            this.__eventSolver.setInternalStepSize(0.05);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(1.0E-5, 1.0E-5);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
            }
            double d = this.__eventSolver.step();
            int n = 0;
            System.arraycopy(this.__state, n, CoulombPendulum.this.phi, 0, CoulombPendulum.this.phi.length);
            System.arraycopy(this.__state, n += CoulombPendulum.this.phi.length, CoulombPendulum.this.omega, 0, CoulombPendulum.this.omega.length);
            n += CoulombPendulum.this.omega.length;
            CoulombPendulum.this.t = this.__state[n++];
            if (Double.isNaN(d)) {
                this.__errorAction();
            }
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double[] dArray3 = this._phi;
            System.arraycopy(dArray, n3, this._phi, 0, this._phi.length);
            double[] dArray4 = this._omega;
            System.arraycopy(dArray, n3 += this._phi.length, this._omega, 0, this._omega.length);
            n3 += this._omega.length;
            double d = dArray[n3++];
            double d2 = Math.sin(dArray3[1] - dArray3[0]);
            double d3 = Math.cos(dArray3[1] - dArray3[0]);
            double d4 = CoulombPendulum.this.qRed * CoulombPendulum.this.qGreen;
            double d5 = d4 * 0.009 / 0.017;
            for (n = 0; n < 2; ++n) {
                CoulombPendulum.this.acc[n] = -d5 * Math.pow(-1.0, n) * d2 / Math.pow(1.0 - d3, 1.5) - 9.8 * Math.cos(dArray3[n]);
            }
            n3 = 0;
            int n4 = this._phi.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = dArray4[n];
            }
            n4 = this._omega.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = CoulombPendulum.this.acc[n];
            }
            dArray2[n3++] = 1.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface __PrivateODE
    extends ODE {
        public ODEInterpolatorEventSolver __getEventSolver();

        public void __setSolverClass(Class<?> var1);

        public void __initializeSolver();
    }
}

