/*
 * Decompiled with CFR 0.152.
 */
package users.eckerd.coxaj.elec_distribution.CoulombForce_pkg;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.eckerd.coxaj.elec_distribution.CoulombForce_pkg.CoulombForceSimulation;
import users.eckerd.coxaj.elec_distribution.CoulombForce_pkg.CoulombForceView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoulombForce
extends Model {
    public CoulombForceSimulation _simulation = null;
    public CoulombForceView _view = null;
    public CoulombForce _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public int n = 2;
    public int nmax = 6;
    public double q0 = 1.0;
    public double[] q;
    public double[] x;
    public double[] y;
    public double[] xForce;
    public double[] yForce;
    public double[] elecForce;
    public String[] forceValue;
    public int[] color;
    public double[] r;
    public double size = 1.0;
    public double xmin = -this.size;
    public double xmax = this.size;
    public double ymin = -this.size;
    public double ymax = this.size;
    public String colorStr = "";
    public String colorValue = "null";
    public int qLabel = 0;
    public String[] StrData;
    private boolean _isEnabled_initialization1 = true;

    public static String _getEjsModel() {
        return "/users/eckerd/coxaj/elec_distribution/CoulombForce.xml";
    }

    public static String _getModelDirectory() {
        return "users/eckerd/coxaj/elec_distribution/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(472, 556);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/CoulombForce.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/CoulombForce.html");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/coulombForce.jpg");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/CoulombForceLessonPlan.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/CoulombForceStudentWorksheet.doc");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/CoulombForceStudentWorksheet.pdf");
        hashSet.add("/users/eckerd/coxaj/elec_distribution/CoulombForceWrong/ejsPage.css");
        return hashSet;
    }

    public static void _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/eckerd/coxaj/elec_distribution/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/EJS_4.2/bin/config/");
        }
    }

    public static void main(String[] stringArray) {
        CoulombForce._common_initialization(stringArray);
        CoulombForce coulombForce = new CoulombForce(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        CoulombForce._common_initialization(stringArray);
        CoulombForce coulombForce = new CoulombForce("mainFrame", jFrame, null, null, stringArray, true);
        return (JComponent)coulombForce._getView().getComponent("mainFrame");
    }

    public CoulombForce() {
        this(null, null, null, null, null, false);
    }

    public CoulombForce(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public CoulombForce(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new CoulombForceSimulation(this, string, frame, uRL, bl);
        this._view = (CoulombForceView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this.n = 2;
        this.nmax = 6;
        this.q0 = 1.0;
        this.q = new double[this.nmax];
        this.x = new double[this.nmax];
        this.y = new double[this.nmax];
        this.xForce = new double[this.nmax];
        this.yForce = new double[this.nmax];
        this.elecForce = new double[this.nmax];
        this.forceValue = new String[this.nmax];
        this.color = new int[this.nmax];
        this.r = new double[this.nmax];
        this.size = 1.0;
        this.xmin = -this.size;
        this.xmax = this.size;
        this.ymin = -this.size;
        this.ymax = this.size;
        this.colorStr = "";
        this.colorValue = "null";
        this.qLabel = 0;
        this.StrData = new String[]{"red", "green", "blue", "yellow", "cyan", "magneta"};
    }

    @Override
    public void _initializeModel() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public void _stepModel() {
    }

    @Override
    public void _updateModel() {
    }

    @Override
    public void _freeMemory() {
        this.q = null;
        this.x = null;
        this.y = null;
        this.xForce = null;
        this.yForce = null;
        this.elecForce = null;
        this.forceValue = null;
        this.color = null;
        this.r = null;
        this.StrData = null;
        System.gc();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.n = 2;
        for (int i = 0; i < this.n; ++i) {
            this.q[i] = 1.0;
            this.x[i] = -1.0 + 2.0 * Math.random();
            this.y[i] = -1.0 + 2.0 * Math.random();
            this.color[i] = i;
            this.r[i] = this.q[i] / 10.0;
            this.forceValue[i] = "F";
            this.colorStr = this.colorStr + this.StrData[i] + ";";
        }
        this.calcF();
    }

    public void calcF() {
        for (int i = 0; i < this.n; ++i) {
            this.xForce[i] = 0.0;
            this.yForce[i] = 0.0;
            this.elecForce[i] = 0.0;
            this.q[this.qLabel] = this.q0;
            for (int j = 0; j < this.n; ++j) {
                if (i == j) continue;
                double d = this.x[i] - this.x[j];
                double d2 = this.y[i] - this.y[j];
                double d3 = d * d + d2 * d2;
                double d4 = Math.sqrt(d3);
                double d5 = d / d4;
                double d6 = d2 / d4;
                double d7 = d3 * d4;
                double d8 = this.q[i] * this.q[j] / d3;
                this.xForce[i] = this.xForce[i] + d8 * d5;
                this.yForce[i] = this.yForce[i] + d8 * d6;
            }
            this.elecForce[i] = Math.sqrt(this.xForce[i] * this.xForce[i] + this.yForce[i] * this.yForce[i]);
            this.forceValue[i] = " F=" + this._view.format(this.elecForce[i], "0.0");
        }
    }

    public void addCharge() {
        if (this.n > this.nmax - 1) {
            this._view.alert("addChargeButton", "Too many charges", "Model is limited to 6 charges.");
        } else {
            this.x[this.n] = -1.0 + 2.0 * Math.random();
            this.y[this.n] = -1.0 + 2.0 * Math.random();
            this.color[this.n] = this.n;
            this.q[this.n] = 1.0;
            this.r[this.n] = this.q[this.n] / 10.0;
            this.colorStr = this.colorStr + this.StrData[this.n] + ";";
            ++this.n;
        }
        this.calcF();
    }

    public void setQ() {
        if (this.colorValue.equals("red")) {
            this.qLabel = 0;
        } else if (this.colorValue.equals("green")) {
            this.qLabel = 1;
        } else if (this.colorValue.equals("blue")) {
            this.qLabel = 2;
        } else if (this.colorValue.equals("yellow")) {
            this.qLabel = 3;
        } else if (this.colorValue.equals("cyan")) {
            this.qLabel = 4;
        } else if (this.colorValue.equals("magneta")) {
            this.qLabel = 5;
        }
        this.q[this.qLabel] = this.q0;
        this.r[this.qLabel] = this.q[this.qLabel] / 10.0;
        this.calcF();
    }

    public double _method_for_vectorFieldPlottingPanel_minimumX() {
        return -this.size;
    }

    public double _method_for_vectorFieldPlottingPanel_minimumY() {
        return -this.size;
    }

    public void _method_for_shapeSet_dragAction() {
        this.calcF();
    }

    public void _method_for_addChargeButton_action() {
        this.addCharge();
    }

    public void _method_for_chargeSlider_dragaction() {
        this.r[this.qLabel] = this.q[this.qLabel] / 10.0;
        this.calcF();
    }

    public void _method_for_comboBox_action() {
        this.setQ();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_documentationButton_action() {
        this._view.showDocument("./CoulombForceWrong/CoulombForceStudentWorksheet.pdf");
    }
}

