/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LauncherUndo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchPanel
extends JPanel {
    protected static final String TEXT_TYPE = "text";
    protected JTree tree;
    protected DefaultTreeModel treeModel;
    protected JSplitPane splitPane;
    protected JPanel dataPanel;
    protected JTabbedPane tabbedPane;
    protected JEditorPane descriptionPane;
    protected JScrollPane descriptionScroller;
    protected boolean showAllNodes;
    protected Map<LaunchNode, VisibleNode> visibleNodeMap = new HashMap<LaunchNode, VisibleNode>();
    protected Launcher launcher;
    protected boolean rebuildingTabs;

    public LaunchPanel(LaunchNode launchNode, Launcher launcher2) {
        this.showAllNodes = launcher2 instanceof LaunchBuilder;
        this.launcher = launcher2;
        this.createGUI();
        this.createTree(launchNode);
        this.setSelectedNode(launchNode);
    }

    public void setSelectedNode(LaunchNode launchNode) {
        if (launchNode == null) {
            return;
        }
        if (launchNode == this.getSelectedNode()) {
            this.displayTabs(launchNode);
        } else {
            this.tree.setSelectionPath(new TreePath(launchNode.getPath()));
        }
    }

    public void setSelectedNodes(ArrayList<LaunchNode> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        TreePath[] treePathArray = new TreePath[arrayList.size()];
        int n = 0;
        for (LaunchNode launchNode : arrayList) {
            treePathArray[n++] = new TreePath(launchNode.getPath());
        }
        this.tree.setSelectionPaths(treePathArray);
    }

    public void setSelectedNode(LaunchNode launchNode, int n) {
        this.setSelectedNode(launchNode, n, null);
    }

    public void setSelectedNode(LaunchNode launchNode, int n, URL uRL) {
        int n2 = launchNode.tabNumber = uRL == null && launchNode.getDisplayTabCount() == 0 ? -1 : n;
        if (uRL != null) {
            launchNode.htmlURL = uRL;
        }
        this.setSelectedNode(launchNode);
    }

    public LaunchNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (LaunchNode)treePath.getLastPathComponent();
    }

    public ArrayList<LaunchNode> getSelectedNodes() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        ArrayList<LaunchNode> arrayList = new ArrayList<LaunchNode>();
        int n = 0;
        while (n < treePathArray.length) {
            arrayList.add((LaunchNode)treePathArray[n].getLastPathComponent());
            ++n;
        }
        ArrayList<LaunchNode> arrayList2 = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> enumeration = this.getRootNode().preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (!arrayList.contains(launchNode)) continue;
            arrayList2.add(launchNode);
        }
        return arrayList2;
    }

    public int getSelectedDisplayTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public LaunchNode getRootNode() {
        return (LaunchNode)this.treeModel.getRoot();
    }

    protected LaunchNode getClone(LaunchNode launchNode) {
        if (launchNode.getFileName() == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
            if (!launchNode.getFileName().equals(launchNode2.getFileName())) continue;
            return launchNode2;
        }
        return null;
    }

    protected void displayTabs(LaunchNode launchNode) {
        if (launchNode != null) {
            OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.NodeSelected")) + " " + launchNode);
            boolean bl = this.launcher instanceof LaunchBuilder;
            String string = LaunchRes.getString("HTMLTab.Title.Untitled");
            URL uRL = launchNode.htmlURL;
            int n = launchNode.tabNumber;
            boolean bl2 = false;
            if (uRL == null && launchNode.getDisplayTabCount() > 0) {
                n = Math.max(0, n);
                LaunchNode.DisplayTab displayTab = launchNode.getDisplayTab(n);
                if (displayTab.url != null) {
                    uRL = displayTab.url;
                } else {
                    bl2 = displayTab.getModelClass() != null;
                }
            }
            this.rebuildingTabs = true;
            int n2 = 0;
            if (!bl) {
                this.tabbedPane.removeAll();
            }
            for (LaunchNode.DisplayTab object : launchNode.tabData) {
                Object object2;
                if (object.url != null) {
                    try {
                        if (object.url.getContent() == null) continue;
                        object2 = this.launcher.getHTMLTab(n2);
                        URL uRL2 = n == n2 && uRL != null ? uRL : object.url;
                        boolean bl3 = launchNode.enabled;
                        Runnable runnable = new Runnable((Launcher.HTMLPane)object2, uRL2, object, bl3){
                            private final /* synthetic */ Launcher.HTMLPane val$html;
                            private final /* synthetic */ URL val$theURL;
                            private final /* synthetic */ LaunchNode.DisplayTab val$displayTab;
                            private final /* synthetic */ boolean val$nodeEnabled;
                            {
                                this.val$html = hTMLPane;
                                this.val$theURL = uRL;
                                this.val$displayTab = displayTab;
                                this.val$nodeEnabled = bl;
                            }

                            public void run() {
                                try {
                                    this.val$html.editorPane.setPage(this.val$theURL);
                                }
                                catch (IOException iOException) {}
                                if (this.val$theURL.getRef() != null) {
                                    this.val$html.editorPane.scrollToReference(this.val$theURL.getRef());
                                }
                                LaunchPanel.this.launcher.setLinksEnabled(this.val$html.editorPane, this.val$displayTab.hyperlinksEnabled && this.val$nodeEnabled);
                            }
                        };
                        if (SwingUtilities.isEventDispatchThread()) {
                            runnable.run();
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                        if (bl) continue;
                        String string2 = object.title == null ? string : object.title;
                        this.tabbedPane.addTab(string2, ((Launcher.HTMLPane)object2).scroller);
                        ++n2;
                    }
                    catch (IOException iOException) {
                        OSPLog.fine(String.valueOf(LaunchRes.getString("Log.Message.BadURL")) + " " + object.url);
                    }
                    continue;
                }
                if (object.getModelScroller() == null || bl) continue;
                object2 = object.title == null ? string : object.title;
                this.tabbedPane.addTab((String)object2, object.getModelScroller());
                ++n2;
            }
            if (!bl) {
                if (uRL != null || bl2) {
                    if (this.tabbedPane.getTabCount() == 1 && this.tabbedPane.getTitleAt(0).equals(string)) {
                        this.splitPane.setRightComponent(this.tabbedPane.getComponentAt(0));
                    } else if (this.tabbedPane.getTabCount() > 0) {
                        this.splitPane.setRightComponent(this.tabbedPane);
                        if (this.tabbedPane.getTabCount() > n) {
                            this.tabbedPane.setSelectedIndex(n);
                        }
                    }
                } else {
                    JScrollPane jScrollPane = launchNode.getLaunchModelScroller();
                    if (jScrollPane != null) {
                        this.splitPane.setRightComponent(jScrollPane);
                    } else {
                        this.descriptionPane.setText(launchNode.description);
                        this.splitPane.setRightComponent(this.descriptionScroller);
                    }
                }
            }
            this.rebuildingTabs = false;
            this.launcher.refreshGUI();
        }
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.dataPanel = new JPanel(new BorderLayout());
        this.descriptionPane = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setContentType(TEXT_TYPE);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LaunchNode launchNode = LaunchPanel.this.getSelectedNode();
                if (launchNode != null && launchNode == LaunchPanel.this.launcher.selectedNode) {
                    if (LaunchPanel.this.rebuildingTabs && launchNode.htmlURL != null) {
                        return;
                    }
                    launchNode.prevTabNumber = launchNode.tabNumber;
                    launchNode.prevURL = launchNode.htmlURL;
                    int n = Math.max(0, LaunchPanel.this.tabbedPane.getSelectedIndex());
                    int n2 = launchNode.tabNumber = launchNode.tabData.isEmpty() ? -1 : n;
                    if (launchNode.tabNumber > -1) {
                        Launcher.HTMLPane hTMLPane = LaunchPanel.this.launcher.getHTMLTab(launchNode.tabNumber);
                        launchNode.htmlURL = hTMLPane.editorPane.getPage();
                    }
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                LaunchNode launchNode = LaunchPanel.this.getSelectedNode();
                if (launchNode != null && LaunchPanel.this.launcher.postEdits) {
                    String string = launchNode.getPathString();
                    Integer n = new Integer(launchNode.prevTabNumber);
                    Integer n2 = new Integer(launchNode.tabNumber);
                    Object[] objectArray = new Object[4];
                    objectArray[1] = string;
                    objectArray[2] = n;
                    objectArray[3] = launchNode.prevURL;
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[4];
                    objectArray3[1] = string;
                    objectArray3[2] = n2;
                    objectArray3[3] = launchNode.htmlURL;
                    Object[] objectArray4 = objectArray3;
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit navEdit = launcherUndo.new LauncherUndo.NavEdit(objectArray2, objectArray4);
                    LaunchPanel.this.launcher.undoSupport.postEdit(navEdit);
                }
            }
        });
        this.splitPane.setRightComponent(this.dataPanel);
        this.splitPane.setDividerLocation(160);
    }

    protected void createTree(LaunchNode launchNode) {
        Serializable serializable;
        if (!this.showAllNodes) {
            serializable = new VisibleNode(launchNode);
            this.visibleNodeMap.put(launchNode, (VisibleNode)serializable);
            this.addVisibleNodes((VisibleNode)serializable);
        }
        this.treeModel = new LaunchTreeModel(launchNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setToolTipText("");
        this.tree.setRootVisible(!launchNode.hiddenWhenRoot);
        if (this.launcher instanceof LaunchBuilder) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath;
                LaunchNode launchNode = LaunchPanel.this.launcher.getSelectedNode();
                if (LaunchPanel.this.launcher.postEdits && (treePath = treeSelectionEvent.getOldLeadSelectionPath()) != null && launchNode != null) {
                    LaunchNode launchNode2 = (LaunchNode)treePath.getLastPathComponent();
                    if (!launchNode.tabData.isEmpty()) {
                        int n = Math.max(0, launchNode.tabNumber);
                        LaunchNode.DisplayTab displayTab = launchNode.tabData.get(n);
                        launchNode.htmlURL = displayTab.url;
                        launchNode.tabNumber = n;
                    }
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit navEdit = launcherUndo.new LauncherUndo.NavEdit(launchNode2, launchNode);
                    LaunchPanel.this.launcher.undoSupport.postEdit(navEdit);
                }
                LaunchPanel.this.displayTabs(launchNode);
            }
        });
        serializable = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent((Component)serializable);
    }

    protected Collection<String> getExpandedNodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreePath treePath = new TreePath(this.getRootNode());
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration != null && enumeration.hasMoreElements()) {
            TreePath treePath2 = enumeration.nextElement();
            LaunchNode launchNode = (LaunchNode)treePath2.getLastPathComponent();
            arrayList.add(launchNode.getPathString());
        }
        return arrayList;
    }

    protected void setExpandedNodes(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                if (!string.equals(launchNode.getPathString())) continue;
                TreePath treePath = new TreePath(launchNode.getPath());
                this.tree.expandPath(treePath);
            }
        }
    }

    private void addVisibleNodes(VisibleNode visibleNode) {
        int n = visibleNode.node.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            LaunchNode launchNode = (LaunchNode)visibleNode.node.getChildAt(n2);
            if (!launchNode.isHiddenInLauncher()) {
                VisibleNode visibleNode2 = new VisibleNode(launchNode);
                this.visibleNodeMap.put(launchNode, visibleNode2);
                visibleNode.add(visibleNode2);
                this.addVisibleNodes(visibleNode2);
            }
            ++n2;
        }
    }

    class LaunchTreeModel
    extends DefaultTreeModel {
        LaunchTreeModel(LaunchNode launchNode) {
            super(launchNode);
        }

        public Object getChild(Object object, int n) {
            VisibleNode visibleNode;
            if (LaunchPanel.this.showAllNodes) {
                return super.getChild(object, n);
            }
            VisibleNode visibleNode2 = LaunchPanel.this.visibleNodeMap.get(object);
            if (visibleNode2 != null && (visibleNode = (VisibleNode)visibleNode2.getChildAt(n)) != null) {
                return visibleNode.node;
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getChildCount(object);
            }
            VisibleNode visibleNode = LaunchPanel.this.visibleNodeMap.get(object);
            if (visibleNode != null) {
                return visibleNode.getChildCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getIndexOfChild(object, object2);
            }
            VisibleNode visibleNode = LaunchPanel.this.visibleNodeMap.get(object);
            VisibleNode visibleNode2 = LaunchPanel.this.visibleNodeMap.get(object2);
            if (visibleNode != null && visibleNode2 != null) {
                return visibleNode.getIndex(visibleNode2);
            }
            return -1;
        }
    }

    private class VisibleNode
    extends DefaultMutableTreeNode {
        LaunchNode node;

        VisibleNode(LaunchNode launchNode) {
            this.node = launchNode;
        }
    }
}

