/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.opensourcephysics.tools.CheckTreeCellRenderer;
import org.opensourcephysics.tools.CheckTreeSelectionModel;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener,
MouseMotionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;
    boolean ignoreEvents;

    public CheckTreeManager(JTree jTree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.ignoreEvents = false;
        this.tree = jTree;
        this.selectionModel = new CheckTreeSelectionModel(jTree.getModel());
        jTree.setCellRenderer(new CheckTreeCellRenderer(jTree.getCellRenderer(), this.selectionModel));
        jTree.addMouseListener(this);
        jTree.addMouseMotionListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)treePath).x + this.hotspot - 3 || mouseEvent.getX() < this.tree.getPathBounds((TreePath)treePath).x + 2) {
            this.tree.setCursor(Cursor.getDefaultCursor());
        } else {
            this.tree.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        if (mouseEvent.getX() > this.tree.getPathBounds((TreePath)treePath).x + this.hotspot) {
            return;
        }
        boolean bl = this.selectionModel.isPathOrAncestorSelected(treePath);
        try {
            this.ignoreEvents = true;
            if (bl) {
                this.selectionModel.removeSelectionPath(treePath);
            } else {
                this.selectionModel.addSelectionPath(treePath);
            }
        }
        finally {
            this.ignoreEvents = false;
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.ignoreEvents) {
            this.tree.treeDidChange();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

