/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Polynomial;
import org.opensourcephysics.numerics.specialfunctions.Messages;
import org.opensourcephysics.numerics.specialfunctions.QNKey;

public class Laguerre {
    static final ArrayList<Polynomial> laguerreList;
    static final Map<QNKey, Polynomial> associatedLaguerreMap;

    static {
        associatedLaguerreMap = new HashMap<QNKey, Polynomial>();
        laguerreList = new ArrayList();
        Polynomial polynomial = new Polynomial(new double[]{1.0});
        laguerreList.add(polynomial);
        Polynomial polynomial2 = new Polynomial(new double[]{1.0, -1.0});
        laguerreList.add(polynomial2);
    }

    private Laguerre() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Laguerre.neg_degree"));
        }
        if (n < laguerreList.size()) {
            return laguerreList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{(2.0 * (double)n - 1.0) / (double)n, -1.0 / (double)n});
        Polynomial polynomial2 = Laguerre.getPolynomial(n - 1).multiply(polynomial);
        Polynomial polynomial3 = Laguerre.getPolynomial(n - 2).multiply((1.0 - (double)n) / (double)n);
        Polynomial polynomial4 = polynomial2.add(polynomial3);
        laguerreList.add(polynomial4);
        return polynomial4;
    }

    public static synchronized Polynomial getPolynomial(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(Messages.getString("Laguerre.neg_k"));
        }
        QNKey qNKey = new QNKey(n, n2);
        Polynomial polynomial = associatedLaguerreMap.get(qNKey);
        if (polynomial != null) {
            return polynomial;
        }
        polynomial = Laguerre.getPolynomial(n + n2);
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= -1;
            polynomial = polynomial.derivative();
            ++n4;
        }
        if (n3 == -1) {
            polynomial = polynomial.multiply(n3);
        }
        associatedLaguerreMap.put(qNKey, polynomial);
        return polynomial;
    }

    public static double evaluate(int n, double d) {
        return Laguerre.getPolynomial(n).evaluate(d);
    }
}

