/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import org.opensourcephysics.numerics.Function;

public class ErrorFunction
implements Function {
    public double evaluate(double d) {
        return ErrorFunction.errf(d);
    }

    public static double errf(double d) {
        if (d > 26.0) {
            return 1.0;
        }
        if (d < -5.5) {
            return -1.0;
        }
        double d2 = Math.abs(d);
        if (d2 <= 0.5) {
            double d3 = d * d;
            double d4 = ((-0.0356098437018154 * d3 + 6.99638348861914) * d3 + 21.9792616182942) * d3 + 242.667955230532;
            double d5 = ((d3 + 15.0827976304078) * d3 + 91.1649054045149) * d3 + 215.058875869861;
            return d * d4 / d5;
        }
        if (d < 0.0) {
            return -(1.0 - Math.exp(-d * d) * ErrorFunction.nonexperfc(d2));
        }
        return 1.0 - Math.exp(-d * d) * ErrorFunction.nonexperfc(d2);
    }

    private static double nonexperfc(double d) {
        double d2 = Math.abs(d);
        if (d2 <= 0.5) {
            return Math.exp(d * d) * ErrorFunction.errf(d);
        }
        if (d2 < 4.0) {
            double d3 = d2;
            double d4 = ((((((-1.36864857382717E-7 * d3 + 0.564195517478974) * d3 + 7.21175825088309) * d3 + 43.1622272220567) * d3 + 152.98928504694) * d3 + 339.320816734344) * d3 + 451.918953711873) * d3 + 300.459261020162;
            double d5 = ((((((d3 + 12.7827273196294) * d3 + 77.0001529352295) * d3 + 277.585444743988) * d3 + 638.980264465631) * d3 + 931.35409485061) * d3 + 790.950925327898) * d3 + 300.459260956983;
            return d > 0.0 ? d4 / d5 : Math.exp(d * d) * 2.0 - d4 / d5;
        }
        double d6 = 1.0 / d / d;
        double d7 = (((0.0223192459734185 * d6 + 0.278661308609648) * d6 + 0.226956593539687) * d6 + 0.0494730910623251) * d6 + 0.00299610707703542;
        double d8 = (((d6 + 1.98733201817135) * d6 + 1.05167510706793) * d6 + 0.19130892610783) * d6 + 0.0106209230528468;
        d6 = (d6 * -d7 / d8 + 0.564189583547756) / d2;
        return d > 0.0 ? d6 : Math.exp(d * d) * 2.0 - d6;
    }
}

