/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.specialfunctions.Messages;

public class Bessel {
    static final Map<Integer, Function> functionMap = new HashMap<Integer, Function>();
    static final Map<Integer, Function> derivativeMap = new HashMap<Integer, Function>();

    public static synchronized Function getFunction(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Bessel.0.neg_order"));
        }
        Function function = functionMap.get(n);
        if (function != null) {
            return function;
        }
        function = new BesselFunction(n);
        functionMap.put(n, function);
        return function;
    }

    public static synchronized Function getDerivative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.getString("Bessel.1.neg_order"));
        }
        Function function = derivativeMap.get(n);
        if (function != null) {
            return function;
        }
        function = new BesselDerivative(n);
        derivativeMap.put(n, function);
        return function;
    }

    public static double besseln(int n, double d) {
        double d2;
        int n2 = n < 0 ? ((n = -n) % 2 == 0 ? 1 : -1) : 1;
        if (d < 0.0) {
            if (n % 2 != 0) {
                n2 = -n2;
            }
            d = -d;
        }
        if (n == 0) {
            double d3 = (double)n2 * Bessel.bessel0(d);
            return d3;
        }
        if (n == 1) {
            double d4 = (double)n2 * Bessel.bessel1(d);
            return d4;
        }
        if (n == 2) {
            double d5 = d == 0.0 ? 0.0 : (double)n2 * (2.0 * Bessel.bessel1(d) / d - Bessel.bessel0(d));
            return d5;
        }
        if (d < 1.0E-12) {
            double d6 = 0.0;
            return d6;
        }
        int n3 = 53;
        double d7 = d2 = (double)(2 * (n + n3));
        double d8 = d * d;
        while (n3 != 0) {
            d7 = (d2 -= 2.0) - d8 / d7;
            --n3;
        }
        d7 = d / d7;
        d2 = 1.0;
        double d9 = 1.0 / d7;
        n3 = n - 1;
        double d10 = 2 * n3;
        while (n3 != 0) {
            double d11 = (d9 * d10 - d2 * d) / d;
            d2 = d9;
            d9 = d11;
            d10 -= 2.0;
            --n3;
        }
        d7 = Math.abs(d2) > Math.abs(d9) ? Bessel.bessel1(d) / d2 : Bessel.bessel0(d) / d9;
        return (double)n2 * d7;
    }

    public static double besselnDerivative(int n, double d) {
        int n2 = n;
        if (n == 0) {
            double d2 = Bessel.besseln(1, d);
            return -d2;
        }
        int n3 = 1;
        int n4 = 1;
        int n5 = n2 - 1;
        int n6 = n2 + 1;
        if (n2 < 0) {
            if (n5 < 0) {
                n5 = -n5;
                n3 = -1;
            }
            if (n6 < 0) {
                n6 = -n6;
                n4 = -1;
            }
        }
        double d3 = Bessel.besseln(n5, d);
        double d4 = Bessel.besseln(n6, d);
        d3 = Math.pow(n3, n5) * d3;
        d4 = Math.pow(n4, n6) * d4;
        return (d3 - d4) / 2.0;
    }

    public static double[] besselnZeros(int n, int n2) {
        double[] dArray = new double[n2];
        if (n < 0) {
            n = -n;
        }
        double d = n <= 20 ? 2.82141 + 1.15859 * (double)n : (double)n + 1.85576 * Math.pow(n, 0.33333) + 1.03315 / Math.pow(n, 0.33333);
        int n3 = 0;
        while (true) {
            double d2;
            double d3;
            double d4 = d;
            if (Math.abs((d -= (d3 = Bessel.besseln(n, d)) / (d2 = Bessel.besselnDerivative(n, d))) - d4) > 1.0E-6) continue;
            dArray[n3] = d;
            d = d + Math.PI + (0.0972 + 0.0679 * (double)n - 3.54E-4 * Math.pow(n, 2.0)) / (double)(++n3);
            if (n3 >= n2) break;
        }
        return dArray;
    }

    public static double bessel0(double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{26857.86856980015, -4.050412371833133E7, 2.507158285536882E10, -8.085222034853794E12, 1.434354939140344E15, -1.3676203530881714E17, 6.382059341072356E18, -1.1791576291076106E20, 4.9337872517941336E20};
        double[] dArray3 = new double[]{1.0, 1363.0636523289706, 1114636.0984629854, 6.69998767298224E8, 3.1230431149412134E11, 1.1277567396797984E14, 3.0246356167094628E16, 5.428918384092285E18, 4.9337872517941336E20};
        if (d < 0.0) {
            d = -d;
        }
        if (d > 8.0) {
            dArray = Bessel.besselasympt0(d);
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = d - 0.7853981633974483;
            double d5 = Math.sqrt(0.6366197723675814 / d) * (d2 * Math.cos(d4) - d3 * Math.sin(d4));
            return d5;
        }
        double d6 = d * d;
        double d7 = dArray2[0];
        int n = 1;
        while (n < 9) {
            d7 = dArray2[n] + d7 * d6;
            ++n;
        }
        double d8 = dArray3[0];
        n = 1;
        while (n < 9) {
            d8 = dArray3[n] + d8 * d6;
            ++n;
        }
        return d7 / d8;
    }

    public static double bessel1(double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{2701.1227108923235, -4695753.530642996, 3.4132341823017006E9, -1.3229834803321265E12, 2.9087952638347756E14, -3.588817569910106E16, 2.3164335806340024E18, -6.672106568924916E19, 5.811993540016061E20};
        double[] dArray3 = new double[]{1.0, 1606.9315734814877, 1501793.5949985855, 1.013863514358674E9, 5.2437102621676495E11, 2.0816612213076075E14, 6.092061398917522E16, 1.185770712190321E19, 1.1623987080032122E21};
        double d2 = Math.signum(d);
        if (d < 0.0) {
            d = -d;
        }
        if (d > 8.0) {
            dArray = Bessel.besselasympt1(d);
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = d - 2.356194490192345;
            double d6 = Math.sqrt(0.6366197723675814 / d) * (d3 * Math.cos(d5) - d4 * Math.sin(d5));
            if (d2 < 0.0) {
                d6 = -d6;
            }
            return d6;
        }
        double d7 = d * d;
        double d8 = dArray2[0];
        int n = 1;
        while (n < 9) {
            d8 = dArray2[n] + d8 * d7;
            ++n;
        }
        double d9 = dArray3[0];
        n = 1;
        while (n < 9) {
            d9 = dArray3[n] + d9 * d7;
            ++n;
        }
        return d2 * d * d8 / d9;
    }

    private static double[] besselasympt0(double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{0.0, 2485.271928957404, 153982.65326239113, 2016135.2830499837, 8413041.45655044, 1.233238476817638E7, 5393485.083869439};
        double[] dArray3 = new double[]{1.0, 2615.7007369208395, 156001.7276940031, 2025066.801570134, 8426449.050629796, 1.233831022786325E7, 5393485.083869439};
        double[] dArray4 = new double[]{0.0, -4.887199395841262, -226.2630641933704, -2365.956170779108, -8239.066313485606, -10381.416987484641, -3984.6173575952225};
        double[] dArray5 = new double[]{1.0, 408.7714673983499, 15704.891915153956, 156021.32066792916, 533291.3634216897, 666745.4239319827, 255015.51088609424};
        double d2 = 64.0 / d / d;
        double d3 = dArray2[0];
        int n = 1;
        while (n < 7) {
            d3 = dArray2[n] + d3 * d2;
            ++n;
        }
        double d4 = dArray3[0];
        n = 1;
        while (n < 7) {
            d4 = dArray3[n] + d4 * d2;
            ++n;
        }
        double d5 = dArray4[0];
        n = 1;
        while (n < 7) {
            d5 = dArray4[n] + d5 * d2;
            ++n;
        }
        double d6 = dArray5[0];
        n = 1;
        while (n < 7) {
            d6 = dArray5[n] + d6 * d2;
            ++n;
        }
        double d7 = d3 / d4;
        double d8 = 8.0 * d5 / d6 / d;
        dArray[0] = d7;
        dArray[1] = d8;
        return dArray;
    }

    private static double[] besselasympt1(double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{-1611.6166443246102, -109824.05543459347, -1523529.3511811374, -6603373.248364939, -9942246.505077641, -4435757.816794128};
        double[] dArray3 = new double[]{1.0, -1455.0094401904962, -107263.8599110382, -1511809.5066341609, -6585339.4797230875, -9934124.389934586, -4435757.816794128};
        double[] dArray4 = new double[]{35.26513384663603, 1706.375429020768, 18494.262873223866, 66178.83658127084, 85145.1606753357, 33220.913409857225};
        double[] dArray5 = new double[]{1.0, 863.8367769604992, 37890.2297457722, 400294.43582266977, 1419460.669603721, 1819458.0422439973, 708712.8194102874};
        double d2 = 64.0 / d / d;
        double d3 = dArray2[0];
        int n = 1;
        while (n < 6) {
            d3 = dArray2[n] + d3 * d2;
            ++n;
        }
        double d4 = dArray3[0];
        n = 1;
        while (n < 7) {
            d4 = dArray3[n] + d4 * d2;
            ++n;
        }
        double d5 = dArray4[0];
        n = 1;
        while (n < 6) {
            d5 = dArray4[n] + d5 * d2;
            ++n;
        }
        double d6 = dArray5[0];
        n = 1;
        while (n < 7) {
            d6 = dArray5[n] + d6 * d2;
            ++n;
        }
        double d7 = d3 / d4;
        double d8 = 8.0 * d5 / d6 / d;
        dArray[0] = d7;
        dArray[1] = d8;
        return dArray;
    }

    static class BesselDerivative
    implements Function {
        int n;

        BesselDerivative(int n) {
            this.n = n;
        }

        public double evaluate(double d) {
            return Bessel.besselnDerivative(this.n, d);
        }
    }

    static class BesselFunction
    implements Function {
        int n;

        BesselFunction(int n) {
            this.n = n;
        }

        public double evaluate(double d) {
            if (this.n == 0) {
                return Bessel.bessel0(d);
            }
            if (this.n == 1) {
                return Bessel.bessel1(d);
            }
            return Bessel.besseln(this.n, d);
        }
    }
}

