/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.numerics.Function;

public class Airy {
    static Function airyFunction = null;
    static Function airyDerivative = null;
    static final double airyZeroTolerance = 1.0E-9;
    static final Map<Integer, Double> zeroMap = new HashMap<Integer, Double>();

    static {
        zeroMap.put(1, -2.338107410459767);
        zeroMap.put(2, -4.087949444130971);
        zeroMap.put(3, -5.520559828095551);
        zeroMap.put(4, -6.786708090071759);
        zeroMap.put(5, -7.944133587120853);
        zeroMap.put(6, -9.02265085334098);
        zeroMap.put(7, -10.04017434155809);
        zeroMap.put(8, -11.00852430373326);
        zeroMap.put(9, -11.93601556323626);
        zeroMap.put(10, -12.82877675286576);
        zeroMap.put(11, -13.69148903521072);
        zeroMap.put(12, -14.52782995177533);
        zeroMap.put(13, -15.340755135978);
        zeroMap.put(14, -16.13268515694577);
        zeroMap.put(15, -16.90563399742994);
        zeroMap.put(16, -17.66130010569706);
    }

    public static double airy(double d) {
        double d2;
        double[] dArray = new double[26];
        dArray[1] = 14.083081072180963;
        dArray[2] = 10.214885479197331;
        dArray[3] = 7.441601845045093;
        dArray[4] = 5.307094306178192;
        dArray[5] = 3.634013502913246;
        dArray[6] = 2.331065230305245;
        dArray[7] = 1.3447970842609267;
        dArray[8] = 0.6418885836956729;
        dArray[9] = 0.20100345998121047;
        dArray[10] = 0.008059435917205284;
        dArray[11] = 3.1542515762964784E-14;
        dArray[12] = 6.639421081958493E-11;
        dArray[13] = 1.7583889061345668E-8;
        dArray[14] = 1.3712392370435816E-6;
        dArray[15] = 4.435096663928435E-5;
        dArray[16] = 7.155501091771825E-4;
        dArray[17] = 0.006488956610333538;
        dArray[18] = 0.036440415875773284;
        dArray[19] = 0.14399792418590998;
        dArray[20] = 0.8123114133626148;
        dArray[21] = 0.355028053887817;
        dArray[22] = 0.258819403792807;
        dArray[23] = 1.7320508075688772;
        dArray[24] = 0.7853981633974483;
        dArray[25] = 0.5641895835477563;
        if (d >= -5.0 && d <= 8.0) {
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 1.0;
            double d6 = 1.0;
            double d7 = 1.0;
            double d8 = 1.0;
            double d9 = 0.5;
            double d10 = 0.5;
            int n = 3;
            double d11 = d * d * d;
            while (Math.abs(d8) + Math.abs(d7) + Math.abs(d10) + Math.abs(d6) > 1.0E-18) {
                d8 = d8 * d11 / (double)(n * (n - 1));
                d7 = d7 * d11 / (double)(n * (n + 1));
                d10 = d10 * d11 / (double)(n * (n + 2));
                d6 = d6 * d11 / (double)(n * (n - 2));
                d5 += d8;
                d4 += d7;
                d9 += d10;
                d3 += d6;
                n += 3;
            }
            if (d < 2.5) {
                double d12 = dArray[21] * d5 - dArray[22] * d * d4;
                return d12;
            }
        }
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = Math.sqrt(Math.abs(d));
        double d18 = 0.666666666666667 * Math.abs(d) * d17;
        double d19 = dArray[25] / Math.sqrt(d17);
        if (d < 0.0) {
            d = -d;
            double d20 = Math.cos(d18 - dArray[24]);
            double d21 = Math.sin(d18 - dArray[24]);
            int n = 1;
            while (n <= 10) {
                double d22 = dArray[n + 10];
                double d23 = dArray[n] / d18;
                double d24 = d23 * d23;
                double d25 = 1.0 + d24;
                double d26 = d25 * d25;
                d16 += d22 / d25;
                d15 += d22 * d23 / d25;
                d14 += d22 * d23 * (1.0 + d23 * (2.0 / d18 + d23)) / d26;
                d13 += d22 * (-1.0 - d23 * (1.0 + d23 * (d18 - d23)) / d18) / d26;
                ++n;
            }
            d2 = d19 * (d20 * d16 + d21 * d15);
        } else {
            double d27 = d < 9.0 ? Math.exp(d18) : 1.0;
            int n = 1;
            while (n <= 10) {
                double d28 = dArray[n + 10];
                double d29 = dArray[n] / d18;
                double d30 = 1.0 + d29;
                double d31 = 1.0 - d29;
                d16 += d28 / d30;
                d15 += d28 * d29 / (d18 * d30 * d30);
                d14 += d28 / d31;
                d13 += d28 * d29 / (d18 * d31 * d31);
                ++n;
            }
            d2 = 0.5 * d19 * d16 / d27;
            if (d >= 9.0) {
                d27 = Math.pow(d, 1.5);
                d2 = 0.5 * Math.exp(-2.0 * d27 / 3.0) / Math.sqrt(Math.PI) / Math.pow(d, 0.25);
            }
        }
        return d2;
    }

    public static double airyDerivative(double d) {
        double d2;
        double[] dArray = new double[26];
        dArray[1] = 14.083081072180963;
        dArray[2] = 10.214885479197331;
        dArray[3] = 7.441601845045093;
        dArray[4] = 5.307094306178192;
        dArray[5] = 3.634013502913246;
        dArray[6] = 2.331065230305245;
        dArray[7] = 1.3447970842609267;
        dArray[8] = 0.6418885836956729;
        dArray[9] = 0.20100345998121047;
        dArray[10] = 0.008059435917205284;
        dArray[11] = 3.1542515762964784E-14;
        dArray[12] = 6.639421081958493E-11;
        dArray[13] = 1.7583889061345668E-8;
        dArray[14] = 1.3712392370435816E-6;
        dArray[15] = 4.435096663928435E-5;
        dArray[16] = 7.155501091771825E-4;
        dArray[17] = 0.006488956610333538;
        dArray[18] = 0.036440415875773284;
        dArray[19] = 0.14399792418590998;
        dArray[20] = 0.8123114133626148;
        dArray[21] = 0.355028053887817;
        dArray[22] = 0.258819403792807;
        dArray[23] = 1.7320508075688772;
        dArray[24] = 0.7853981633974483;
        dArray[25] = 0.5641895835477563;
        if (d >= -5.0 && d <= 8.0) {
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = 1.0;
            double d6 = 1.0;
            double d7 = 1.0;
            double d8 = 1.0;
            double d9 = 0.5;
            double d10 = 0.5;
            int n = 3;
            double d11 = d * d * d;
            while (Math.abs(d8) + Math.abs(d7) + Math.abs(d10) + Math.abs(d6) > 1.0E-18) {
                d8 = d8 * d11 / (double)(n * (n - 1));
                d7 = d7 * d11 / (double)(n * (n + 1));
                d10 = d10 * d11 / (double)(n * (n + 2));
                d6 = d6 * d11 / (double)(n * (n - 2));
                d5 += d8;
                d4 += d7;
                d9 += d10;
                d3 += d6;
                n += 3;
            }
            if (d < 2.5) {
                double d12 = dArray[21] * d5 - dArray[22] * d * d4;
                double d13 = dArray[21] * d9 * d * d - dArray[22] * d3;
                return d13;
            }
        }
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = Math.sqrt(Math.abs(d));
        double d19 = 0.666666666666667 * Math.abs(d) * d18;
        double d20 = dArray[25] / Math.sqrt(d18);
        if (d < 0.0) {
            d = -d;
            double d21 = Math.cos(d19 - dArray[24]);
            double d22 = Math.sin(d19 - dArray[24]);
            int n = 1;
            while (n <= 10) {
                double d23 = dArray[n + 10];
                double d24 = dArray[n] / d19;
                double d25 = d24 * d24;
                double d26 = 1.0 + d25;
                double d27 = d26 * d26;
                d17 += d23 / d26;
                d16 += d23 * d24 / d26;
                d15 += d23 * d24 * (1.0 + d24 * (2.0 / d19 + d24)) / d27;
                d14 += d23 * (-1.0 - d24 * (1.0 + d24 * (d19 - d24)) / d19) / d27;
                ++n;
            }
            double d28 = d20 * (d21 * d17 + d22 * d16);
            d2 = 0.25 * d28 / d - d20 * d18 * (d21 * d15 + d22 * d14);
        } else {
            double d29 = d < 9.0 ? Math.exp(d19) : 1.0;
            int n = 1;
            while (n <= 10) {
                double d30 = dArray[n + 10];
                double d31 = dArray[n] / d19;
                double d32 = 1.0 + d31;
                double d33 = 1.0 - d31;
                d17 += d30 / d32;
                d16 += d30 * d31 / (d19 * d32 * d32);
                d15 += d30 / d33;
                d14 += d30 * d31 / (d19 * d33 * d33);
                ++n;
            }
            double d34 = 0.5 * d20 * d17 / d29;
            d2 = d34 * (-0.25 / d - d18) + 0.5 * d20 * d18 * d16 / d29;
            if (d >= 9.0) {
                d29 = Math.pow(d, 1.5);
                d34 = 0.5 * Math.exp(-2.0 * d29 / 3.0) / Math.sqrt(Math.PI) / Math.pow(d, 0.25);
                d2 = -d34 * Math.pow(d, 0.5) - d34 / d / 4.0;
            }
        }
        return d2;
    }

    public static double airyZero(int n) {
        if (zeroMap.containsKey(n)) {
            return zeroMap.get(n);
        }
        double d = -Math.pow(Math.PI * ((double)n - 0.25) * 3.0 / 2.0, 0.6666666666666666);
        int n2 = 10;
        while (n2 > 0) {
            double d2;
            double d3;
            double d4 = d;
            if (!(Math.abs((d -= (d3 = Airy.airy(d)) / (d2 = Airy.airyDerivative(d))) - d4) > 1.0E-9)) break;
            --n2;
        }
        if (n2 == 0) {
            d = -Math.pow(Math.PI * ((double)n - 0.25) * 3.0 / 2.0, 0.6666666666666666);
        }
        zeroMap.put(n, d);
        return d;
    }

    public static double[] airynZeros(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = Airy.airyZero(n2 + 1);
            ++n2;
        }
        return dArray;
    }

    public static synchronized Function getFunction() {
        if (airyFunction == null) {
            airyFunction = new AiryFunction();
        }
        return airyFunction;
    }

    public static synchronized Function getDerivative() {
        if (airyDerivative == null) {
            airyDerivative = new AiryDerivative();
        }
        return airyDerivative;
    }

    static class AiryDerivative
    implements Function {
        AiryDerivative() {
        }

        public double evaluate(double d) {
            return Airy.airyDerivative(d);
        }
    }

    static class AiryFunction
    implements Function {
        AiryFunction() {
        }

        public double evaluate(double d) {
            return Airy.airy(d);
        }
    }
}

