/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk.irk;

import org.opensourcephysics.numerics.rk.irk.IRKLinearAlgebra;
import org.opensourcephysics.numerics.rk.irk.LAEquation;

public class LAESolverLU {
    private LAEquation eqn;
    private IRKLinearAlgebra linalg = new IRKLinearAlgebra();
    private int numEqn;
    double[][] luDecomposition;
    double[] rightHandVector;
    int[] stuff;

    public LAEquation getEquation() {
        return this.eqn;
    }

    public LAESolverLU(int n) {
        this.numEqn = n;
        this.luDecomposition = new double[n][n];
        this.rightHandVector = new double[n];
        this.stuff = new int[n];
    }

    public LAESolverLU(LAEquation lAEquation) {
        this.assignEquation(lAEquation);
        this.numEqn = lAEquation.getDimension();
        this.luDecomposition = new double[this.numEqn][this.numEqn];
        this.rightHandVector = new double[this.numEqn];
        this.stuff = new int[this.numEqn];
    }

    public void assignEquation(LAEquation lAEquation) {
        if (lAEquation.getDimension() == this.numEqn) {
            this.eqn = lAEquation;
        } else {
            System.err.println("Equation hasn't been added because dimension");
        }
    }

    public void initialize() {
        this.eqn.getMatrix(this.luDecomposition);
        this.linalg.dec(this.numEqn, this.numEqn, this.luDecomposition, this.stuff);
    }

    public void resolve(double[] dArray) {
        if (this.luDecomposition != null) {
            this.eqn.getVector(this.rightHandVector);
            this.linalg.sol(this.numEqn, this.numEqn, this.luDecomposition, this.rightHandVector, this.stuff);
            System.arraycopy(this.rightHandVector, 0, dArray, 0, this.numEqn);
        }
    }
}

