/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractAdaptiveRKSolverInterpolator;

public class Fehlberg78
extends AbstractAdaptiveRKSolverInterpolator {
    static final double A_11 = 0.07407407407407407;
    static final double A_21 = 0.027777777777777776;
    static final double A_22 = 0.08333333333333333;
    static final double A_31 = 0.041666666666666664;
    static final double A_33 = 0.125;
    static final double A_41 = 0.4166666666666667;
    static final double A_43 = -1.5625;
    static final double A_44 = 1.5625;
    static final double A_51 = 0.05;
    static final double A_54 = 0.25;
    static final double A_55 = 0.2;
    static final double A_61 = -0.23148148148148148;
    static final double A_64 = 1.1574074074074074;
    static final double A_65 = -2.4074074074074074;
    static final double A_66 = 2.314814814814815;
    static final double A_71 = 0.10333333333333333;
    static final double A_75 = 0.27111111111111114;
    static final double A_76 = -0.2222222222222222;
    static final double A_77 = 0.014444444444444444;
    static final double A_81 = 2.0;
    static final double A_84 = -8.833333333333334;
    static final double A_85 = 15.644444444444444;
    static final double A_86 = -11.88888888888889;
    static final double A_87 = 0.7444444444444445;
    static final double A_88 = 3.0;
    static final double A_91 = -0.8425925925925926;
    static final double A_94 = 0.21296296296296297;
    static final double A_95 = -7.229629629629629;
    static final double A_96 = 5.7592592592592595;
    static final double A_97 = -0.31666666666666665;
    static final double A_98 = 2.8333333333333335;
    static final double A_99 = -0.08333333333333333;
    static final double A_101 = 0.5812195121951219;
    static final double A_104 = -2.0792682926829267;
    static final double A_105 = 4.3863414634146345;
    static final double A_106 = -3.6707317073170733;
    static final double A_107 = 0.5202439024390244;
    static final double A_108 = 0.5487804878048781;
    static final double A_109 = 0.27439024390243905;
    static final double A_1010 = 0.43902439024390244;
    static final double A_111 = 0.014634146341463415;
    static final double A_116 = -0.14634146341463414;
    static final double A_117 = -0.014634146341463415;
    static final double A_118 = -0.07317073170731707;
    static final double A_119 = 0.07317073170731707;
    static final double A_1110 = 0.14634146341463414;
    static final double A_121 = -0.43341463414634146;
    static final double A_124 = -2.0792682926829267;
    static final double A_125 = 4.3863414634146345;
    static final double A_126 = -3.524390243902439;
    static final double A_127 = 0.5348780487804878;
    static final double A_128 = 0.6219512195121951;
    static final double A_129 = 0.20121951219512196;
    static final double A_1210 = 0.2926829268292683;
    static final double A_1212 = 1.0;
    private static final double B7_1 = 0.04880952380952381;
    private static final double B7_6 = 0.3238095238095238;
    private static final double B7_7 = 0.2571428571428571;
    private static final double B7_8 = 0.2571428571428571;
    private static final double B7_9 = 0.03214285714285714;
    private static final double B7_10 = 0.03214285714285714;
    private static final double B7_11 = 0.04880952380952381;
    static final double B8_6 = 0.3238095238095238;
    static final double B8_7 = 0.2571428571428571;
    static final double B8_8 = 0.2571428571428571;
    static final double B8_9 = 0.03214285714285714;
    static final double B8_10 = 0.03214285714285714;
    static final double B8_12 = 0.04880952380952381;
    static final double B8_13 = 0.04880952380952381;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] rate7;
    private double[] rate8;
    private double[] rate9;
    private double[] rate10;
    private double[] rate11;
    private double[] rate12;
    private double[] rate13;
    private double[] order8;

    public Fehlberg78(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
        this.rate5 = new double[this.dimension];
        this.rate6 = new double[this.dimension];
        this.rate7 = new double[this.dimension];
        this.rate8 = new double[this.dimension];
        this.rate9 = new double[this.dimension];
        this.rate10 = new double[this.dimension];
        this.rate11 = new double[this.dimension];
        this.rate12 = new double[this.dimension];
        this.rate13 = new double[this.dimension];
        this.order8 = new double[this.dimension];
    }

    protected double getMethodOrder() {
        return 7.0;
    }

    protected int getNumberOfEvaluations() {
        return 13;
    }

    protected double computeApproximations(double d) {
        this.computeIntermediateStep(d, this.finalState);
        int n = 0;
        while (n < this.dimension) {
            this.order8[n] = this.initialState[n] + d * (0.3238095238095238 * this.rate6[n] + 0.2571428571428571 * this.rate7[n] + 0.2571428571428571 * this.rate8[n] + 0.03214285714285714 * this.rate9[n] + 0.03214285714285714 * this.rate10[n] + 0.04880952380952381 * this.rate12[n] + 0.04880952380952381 * this.rate13[n]);
            ++n;
        }
        return super.computeError(this.order8);
    }

    protected void computeFinalRate() {
        this.ode.getRate(this.finalState, this.finalRate);
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * 0.07407407407407407 * this.initialRate[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.027777777777777776 * this.initialRate[n] + 0.08333333333333333 * this.rate2[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.041666666666666664 * this.initialRate[n] + 0.125 * this.rate3[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate4);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.4166666666666667 * this.initialRate[n] + -1.5625 * this.rate3[n] + 1.5625 * this.rate4[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate5);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.05 * this.initialRate[n] + 0.25 * this.rate4[n] + 0.2 * this.rate5[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate6);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.23148148148148148 * this.initialRate[n] + 1.1574074074074074 * this.rate4[n] + -2.4074074074074074 * this.rate5[n] + 2.314814814814815 * this.rate6[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate7);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.10333333333333333 * this.initialRate[n] + 0.27111111111111114 * this.rate5[n] + -0.2222222222222222 * this.rate6[n] + 0.014444444444444444 * this.rate7[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate8);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (2.0 * this.initialRate[n] + -8.833333333333334 * this.rate4[n] + 15.644444444444444 * this.rate5[n] + -11.88888888888889 * this.rate6[n] + 0.7444444444444445 * this.rate7[n] + 3.0 * this.rate8[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate9);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.8425925925925926 * this.initialRate[n] + 0.21296296296296297 * this.rate4[n] + -7.229629629629629 * this.rate5[n] + 5.7592592592592595 * this.rate6[n] + -0.31666666666666665 * this.rate7[n] + 2.8333333333333335 * this.rate8[n] + -0.08333333333333333 * this.rate9[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate10);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.5812195121951219 * this.initialRate[n] + -2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] + -3.6707317073170733 * this.rate6[n] + 0.5202439024390244 * this.rate7[n] + 0.5487804878048781 * this.rate8[n] + 0.27439024390243905 * this.rate9[n] + 0.43902439024390244 * this.rate10[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate11);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.014634146341463415 * this.initialRate[n] + -0.14634146341463414 * this.rate6[n] + -0.014634146341463415 * this.rate7[n] + -0.07317073170731707 * this.rate8[n] + 0.07317073170731707 * this.rate9[n] + 0.14634146341463414 * this.rate10[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate12);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.43341463414634146 * this.initialRate[n] + -2.0792682926829267 * this.rate4[n] + 4.3863414634146345 * this.rate5[n] + -3.524390243902439 * this.rate6[n] + 0.5348780487804878 * this.rate7[n] + 0.6219512195121951 * this.rate8[n] + 0.20121951219512196 * this.rate9[n] + 0.2926829268292683 * this.rate10[n] + 1.0 * this.rate12[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate13);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.04880952380952381 * this.initialRate[n] + 0.3238095238095238 * this.rate6[n] + 0.2571428571428571 * this.rate7[n] + 0.2571428571428571 * this.rate8[n] + 0.03214285714285714 * this.rate9[n] + 0.03214285714285714 * this.rate10[n] + 0.04880952380952381 * this.rate11[n]);
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, double[] dArray) {
        return super.interpolateBootstrap2(d, dArray);
    }
}

