/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractAdaptiveRKSolverInterpolator;

public class CashKarp45
extends AbstractAdaptiveRKSolverInterpolator {
    private static final double A_11 = 0.2;
    private static final double A_21 = 0.075;
    private static final double A_22 = 0.225;
    private static final double A_31 = 0.3;
    private static final double A_32 = -0.9;
    private static final double A_33 = 1.2;
    private static final double A_41 = -0.2037037037037037;
    private static final double A_42 = 2.5;
    private static final double A_43 = -2.5925925925925926;
    private static final double A_44 = 1.2962962962962963;
    private static final double A_51 = 0.029495804398148147;
    private static final double A_52 = 0.341796875;
    private static final double A_53 = 0.041594328703703706;
    private static final double A_54 = 0.40034541377314814;
    private static final double A_55 = 0.061767578125;
    private static final double B4_1 = 0.10217737268518519;
    private static final double B4_2 = 0.0;
    private static final double B4_3 = 0.38390790343915343;
    private static final double B4_4 = 0.24459273726851852;
    private static final double B4_5 = 0.019321986607142856;
    private static final double B4_6 = 0.25;
    private static final double B5_1 = 0.09788359788359788;
    private static final double B5_2 = 0.0;
    private static final double B5_3 = 0.4025764895330113;
    private static final double B5_4 = 0.21043771043771045;
    private static final double B5_5 = 0.0;
    private static final double B5_6 = 0.2891022021456804;
    private double[] rate2;
    private double[] rate3;
    private double[] rate4;
    private double[] rate5;
    private double[] rate6;
    private double[] order4;

    public CashKarp45(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.rate4 = new double[this.dimension];
        this.rate5 = new double[this.dimension];
        this.rate6 = new double[this.dimension];
        this.order4 = new double[this.dimension];
    }

    protected double getMethodOrder() {
        return 5.0;
    }

    protected int getNumberOfEvaluations() {
        return 6;
    }

    protected void computeFinalRate() {
        this.ode.getRate(this.finalState, this.finalRate);
    }

    protected double computeApproximations(double d) {
        this.computeIntermediateStep(d, this.finalState);
        int n = 0;
        while (n < this.dimension) {
            this.order4[n] = this.initialState[n] + d * (0.10217737268518519 * this.initialRate[n] + 0.0 * this.rate2[n] + 0.38390790343915343 * this.rate3[n] + 0.24459273726851852 * this.rate4[n] + 0.019321986607142856 * this.rate5[n] + 0.25 * this.rate6[n]);
            ++n;
        }
        return super.computeError(this.order4);
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * 0.2 * this.initialRate[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.075 * this.initialRate[n] + 0.225 * this.rate2[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.3 * this.initialRate[n] + -0.9 * this.rate2[n] + 1.2 * this.rate3[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate4);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (-0.2037037037037037 * this.initialRate[n] + 2.5 * this.rate2[n] + -2.5925925925925926 * this.rate3[n] + 1.2962962962962963 * this.rate4[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate5);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.029495804398148147 * this.initialRate[n] + 0.341796875 * this.rate2[n] + 0.041594328703703706 * this.rate3[n] + 0.40034541377314814 * this.rate4[n] + 0.061767578125 * this.rate5[n]);
            ++n;
        }
        this.ode.getRate(dArray, this.rate6);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.09788359788359788 * this.initialRate[n] + 0.0 * this.rate2[n] + 0.4025764895330113 * this.rate3[n] + 0.21043771043771045 * this.rate4[n] + 0.0 * this.rate5[n] + 0.2891022021456804 * this.rate6[n]);
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, double[] dArray) {
        return super.interpolateBootstrap2(d, dArray);
    }
}

