/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.rk;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.rk.AbstractAdaptiveRKSolverInterpolator;

public class BogackiShampine23
extends AbstractAdaptiveRKSolverInterpolator {
    private static final double B3_1 = 0.2222222222222222;
    private static final double B3_2 = 0.3333333333333333;
    private static final double B3_3 = 0.4444444444444444;
    private static final double B2_1 = 0.2916666666666667;
    private static final double B2_2 = 0.25;
    private static final double B2_3 = 0.3333333333333333;
    private static final double B2_4 = 0.125;
    private double[] rate2;
    private double[] rate3;
    private double[] order2;

    public BogackiShampine23(ODE oDE) {
        this.ode = oDE;
    }

    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.rate2 = new double[this.dimension];
        this.rate3 = new double[this.dimension];
        this.order2 = new double[this.dimension];
    }

    protected double getMethodOrder() {
        return 3.0;
    }

    protected int getNumberOfEvaluations() {
        return 3;
    }

    protected double computeApproximations(double d) {
        this.computeIntermediateStep(d, this.finalState);
        this.ode.getRate(this.finalState, this.finalRate);
        int n = 0;
        while (n < this.dimension) {
            this.order2[n] = this.initialState[n] + d * (0.2916666666666667 * this.initialRate[n] + 0.25 * this.rate2[n] + 0.3333333333333333 * this.rate3[n] + 0.125 * this.finalRate[n]);
            ++n;
        }
        return super.computeError(this.order2);
    }

    protected void computeFinalRate() {
    }

    protected double[] computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * this.initialRate[n] / 2.0;
            ++n;
        }
        this.ode.getRate(dArray, this.rate2);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + 0.75 * d * this.rate2[n];
            ++n;
        }
        this.ode.getRate(dArray, this.rate3);
        n = 0;
        while (n < this.dimension) {
            dArray[n] = this.initialState[n] + d * (0.2222222222222222 * this.initialRate[n] + 0.3333333333333333 * this.rate2[n] + 0.4444444444444444 * this.rate3[n]);
            ++n;
        }
        return dArray;
    }

    public double[] interpolate(double d, double[] dArray) {
        return this.interpolateHermite(d, dArray);
    }
}

