/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.qss;

import java.util.ArrayList;
import org.opensourcephysics.numerics.ODE;

public class MultirateUtils {
    public static int[][] getIncidenceMatrix(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = n - 1;
        int[][] nArrayArray = new int[n][];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (blArray[n3][n5]) {
                    ++n4;
                }
                ++n5;
            }
            nArrayArray[n3] = new int[n4];
            n4 = 0;
            n5 = 0;
            while (n5 < n) {
                if (blArray[n3][n5]) {
                    nArrayArray[n3][n4++] = n5;
                }
                ++n5;
            }
            ++n3;
        }
        nArrayArray[n2] = new int[0];
        return nArrayArray;
    }

    public static int[][] estimateIncidenceMatrix(ODE oDE, double[] dArray) {
        int n;
        int n2 = oDE.getState().length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        int[][] nArray = new int[n2 - 1][n2 - 1];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2 - 1) {
            nArray2[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2 - 1) {
            System.arraycopy(dArray, 0, dArray4, 0, n2);
            dArray5[n3] = 1.0E-5 * dArray4[n3] + 1.0E-10;
            dArray4[n3] = dArray4[n3] + dArray5[n3];
            oDE.getRate(dArray, dArray2);
            oDE.getRate(dArray4, dArray3);
            n = 0;
            while (n < n2 - 1) {
                if ((dArray3[n] - dArray2[n]) / dArray5[n3] != 0.0) {
                    nArray[n][nArray2[n]] = n3;
                    int n4 = n;
                    nArray2[n4] = nArray2[n4] + 1;
                }
                ++n;
            }
            ++n3;
        }
        int[][] nArrayArray = new int[n2][];
        n = 0;
        while (n < n2 - 1) {
            int[] nArray3 = new int[nArray2[n]];
            System.arraycopy(nArray[n], 0, nArray3, 0, nArray2[n]);
            nArrayArray[n] = new int[nArray2[n]];
            int n5 = 0;
            while (n5 < nArray2[n]) {
                nArrayArray[n][n5] = nArray3[n5];
                ++n5;
            }
            ++n;
        }
        nArrayArray[n2 - 1] = new int[0];
        return nArrayArray;
    }

    public static double[][] getJacobian(ODE oDE, double[] dArray) {
        int n = oDE.getState().length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[][] dArray4 = new double[n - 1][n - 1];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        int n2 = 0;
        while (n2 < n - 1) {
            System.arraycopy(dArray, 0, dArray5, 0, n);
            dArray6[n2] = 1.0E-5 * dArray5[n2] + 1.0E-10;
            dArray5[n2] = dArray5[n2] + dArray6[n2];
            oDE.getRate(dArray, dArray2);
            oDE.getRate(dArray5, dArray3);
            int n3 = 0;
            while (n3 < n - 1) {
                dArray4[n3][n2] = (dArray3[n3] - dArray2[n3]) / dArray6[n2];
                ++n3;
            }
            ++n2;
        }
        return dArray4;
    }

    public static int[][] getReciprocalMatrix(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        int n = 0;
        while (n < nArray.length) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = nArray[n2];
                int n3 = 0;
                while (n3 < nArray2.length) {
                    if (nArray2[n3] == n) {
                        arrayList.add(n2);
                    }
                    ++n3;
                }
                ++n2;
            }
            n2 = arrayList.size();
            nArrayArray[n] = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                nArrayArray[n][n4] = (Integer)arrayList.get(n4);
                ++n4;
            }
            ++n;
        }
        return nArrayArray;
    }

    public static void printMatrix(int[][] nArray) {
        System.out.println("{");
        int n = 0;
        while (n < nArray.length) {
            int[] nArray2 = nArray[n];
            System.out.print("  { ");
            int n2 = 0;
            while (n2 < nArray2.length) {
                if (n2 == 0) {
                    System.out.print(nArray2[n2]);
                } else {
                    System.out.print(", " + nArray2[n2]);
                }
                ++n2;
            }
            System.out.println(" }");
            ++n;
        }
        System.out.println("}");
    }
}

