/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.io.Serializable;
import org.opensourcephysics.numerics.Complex;
import org.opensourcephysics.numerics.ComplexMatrix;

public class ComplexEigenvalueDecomposition
implements Serializable {
    public static void eigen(Complex[][] complexArray, Complex[] complexArray2, Complex[][] complexArray3, boolean[] blArray) {
        if (complexArray == null || complexArray2 == null || complexArray3 == null) {
            System.out.println("Error in Eigen.eigen, null or inconsistent array sizes.");
            return;
        }
        int n = complexArray.length;
        if (complexArray[0].length != n || complexArray3.length != n || complexArray3[0].length != n || complexArray2.length != n) {
            System.out.println("Error in Eigen.eigen, inconsistent array sizes.");
            return;
        }
        blArray[0] = false;
        if (n < 1) {
            System.out.println("zero size matrix");
            return;
        }
        int[] nArray = new int[n];
        Complex[][] complexArray4 = new Complex[n][n];
        ComplexMatrix.copy(complexArray, complexArray4);
        if (n == 1) {
            complexArray2[0] = complexArray4[0][0];
            complexArray3[0][0] = new Complex(1.0, 0.0);
            return;
        }
        if (n == 2) {
            ComplexEigenvalueDecomposition.twobytwo(complexArray4, complexArray2, complexArray3);
            return;
        }
        ComplexEigenvalueDecomposition.cxhess(complexArray4, nArray);
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = new Complex(-999.0, -999.0);
            ++n2;
        }
        ComplexEigenvalueDecomposition.cxeig2c(complexArray4, complexArray2, complexArray3, nArray, blArray);
    }

    private static void twobytwo(Complex[][] complexArray, Complex[] complexArray2, Complex[][] complexArray3) {
        Complex[] complexArray4 = new Complex[2];
        Complex complex = complexArray[0][0].add(complexArray[1][1]);
        Complex complex2 = complexArray[0][0].mul(complexArray[1][1]);
        complex2 = complex2.subtract(complexArray[0][1].mul(complexArray[1][0]));
        Complex complex3 = complex.mul(complex).subtract(complex2.mul(4.0));
        complex3 = complex3.sqrt();
        Complex complex4 = complex.add(complex3).div(2.0);
        Complex complex5 = complex.subtract(complex3).div(2.0);
        complexArray2[0] = complex4;
        complexArray2[1] = complex5;
        complexArray4[0] = complexArray[0][1].neg();
        complexArray4[1] = complexArray[0][0].subtract(complex4);
        double d = ComplexMatrix.norm2(complexArray4);
        complexArray3[0][0] = complexArray4[0].div(d);
        complexArray3[1][0] = complexArray4[1].div(d);
        complexArray4[0] = complexArray[1][1].subtract(complex5);
        complexArray4[1] = complexArray[1][0].neg();
        d = ComplexMatrix.norm2(complexArray4);
        complexArray3[0][1] = complexArray4[0].div(d);
        complexArray3[1][1] = complexArray4[1].div(d);
    }

    private static double sumabs(Complex complex) {
        return Math.abs(complex.re()) + Math.abs(complex.im());
    }

    private static void cxhess(Complex[][] complexArray, int[] nArray) {
        int n = complexArray.length;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        int n3 = 0;
        n2 = n3 + 1;
        while (n2 < n - 1) {
            Complex complex;
            int n4 = n2;
            Complex complex2 = new Complex(0.0, 0.0);
            int n5 = n2;
            while (n5 < n) {
                if (ComplexEigenvalueDecomposition.sumabs(complexArray[n5][n2 - 1]) > ComplexEigenvalueDecomposition.sumabs(complex2)) {
                    complex2 = complexArray[n5][n2 - 1];
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n2) {
                int n6 = nArray[n2];
                nArray[n2] = nArray[n4];
                nArray[n4] = n6;
                n5 = n2 - 1;
                while (n5 < n) {
                    complex = complexArray[n4][n5];
                    complexArray[n4][n5] = complexArray[n2][n5];
                    complexArray[n2][n5] = complex;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n) {
                    complex = complexArray[n5][n4];
                    complexArray[n5][n4] = complexArray[n5][n2];
                    complexArray[n5][n2] = complex;
                    ++n5;
                }
            }
            if (ComplexEigenvalueDecomposition.sumabs(complex2) != 0.0) {
                n5 = n2 + 1;
                while (n5 < n) {
                    complex = complexArray[n5][n2 - 1];
                    if (ComplexEigenvalueDecomposition.sumabs(complex) > 0.0) {
                        complexArray[n5][n2 - 1] = complex = complex.div(complex2);
                        int n7 = n2;
                        while (n7 < n) {
                            complexArray[n5][n7] = complexArray[n5][n7].subtract(complex.mul(complexArray[n2][n7]));
                            ++n7;
                        }
                        n7 = 0;
                        while (n7 < n) {
                            complexArray[n7][n2] = complexArray[n7][n2].add(complex.mul(complexArray[n7][n5]));
                            ++n7;
                        }
                    }
                    complexArray[n5][n2 - 1] = new Complex(0.0, 0.0);
                    ++n5;
                }
            }
            ++n2;
        }
    }

    private static void cxeig2c(Complex[][] complexArray, Complex[] complexArray2, Complex[][] complexArray3, int[] nArray, boolean[] blArray) {
        int n;
        Complex complex;
        Complex complex2;
        Complex complex3;
        int n2;
        int n3;
        double d = 0.0;
        int n4 = complexArray.length;
        int n5 = 0;
        double d2 = Math.pow(2.0, -23.0);
        Complex complex4 = new Complex(0.0, 0.0);
        int n6 = 30 * n4;
        ComplexMatrix.identity(complexArray3);
        int n7 = n4 - 2;
        while (n7 > 0) {
            n3 = nArray[n7];
            n2 = n7 + 1;
            while (n2 < n4) {
                complexArray3[n2][n7] = complexArray[n2][n7 - 1];
                ++n2;
            }
            if (n7 != n3) {
                n2 = n7;
                while (n2 < n4) {
                    complexArray3[n7][n2] = complexArray3[n3][n2];
                    complexArray3[n3][n2] = new Complex(0.0, 0.0);
                    ++n2;
                }
                complexArray3[n3][n7] = new Complex(1.0, 0.0);
            }
            --n7;
        }
        int n8 = n4 - 1;
        while (n5 <= n8) {
            int n9 = 0;
            block4: while (true) {
                Complex complex5;
                n2 = n5;
                n7 = n8;
                while (n7 > n5) {
                    double d3;
                    double d4 = ComplexEigenvalueDecomposition.sumabs(complexArray[n7][n7 - 1]);
                    if (d4 <= (d3 = d2 * (ComplexEigenvalueDecomposition.sumabs(complexArray[n7 - 1][n7 - 1]) + ComplexEigenvalueDecomposition.sumabs(complexArray[n7][n7])))) {
                        n2 = n7;
                        break;
                    }
                    --n7;
                }
                if (n2 == n8) break;
                if (n6 <= 0) {
                    blArray[0] = true;
                    return;
                }
                if (n9 == 10 || n9 == 20) {
                    complex5 = new Complex(Math.abs(complexArray[n8][n8 - 1].re()) + Math.abs(complexArray[n8 - 1][n8 - 2].re()), Math.abs(complexArray[n8][n8 - 1].im()) + Math.abs(complexArray[n8 - 1][n8 - 2].im()));
                } else {
                    complex5 = complexArray[n8][n8];
                    complex3 = complexArray[n8 - 1][n8].mul(complexArray[n8][n8 - 1]);
                    if (ComplexEigenvalueDecomposition.sumabs(complex3) > 0.0) {
                        complex2 = complexArray[n8 - 1][n8 - 1].subtract(complex5).div(new Complex(2.0, 0.0));
                        complex = complex2.mul(complex2).add(complex3).sqrt();
                        if (complex2.re() * complex.re() + complex2.im() * complex.im() < 0.0) {
                            complex = complex.neg();
                        }
                        Complex complex6 = complex2.add(complex);
                        complex5 = complex5.subtract(complex3.div(complex6));
                    }
                }
                n7 = n5;
                while (n7 <= n8) {
                    complexArray[n7][n7] = complexArray[n7][n7].subtract(complex5);
                    ++n7;
                }
                complex4 = complex4.add(complex5);
                ++n9;
                --n6;
                n3 = n2 + 1;
                double d5 = ComplexEigenvalueDecomposition.sumabs(complexArray[n8 - 1][n8 - 1]);
                double d6 = ComplexEigenvalueDecomposition.sumabs(complexArray[n8][n8 - 1]);
                double d7 = ComplexEigenvalueDecomposition.sumabs(complexArray[n8][n8]);
                int n10 = n2;
                int n11 = n8 - 1;
                while (n11 >= n3) {
                    double d8 = d6;
                    d6 = ComplexEigenvalueDecomposition.sumabs(complexArray[n11][n11 - 1]);
                    double d9 = d7;
                    d7 = d5;
                    if (d6 <= d2 * d7 / d8 * (d7 + (d5 = ComplexEigenvalueDecomposition.sumabs(complexArray[n11 - 1][n11 - 1])) + d9)) {
                        n10 = n11;
                        break;
                    }
                    --n11;
                }
                n7 = n10 + 1;
                while (n7 <= n8) {
                    complex3 = complexArray[n7 - 1][n7 - 1];
                    complex2 = complexArray[n7][n7 - 1];
                    if (ComplexEigenvalueDecomposition.sumabs(complex3) >= ComplexEigenvalueDecomposition.sumabs(complex2)) {
                        complex = complex2.div(complex3);
                        complexArray2[n7] = new Complex(-1.0, 0.0);
                    } else {
                        n = n7 - 1;
                        while (n < n4) {
                            complex = complexArray[n7 - 1][n];
                            complexArray[n7 - 1][n] = complexArray[n7][n];
                            complexArray[n7][n] = complex;
                            ++n;
                        }
                        complex = complex3.div(complex2);
                        complexArray2[n7] = new Complex(1.0, 0.0);
                    }
                    complexArray[n7][n7 - 1] = complex;
                    n = n7;
                    while (n < n4) {
                        complexArray[n7][n] = complexArray[n7][n].subtract(complex.mul(complexArray[n7 - 1][n]));
                        ++n;
                    }
                    ++n7;
                }
                n7 = n10 + 1;
                while (true) {
                    if (n7 > n8) continue block4;
                    complex3 = complexArray[n7][n7 - 1];
                    complexArray[n7][n7 - 1] = new Complex(0.0, 0.0);
                    if (complexArray2[n7].re() > 0.0) {
                        n = n5;
                        while (n <= n7) {
                            complex = complexArray[n][n7 - 1];
                            complexArray[n][n7 - 1] = complexArray[n][n7];
                            complexArray[n][n7] = complex;
                            ++n;
                        }
                        n = n5;
                        while (n < n4) {
                            complex = complexArray3[n][n7 - 1];
                            complexArray3[n][n7 - 1] = complexArray3[n][n7];
                            complexArray3[n][n7] = complex;
                            ++n;
                        }
                    }
                    n = n5;
                    while (n <= n7) {
                        complexArray[n][n7 - 1] = complexArray[n][n7 - 1].add(complex3.mul(complexArray[n][n7]));
                        ++n;
                    }
                    n = n5;
                    while (n < n4) {
                        complexArray3[n][n7 - 1] = complexArray3[n][n7 - 1].add(complex3.mul(complexArray3[n][n7]));
                        ++n;
                    }
                    ++n7;
                }
                break;
            }
            complexArray2[n8] = complexArray[n8][n8].add(complex4);
            --n8;
        }
        n7 = 0;
        while (n7 < n4) {
            d += ComplexEigenvalueDecomposition.sumabs(complexArray2[n7]);
            n = n7 + 1;
            while (n < n4) {
                d += ComplexEigenvalueDecomposition.sumabs(complexArray[n7][n]);
                ++n;
            }
            ++n7;
        }
        Complex complex7 = new Complex(d * Math.pow(2.0, -23.0), 0.0);
        if (d == 0.0 || n4 < 2) {
            return;
        }
        n8 = n4 - 1;
        while (n8 > n5) {
            complex3 = complexArray2[n8];
            n7 = n8 - 1;
            while (n7 >= n5) {
                complex = complexArray[n7][n8];
                n = n7 + 1;
                while (n < n8) {
                    complex = complex.add(complexArray[n7][n].mul(complexArray[n][n8]));
                    ++n;
                }
                complex2 = complex3.subtract(complexArray2[n7]);
                if (ComplexEigenvalueDecomposition.sumabs(complex2) == 0.0) {
                    complex2 = complex7;
                }
                complexArray[n7][n8] = complex.div(complex2);
                --n7;
            }
            --n8;
        }
        n7 = n4 - 1;
        while (n7 >= 0) {
            n = 0;
            while (n < n4) {
                complex = complexArray3[n][n7];
                n2 = 0;
                while (n2 < n7) {
                    complex = complex.add(complexArray3[n][n2].mul(complexArray[n2][n7]));
                    ++n2;
                }
                complexArray3[n][n7] = complex;
                ++n;
            }
            --n7;
        }
    }
}

