/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoClip;

public class ClipInspector
extends JDialog {
    protected VideoClip clip;
    protected ClipControl clipControl;
    protected JPanel dataPanel;
    protected JLabel startLabel;
    protected JLabel stepSizeLabel;
    protected JLabel t0Label;
    protected JLabel endLabel;
    protected JLabel dtLabel;
    protected JLabel fpsLabel;
    protected IntegerField startField;
    protected IntegerField stepSizeField;
    protected NumberField t0Field;
    protected IntegerField endField;
    protected NumberField dtField;
    protected NumberField fpsField;
    protected JButton okButton;
    protected JButton cancelButton;
    protected int prevFrame;
    protected int prevStart;
    protected int prevEnd;
    protected int prevSize;
    protected int prevCount;
    protected double prevDt;
    protected double prevRate;
    protected double prevStartTime;

    public ClipInspector(VideoClip videoClip, ClipControl clipControl, Frame frame) {
        super(frame, false);
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.setResizable(false);
        this.clip = videoClip;
        this.clipControl = clipControl;
        this.createGUI();
        this.initialize();
        this.pack();
    }

    public void setStartFrameEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.startField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setStepSizeEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.stepSizeField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setStepCountEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.endField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initialize() {
        this.updateDisplay();
        this.prevStart = this.clip.getStartFrameNumber();
        this.prevEnd = this.clip.getEndFrameNumber();
        this.prevSize = this.clip.getStepSize();
        this.prevCount = this.clip.getStepCount();
        this.prevStartTime = this.clip.getStartTime();
        this.prevDt = this.clipControl.getMeanFrameDuration();
        this.prevRate = this.clipControl.getRate();
        this.prevFrame = this.clipControl.getFrameNumber();
    }

    public void refresh() {
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.startLabel.setText(MediaRes.getString("ClipInspector.Label.StartFrame"));
        this.stepSizeLabel.setText(MediaRes.getString("ClipInspector.Label.StepSize"));
        this.t0Label.setText(MediaRes.getString("ClipInspector.Label.StartTime"));
        this.endLabel.setText(MediaRes.getString("ClipInspector.Label.EndFrame"));
        this.cancelButton.setText(MediaRes.getString("Dialog.Button.Cancel"));
        this.okButton.setText(MediaRes.getString("Dialog.Button.OK"));
        this.dtLabel.setText(MediaRes.getString("ClipInspector.Label.FrameDT"));
        this.fpsLabel.setText(MediaRes.getString("ClipInspector.Label.FPS"));
        this.pack();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        this.startLabel = new JLabel(MediaRes.getString("ClipInspector.Label.StartFrame"));
        this.startLabel.setAlignmentX(1.0f);
        this.startLabel.setForeground(new Color(0, 0, 102));
        this.startLabel.setFont(new Font("Dialog", 0, 12));
        this.startField = new IntegerField(5);
        this.startField.setMaximumSize(this.startField.getPreferredSize());
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClipInspector.this.clip.getStartFrameNumber();
                ClipInspector.this.clip.setStartFrameNumber(ClipInspector.this.startField.getIntValue(), ClipInspector.this.prevEnd);
                int n2 = ClipInspector.this.clip.getStartFrameNumber();
                if (!ClipInspector.this.clip.isDefaultStartTime) {
                    double d = ClipInspector.this.clip.getStartTime();
                    ClipInspector.this.clip.setStartTime(d += (double)(n2 - n) * ClipInspector.this.clipControl.getMeanFrameDuration());
                }
                ClipInspector.this.clip.trimFrameCount();
                ClipInspector.this.updateDisplay();
                ClipInspector.this.startField.selectAll();
                ClipInspector.this.clipControl.setStepNumber(0);
            }
        };
        this.startField.addActionListener(actionListener);
        this.startField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.startField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                actionListener.actionPerformed(null);
            }
        });
        this.stepSizeLabel = new JLabel(MediaRes.getString("ClipInspector.Label.StepSize"));
        this.stepSizeLabel.setAlignmentX(1.0f);
        this.stepSizeLabel.setForeground(new Color(0, 0, 102));
        this.stepSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.stepSizeField = new IntegerField(5);
        this.stepSizeField.setMaximumSize(this.stepSizeField.getPreferredSize());
        this.stepSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClipInspector.this.clipControl.getFrameNumber();
                ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.stepSizeField.selectAll();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.frameToStep(n));
            }
        });
        this.stepSizeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.stepSizeField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                int n = ClipInspector.this.clipControl.getFrameNumber();
                ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.frameToStep(n));
            }
        });
        this.endLabel = new JLabel(MediaRes.getString("ClipInspector.Label.EndFrame"));
        this.endLabel.setAlignmentX(1.0f);
        this.endLabel.setForeground(new Color(0, 0, 102));
        this.endLabel.setFont(new Font("Dialog", 0, 12));
        this.endField = new IntegerField(5);
        this.endField.setMaximumSize(this.endField.getPreferredSize());
        this.endField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.endField.selectAll();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.getStepCount() - 1);
            }
        });
        this.endField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.endField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.getStepCount() - 1);
            }
        });
        this.t0Label = new JLabel(MediaRes.getString("ClipInspector.Label.StartTime"));
        this.t0Label.setAlignmentX(1.0f);
        this.t0Label.setForeground(new Color(0, 0, 102));
        this.t0Label.setFont(new Font("Dialog", 0, 12));
        this.t0Field = new NumberField(5);
        String string = "0.00E0";
        String string2 = "0.000";
        double[] dArray = new double[]{0.01, 0.1, 1.0, 10.0};
        this.t0Field.setPatterns(new String[]{string2, string2, string2, string2, string}, dArray);
        this.t0Field.setUnits(" s");
        this.t0Field.setMaximumSize(this.t0Field.getPreferredSize());
        this.t0Field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
                ClipInspector.this.t0Field.selectAll();
            }
        });
        this.t0Field.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.t0Field.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
            }
        });
        this.dtLabel = new JLabel(MediaRes.getString("ClipInspector.Label.FrameDt"));
        this.dtLabel.setAlignmentX(1.0f);
        this.dtLabel.setForeground(new Color(0, 0, 102));
        this.dtLabel.setFont(new Font("Dialog", 0, 12));
        this.dtLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        (this).ClipInspector.this.dtLabel.setText(actionEvent.getActionCommand());
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = 0;
                while (n < 3) {
                    JMenuItem jMenuItem = n == 0 ? new JMenuItem(MediaRes.getString("ClipInspector.Label.FPS")) : (n == 1 ? new JMenuItem(MediaRes.getString("ClipInspector.Label.FrameDt")) : new JMenuItem(MediaRes.getString("ClipInspector.Label.StepDt")));
                    jMenuItem.setFont(new Font("Dialog", 0, 12));
                    jMenuItem.setActionCommand(jMenuItem.getText());
                    jMenuItem.addActionListener(actionListener);
                    jPopupMenu.add(jMenuItem);
                    ++n;
                }
                jPopupMenu.show(ClipInspector.this.dtLabel, 0, ClipInspector.this.dtLabel.getHeight());
            }
        });
        this.dtField = new NumberField(5);
        this.dtField.setPatterns(new String[]{string, string2, string2, string2, string}, dArray);
        this.dtField.setUnits(" s");
        this.dtField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
                ClipInspector.this.dtField.selectAll();
            }
        });
        this.dtField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.dtField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
            }
        });
        this.fpsLabel = new JLabel(MediaRes.getString("ClipInspector.Label.FPS"));
        this.fpsLabel.setAlignmentX(1.0f);
        this.fpsLabel.setForeground(new Color(0, 0, 102));
        this.fpsLabel.setFont(new Font("Dialog", 0, 12));
        this.fpsField = new NumberField(5);
        string = "0.0E0";
        string2 = "0";
        this.fpsField.setPatterns(new String[]{string, "0.0", string2, string2, string});
        this.fpsField.setMaxValue(100000.0);
        this.fpsField.setUnits(" /s");
        this.fpsField.setMinValue(1.0E-6);
        this.fpsField.setMaximumSize(this.fpsField.getPreferredSize());
        this.fpsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setFrameDuration(1000.0 / ClipInspector.this.fpsField.getValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.fpsField.selectAll();
            }
        });
        this.fpsField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.fpsField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setFrameDuration(1000.0 / ClipInspector.this.fpsField.getValue());
                ClipInspector.this.updateDisplay();
            }
        });
        this.dataPanel = new JPanel(new GridLayout(2, 3));
        Border border = BorderFactory.createLineBorder(Color.GRAY);
        Border border2 = BorderFactory.createEmptyBorder(2, 6, 2, 6);
        this.dataPanel.setBorder(BorderFactory.createCompoundBorder(border, border2));
        jPanel2.add((Component)this.dataPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)this.startField, gridBagConstraints);
        this.dataPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel4.add((Component)this.stepSizeLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel4.add((Component)this.stepSizeField, gridBagConstraints);
        this.dataPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel5.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel5.add((Component)this.endField, gridBagConstraints);
        this.dataPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel6.add((Component)this.t0Label, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel6.add((Component)this.t0Field, gridBagConstraints);
        this.dataPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel7.add((Component)this.fpsLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel7.add((Component)this.fpsField, gridBagConstraints);
        this.dataPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel8.add((Component)this.dtLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel8.add((Component)this.dtField, gridBagConstraints);
        this.dataPanel.add(jPanel8);
        this.cancelButton = new JButton(MediaRes.getString("Dialog.Button.Cancel"));
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.revert();
                ClipInspector.this.setVisible(false);
            }
        });
        this.okButton = new JButton(MediaRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.setVisible(false);
            }
        });
        JPanel jPanel9 = new JPanel(new GridLayout(1, 4));
        jPanel9.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        jPanel2.add((Component)jPanel9, "South");
        jPanel9.add(Box.createHorizontalBox());
        jPanel9.add(this.okButton);
        jPanel9.add(this.cancelButton);
        jPanel9.add(Box.createHorizontalBox());
    }

    public void updateDisplay() {
        this.startField.setIntValue(this.clip.getStartFrameNumber());
        this.stepSizeField.setIntValue(this.clip.getStepSize());
        this.t0Field.setValue(this.clip.getStartTime() / 1000.0);
        this.endField.setIntValue(this.clip.getEndFrameNumber());
        this.dtField.setValue(this.clipControl.getMeanFrameDuration() / 1000.0);
        this.fpsField.setValue(1000.0 / this.clipControl.getMeanFrameDuration());
        this.repaint();
    }

    private void revert() {
        this.clip.setStartFrameNumber(this.prevStart);
        this.clip.setStepSize(this.prevSize);
        this.clip.setStepCount(this.prevCount);
        this.clip.setStartTime(this.prevStartTime);
        this.clipControl.setRate(this.prevRate);
        this.clipControl.setFrameDuration(this.prevDt);
        this.clipControl.setStepNumber(this.clip.frameToStep(this.prevFrame));
        this.clip.trimFrameCount();
    }
}

