/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.display3d.core.Set;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.core.interaction.InteractionTarget;
import org.opensourcephysics.display3d.factory.OSP3DFactory;
import org.opensourcephysics.drawing3d.WrapsElement;
import org.opensourcephysics.numerics.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTrail
implements Data,
Element,
WrapsElement {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private String xLabel = "x";
    private String yLabel = "y";
    private String zLabel = "z";
    private ElementTrail currentSegment;
    private double[] flushPoint = null;
    private boolean flushConnected = false;
    private int counter = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;
    private double lastZ = Double.NaN;
    private Set group;
    protected int datasetID = this.hashCode();

    public MultiTrail() {
        this.group = OSP3DFactory.Set();
        this.createNewTrail();
    }

    public Group getGroup() {
        return this.group;
    }

    private void createNewTrail() {
        ElementTrail elementTrail = this.currentSegment;
        this.currentSegment = OSP3DFactory.ElementTrail();
        this.currentSegment.setConnected(true);
        this.currentSegment.setMaximumPoints(this.maximum);
        this.currentSegment.setXLabel(this.xLabel);
        this.currentSegment.setYLabel(this.yLabel);
        this.currentSegment.setZLabel(this.zLabel);
        if (elementTrail != null) {
            elementTrail.getStyle().copyTo(this.currentSegment.getStyle());
        }
        this.group.addElement(this.currentSegment);
    }

    @Override
    public Element getElementWrapped() {
        return this.group;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean bl) {
        this.noRepeat = bl;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int n) {
        if (this.skip != n) {
            this.skip = n;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void setMaximumPoints(int n) {
        this.maximum = n;
        this.currentSegment.setMaximumPoints(this.maximum);
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
        this.currentSegment.setXLabel(this.xLabel);
    }

    public void setYLabel(String string) {
        this.yLabel = string;
        this.currentSegment.setYLabel(this.yLabel);
    }

    public void setZLabel(String string) {
        this.zLabel = string;
        this.currentSegment.setZLabel(this.zLabel);
    }

    public void addPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, d3, this.connectionType);
    }

    public void addPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], dArray[2], this.connectionType);
    }

    public void moveToPoint(double d, double d2, double d3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, d3, 0);
    }

    public void moveToPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], dArray[2], 0);
    }

    public void addPoints(double[][] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(dArray[n][0], dArray[n][1], dArray[n][2], this.connectionType);
            ++n;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, Math.min(dArray2.length, dArray3.length));
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2], dArray3[n2], this.connectionType);
            ++n2;
        }
    }

    public void clear() {
        for (Element element : this.group.getElements()) {
            ((ElementTrail)element).clear();
        }
        this.group.removeAllElements();
        this.group.addElement(this.currentSegment);
        this.initialize();
    }

    public void initialize() {
        this.currentSegment.clear();
        this.flushPoint = null;
        this.currentSegment.setGhostPoint(null, false);
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    public void newSegment() {
        if (this.flushPoint != null) {
            boolean bl = this.flushConnected;
            if (Double.isNaN(this.lastX)) {
                bl = false;
            }
            if (bl) {
                this.currentSegment.addPoint(this.flushPoint);
            } else {
                this.currentSegment.moveToPoint(this.flushPoint[0], this.flushPoint[1], this.flushPoint[2]);
            }
        }
        this.flushPoint = null;
        this.currentSegment.setGhostPoint(null, false);
        this.createNewTrail();
        this.counter = 0;
        this.lastZ = Double.NaN;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
    }

    private void addPoint(double d, double d2, double d3, int n) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            this.lastZ = Double.NaN;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            return;
        }
        if (this.noRepeat && this.lastX == d && this.lastY == d2 && this.lastZ == d3) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint = new double[]{d, d2, d3};
                this.flushConnected = n == 1;
                this.currentSegment.setGhostPoint(this.flushPoint, this.flushConnected);
                this.lastX = d;
                this.lastY = d2;
                this.lastZ = d3;
                return;
            }
            ++this.counter;
        }
        this.flushPoint = null;
        this.currentSegment.setGhostPoint(null, false);
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
        int n2 = n;
        if (Double.isNaN(this.lastX)) {
            n2 = 0;
        }
        switch (n2) {
            case 0: {
                this.currentSegment.moveToPoint(d, d2, d3);
                break;
            }
            default: {
                this.currentSegment.addPoint(d, d2, d3);
            }
        }
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public String getName() {
        String string = this.group.getName();
        int n = 1;
        int n2 = this.group.getElements().size();
        for (Element element : this.group.getElements()) {
            ElementTrail elementTrail = (ElementTrail)element;
            elementTrail.setName(n2 > 1 ? String.valueOf(string) + "_" + n : string);
            ++n;
        }
        return string;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.xLabel, this.yLabel, this.zLabel};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.group.getStyle().getFillColor(), this.group.getStyle().getFillColor(), this.group.getStyle().getFillColor()};
    }

    @Override
    public List<Data> getDataList() {
        this.getName();
        ArrayList<Data> arrayList = new ArrayList<Data>();
        for (Element element : this.group.getElements()) {
            arrayList.add((ElementTrail)element);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    public DrawingPanel3D getDrawingPanel3D() {
        return this.group.getDrawingPanel3D();
    }

    @Override
    public double getSizeX() {
        return this.group.getSizeX();
    }

    @Override
    public double getSizeY() {
        return this.group.getSizeY();
    }

    @Override
    public double getSizeZ() {
        return this.group.getSizeZ();
    }

    @Override
    public Style getStyle() {
        return this.currentSegment.getStyle();
    }

    @Override
    public Transformation getTransformation() {
        return this.group.getTransformation();
    }

    @Override
    public double getX() {
        return this.group.getX();
    }

    @Override
    public double getY() {
        return this.group.getY();
    }

    @Override
    public double getZ() {
        return this.group.getZ();
    }

    @Override
    public boolean isVisible() {
        return this.group.isVisible();
    }

    @Override
    public void loadUnmutableObjects(XMLControl xMLControl) {
        this.group.loadUnmutableObjects(xMLControl);
    }

    @Override
    public void setName(String string) {
        this.group.setName(string);
    }

    @Override
    public void setSizeX(double d) {
        this.group.setSizeX(d);
    }

    @Override
    public void setSizeXYZ(double[] dArray) {
        this.group.setSizeXYZ(dArray);
    }

    @Override
    public void setSizeXYZ(double d, double d2, double d3) {
        this.group.setSizeXYZ(d, d2, d3);
    }

    @Override
    public void setSizeY(double d) {
        this.group.setSizeY(d);
    }

    @Override
    public void setSizeZ(double d) {
        this.group.setSizeZ(d);
    }

    @Override
    public void setTransformation(Transformation transformation) {
        this.group.setTransformation(transformation);
    }

    @Override
    public void setVisible(boolean bl) {
        this.group.setVisible(bl);
    }

    @Override
    public void setX(double d) {
        this.group.setX(d);
    }

    @Override
    public void setXYZ(double[] dArray) {
        this.group.setXYZ(dArray);
    }

    @Override
    public void setXYZ(double d, double d2, double d3) {
        this.group.setXYZ(d, d2, d3);
    }

    @Override
    public void setY(double d) {
        this.group.setY(d);
    }

    @Override
    public void setZ(double d) {
        this.group.setZ(d);
    }

    @Override
    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        return this.group.toBodyFrame(dArray);
    }

    @Override
    public double[] toSpaceFrame(double[] dArray) {
        return this.group.toSpaceFrame(dArray);
    }

    @Override
    public void addInteractionListener(InteractionListener interactionListener) {
        this.group.addInteractionListener(interactionListener);
    }

    @Override
    public InteractionTarget getInteractionTarget(int n) {
        return this.group.getInteractionTarget(n);
    }

    @Override
    public void removeInteractionListener(InteractionListener interactionListener) {
        this.group.removeInteractionListener(interactionListener);
    }
}

