/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Element
implements org.opensourcephysics.display3d.core.Group {
    private ArrayList<Element> elementList = new ArrayList();
    private ArrayList<Object3D> list3D = new ArrayList();
    private Object3D[] minimalObjects = new Object3D[1];
    protected int datasetID = this.hashCode();

    @Override
    public void addElement(org.opensourcephysics.display3d.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to group (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add((Element)element);
        }
        ((Element)element).setGroup(this);
    }

    public void addElements(Collection<org.opensourcephysics.display3d.core.Element> collection) {
        if (collection != null) {
            for (org.opensourcephysics.display3d.core.Element element : collection) {
                if (!(element instanceof Element)) continue;
                this.addElement((Element)element);
            }
        }
    }

    @Override
    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        this.elementList.remove(element);
    }

    @Override
    public void removeAllElements() {
        this.elementList.clear();
    }

    @Override
    public synchronized List<org.opensourcephysics.display3d.core.Element> getElements() {
        return new ArrayList<org.opensourcephysics.display3d.core.Element>(this.elementList);
    }

    @Override
    public org.opensourcephysics.display3d.core.Element getElement(int n) {
        try {
            return this.elementList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        this.list3D.clear();
        Iterator<Element> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            Object3D[] object3DArray = iterator.next().getObjects3D();
            if (object3DArray == null) continue;
            int n = 0;
            int n2 = object3DArray.length;
            while (n < n2) {
                this.list3D.add(object3DArray[n]);
                ++n;
            }
        }
        this.setElementChanged(false);
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    @Override
    void draw(Graphics2D graphics2D, int n) {
        System.out.println("Group draw (i): I should not be called!");
    }

    @Override
    void drawQuickly(Graphics2D graphics2D) {
        Iterator<Element> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            iterator.next().drawQuickly(graphics2D);
        }
        this.setElementChanged(false);
    }

    @Override
    void setNeedToProject(boolean bl) {
        Iterator<Element> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setNeedToProject(bl);
        }
    }

    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).getExtrema(dArray3, dArray4);
            d = Math.min(Math.min(d, dArray3[0]), dArray4[0]);
            d2 = Math.max(Math.max(d2, dArray3[0]), dArray4[0]);
            d3 = Math.min(Math.min(d3, dArray3[1]), dArray4[1]);
            d4 = Math.max(Math.max(d4, dArray3[1]), dArray4[1]);
            d5 = Math.min(Math.min(d5, dArray3[2]), dArray4[2]);
            d6 = Math.max(Math.max(d6, dArray3[2]), dArray4[2]);
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    @Override
    public InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            InteractionTarget interactionTarget = ((Element)iterator.next()).getTargetHit(n, n2);
            if (interactionTarget == null) continue;
            return interactionTarget;
        }
        return null;
    }

    @Override
    boolean getElementChanged() {
        Iterator<Element> iterator = this.elementList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getElementChanged()) continue;
            return true;
        }
        return super.getElementChanged();
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        for (Element element : this.elementList) {
            if (!(element instanceof Data)) continue;
            return ((Data)((Object)element)).getColumnNames();
        }
        return null;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.getStyle().getFillColor(), this.getStyle().getFillColor(), this.getStyle().getFillColor()};
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        for (Element element : this.elementList) {
            if (!(element instanceof Data)) continue;
            arrayList.add((Data)((Object)element));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends Group.Loader {
        protected Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new Group();
        }
    }
}

