/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.java3d.Element;

public class Style
implements org.opensourcephysics.display3d.core.Style {
    static final int STYLE_LINE_COLOR = 0;
    static final int STYLE_LINE_WIDTH = 1;
    static final int STYLE_FILL_COLOR = 2;
    static final int STYLE_RESOLUTION = 3;
    private float shininess = 50.0f;
    private Color lineColor = Color.black;
    private float lineWidth = 0.5f;
    private Color fillColor = Color.blue;
    private Resolution resolution = null;
    private boolean drawsFill = true;
    private boolean drawsLines = true;
    private double depthFactor = 1.0;
    private String textureFile1 = null;
    private String textureFile2 = null;
    private double transpTexture = Double.NaN;
    private boolean combineTexture = false;
    private int position = 0;
    private Element element = null;
    private Stroke lineStroke = new BasicStroke(this.lineWidth);
    private Appearance appearance;
    private TransparencyAttributes transparency;

    Style(Element element) {
        this.element = element;
        this.appearance = new Appearance();
        this.appearance.setCapability(9);
        this.appearance.setCapability(8);
        this.appearance.setCapability(15);
        this.appearance.setCapability(14);
        this.appearance.setCapability(1);
        this.appearance.setCapability(0);
        this.appearance.setCapability(3);
        this.appearance.setCapability(12);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(1);
        this.appearance.setPolygonAttributes(polygonAttributes);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setLineAntialiasingEnable(true);
        lineAttributes.setLineWidth(this.lineWidth);
        this.appearance.setLineAttributes(lineAttributes);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        renderingAttributes.setCapability(10);
        this.appearance.setRenderingAttributes(renderingAttributes);
        this.transparency = new TransparencyAttributes();
        this.transparency.setCapability(3);
        this.transparency.setCapability(1);
        this.appearance.setTransparencyAttributes(this.transparency);
        Material material = new Material();
        material.setCapability(1);
        this.appearance.setMaterial(material);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setCapability(1);
        this.appearance.setColoringAttributes(coloringAttributes);
        this.setFillColor(this.fillColor);
    }

    void setElement(Element element) {
        this.element = element;
    }

    public void copyTo(org.opensourcephysics.display3d.core.Style style) {
        style.setDrawingFill(this.drawsFill);
        style.setDrawingLines(this.drawsLines);
        style.setLineColor(this.lineColor);
        style.setLineWidth(this.lineWidth);
        style.setFillColor(this.fillColor);
        style.setResolution(this.resolution);
        style.setDepthFactor(this.depthFactor);
    }

    public void setLineWidth(float f) {
        if (this.lineWidth == f) {
            return;
        }
        this.lineWidth = f;
        this.lineStroke = new BasicStroke(this.lineWidth);
        this.appearance.getLineAttributes().setLineWidth(this.lineWidth);
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            return;
        }
        this.fillColor = color;
        if (this.fillColor != null && this.isDrawingFill()) {
            float[] fArray = this.fillColor.getRGBComponents(null);
            this.appearance.getMaterial().setDiffuseColor(fArray[0], fArray[1], fArray[2]);
            this.transparency.setTransparency(1.0f - fArray[3]);
            if (fArray[3] != 1.0f) {
                this.appearance.getPolygonAttributes().setCullFace(0);
                this.transparency.setTransparencyMode(1);
            } else {
                this.appearance.getPolygonAttributes().setCullFace(1);
                this.transparency.setTransparencyMode(4);
            }
            this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
            this.appearance.getMaterial().setShininess(this.shininess);
        }
        this.element.setElementChanged(4);
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            return;
        }
        this.lineColor = color;
        if (this.lineColor != null && this.isDrawingLines()) {
            float[] fArray = this.lineColor.getRGBComponents(null);
            this.appearance.getRenderingAttributes().setIgnoreVertexColors(true);
            this.appearance.getColoringAttributes().setColor(fArray[0], fArray[1], fArray[2]);
            this.transparency.setTransparency(1.0f - fArray[3]);
            if (fArray[3] != 1.0f) {
                this.appearance.getPolygonAttributes().setCullFace(0);
                this.transparency.setTransparencyMode(1);
            } else {
                this.appearance.getPolygonAttributes().setCullFace(1);
                this.transparency.setTransparencyMode(4);
            }
            this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
            this.appearance.getMaterial().setShininess(this.shininess);
        }
        this.element.setElementChanged(4);
    }

    public final Color getLineColor() {
        return this.lineColor;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this.element.setElementChanged(8);
    }

    public final Resolution getResolution() {
        return this.resolution;
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setTexture(String string, String string2, double d, boolean bl) {
        this.textureFile1 = string;
        this.textureFile2 = string2;
        this.transpTexture = d;
        this.combineTexture = bl;
    }

    public String[] getTextures() {
        return new String[]{this.textureFile1, this.textureFile2};
    }

    public double getTransparency() {
        return this.transpTexture;
    }

    public boolean getCombine() {
        return this.combineTexture;
    }

    public final void setRelativePosition(int n) {
        this.position = n;
    }

    public final int getRelativePosition() {
        return this.position;
    }

    public static XML.ObjectLoader getLoader() {
        return new StyleLoader();
    }

    public boolean isDrawingFill() {
        return this.drawsFill && this.fillColor != null;
    }

    public void setDrawingFill(boolean bl) {
        if (this.drawsFill != bl) {
            this.drawsFill = bl;
            if (bl) {
                this.turnFillOn();
            } else if (this.drawsLines) {
                this.turnLinesOn();
            }
        }
    }

    public boolean isDrawingLines() {
        return this.drawsLines && this.lineColor != null;
    }

    public void setDrawingLines(boolean bl) {
        if (this.drawsLines != bl) {
            this.drawsLines = bl;
            if (bl && !this.drawsFill) {
                this.turnLinesOn();
            }
        }
    }

    private void turnFillOn() {
        this.appearance.getPolygonAttributes().setPolygonMode(2);
        this.appearance.getPolygonAttributes().setCullFace(1);
        this.appearance.getMaterial().setDiffuseColor(new Color3f(this.fillColor));
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }

    private void turnLinesOn() {
        this.appearance.getPolygonAttributes().setPolygonMode(1);
        this.appearance.getPolygonAttributes().setCullFace(0);
        this.appearance.getMaterial().setDiffuseColor(new Color3f(this.lineColor));
        this.appearance.getMaterial().setSpecularColor(new Color3f(Color.white));
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    protected static class StyleLoader
    extends XMLLoader {
        protected StyleLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            xMLControl.setValue("line color", style.lineColor);
            xMLControl.setValue("line width", style.lineWidth);
            xMLControl.setValue("fill color", style.fillColor);
            xMLControl.setValue("resolution", style.resolution);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Style(null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            style.lineColor = (Color)xMLControl.getObject("line color");
            float f = (float)xMLControl.getDouble("line width");
            style.lineWidth = f;
            style.lineStroke = new BasicStroke(f);
            style.fillColor = (Color)xMLControl.getObject("fill color");
            style.resolution = (Resolution)xMLControl.getObject("resolution");
            return object;
        }
    }
}

