/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.FlatData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class GridPlot
extends MeasuredImage
implements Plot2D {
    boolean autoscaleZ = true;
    GridData griddata;
    int[] rgbData;
    Grid grid;
    ColorMapper colorMap;
    private int ampIndex = 0;

    public GridPlot(GridData gridData) {
        this.setGridData(gridData);
    }

    public GridPlot() {
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.colorMap == null) {
            this.colorMap = new ColorMapper(100, -1.0, 1.0, 0);
        }
        if (this.griddata == null) {
            return;
        }
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        this.rgbData = new int[n * n2];
        this.image = new BufferedImage(n, n2, 2);
        Grid grid = new Grid(n, n2);
        grid.setColor(Color.lightGray);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        } else {
            grid.setColor(Color.lightGray);
        }
        this.grid = grid;
        this.update();
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.setMinMax(d, d2, d3, d4);
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.colorMap.setScale(d, d2);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.colorMap.getFloor();
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    public void setColorPalette(Color[] colorArray) {
        this.colorMap.setColorPalette(colorArray);
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setFloorCeilColor(color, color2);
    }

    public void setShowGridLines(boolean bl) {
        if (this.grid != null) {
            this.grid.setVisible(bl);
        }
    }

    public void setGridLineColor(Color color) {
        if (this.grid != null) {
            this.grid.setColor(color);
        }
    }

    public void setExpandedZ(boolean bl, double d) {
        if (bl && d > 0.0) {
            ZExpansion zExpansion = new ZExpansion(d);
            this.colorMap.setZMap(zExpansion);
        } else {
            this.colorMap.setZMap(null);
        }
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[0], dArray[1]);
        }
        this.recolorImage();
        this.colorMap.updateLegend(null);
    }

    protected void recolorImage() {
        if (this.griddata == null) {
            return;
        }
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            this.xmin = this.griddata.getLeft() - d / 2.0;
            this.xmax = this.griddata.getRight() + d / 2.0;
            this.ymin = this.griddata.getBottom() + d2 / 2.0;
            this.ymax = this.griddata.getTop() - d2 / 2.0;
        } else {
            this.xmin = this.griddata.getLeft();
            this.xmax = this.griddata.getRight();
            this.ymin = this.griddata.getBottom();
            this.ymax = this.griddata.getTop();
        }
        if (this.grid != null) {
            this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        }
        double[][][] dArray = this.griddata.getData();
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        if (this.griddata instanceof GridPointData) {
            int n3 = this.ampIndex + 2;
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    this.rgbData[n5] = this.colorMap.doubleToColor(dArray[n6][n4][n3]).getRGB();
                    ++n5;
                    ++n6;
                }
                ++n4;
            }
            this.image.setRGB(0, 0, n, n2, this.rgbData, 0, n);
        } else if (this.griddata instanceof ArrayData) {
            int n7 = 0;
            int n8 = 0;
            while (n7 < n2) {
                int n9 = 0;
                while (n9 < n) {
                    this.rgbData[n8] = this.colorMap.doubleToColor(dArray[this.ampIndex][n9][n7]).getRGB();
                    ++n8;
                    ++n9;
                }
                ++n7;
            }
            this.image.setRGB(0, 0, n, n2, this.rgbData, 0, n);
        } else if (this.griddata instanceof FlatData) {
            int n10 = dArray[0][0].length / (n * n2);
            int n11 = 0;
            int n12 = 0;
            while (n11 < n2) {
                int n13 = n11 * n * n10;
                int n14 = 0;
                while (n14 < n) {
                    this.rgbData[n12] = this.colorMap.doubleToColor(dArray[0][0][n13 + n14 * n10 + this.ampIndex]).getRGB();
                    ++n12;
                    ++n14;
                }
                ++n11;
            }
            this.image.setRGB(0, 0, n, n2, this.rgbData, 0, n);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        super.draw(drawingPanel, graphics);
        this.grid.draw(drawingPanel, graphics);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new GridPlot(null);
            }

            public void saveObject(XMLControl xMLControl, Object object) {
                super.saveObject(xMLControl, object);
                GridPlot gridPlot = (GridPlot)object;
                xMLControl.setValue("color map", gridPlot.colorMap);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                super.loadObject(xMLControl, object);
                GridPlot gridPlot = (GridPlot)object;
                gridPlot.colorMap = (ColorMapper)xMLControl.getObject("color map");
                return gridPlot;
            }
        };
    }
}

