/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementSphere;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlSphereSet3D
extends ControlSet3D {
    private static final int SPHERESET_PROPERTIES_ADDED = 9;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesDisplacement() {
        return 9;
    }

    @Override
    protected Element createAnElement() {
        ElementSphere elementSphere = OSP3DFactory.ElementSphere();
        elementSphere.setSizeXYZ(0.2, 0.2, 0.2);
        return elementSphere;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementSphere)element2).setRadius(((ElementSphere)element).getRadius());
        ((ElementSphere)element2).setMinimumAngleU(((ElementSphere)element).getMinimumAngleU());
        ((ElementSphere)element2).setMaximumAngleU(((ElementSphere)element).getMaximumAngleU());
        ((ElementSphere)element2).setMinimumAngleV(((ElementSphere)element).getMinimumAngleV());
        ((ElementSphere)element2).setMaximumAngleV(((ElementSphere)element).getMaximumAngleV());
        ((ElementSphere)element2).setClosedTop(((ElementSphere)element).isClosedTop());
        ((ElementSphere)element2).setClosedBottom(((ElementSphere)element).isClosedBottom());
        ((ElementSphere)element2).setClosedLeft(((ElementSphere)element).isClosedLeft());
        ((ElementSphere)element2).setClosedRight(((ElementSphere)element).isClosedRight());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumAngleU");
            infoList.add("maximumAngleU");
            infoList.add("minimumAngleV");
            infoList.add("maximumAngleV");
            infoList.add("closedTop");
            infoList.add("closedBottom");
            infoList.add("closedLeft");
            infoList.add("closedRight");
            infoList.add("radius");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumAngleU")) {
            return "int|int[]";
        }
        if (string.equals("minimumAngleU")) {
            return "int|int[]";
        }
        if (string.equals("maximumAngleU")) {
            return "int|int[]";
        }
        if (string.equals("minimumAngleV")) {
            return "int|int[]";
        }
        if (string.equals("maximumAngleV")) {
            return "int|int[]";
        }
        if (string.equals("closedTop")) {
            return "boolean|boolean[]";
        }
        if (string.equals("closedBottom")) {
            return "boolean|boolean[]";
        }
        if (string.equals("closedLeft")) {
            return "boolean|boolean[]";
        }
        if (string.equals("closedRight")) {
            return "boolean|boolean[]";
        }
        if (string.equals("radius")) {
            return "int|double|double[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    while (n2 < this.numElements) {
                        ((ElementSphere)this.elements[n2]).setMinimumAngleU(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n3 = value.getInteger();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        ((ElementSphere)this.elements[n4]).setMinimumAngleU(n3);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n5 = 0;
                    while (n5 < this.numElements) {
                        ((ElementSphere)this.elements[n5]).setMaximumAngleU(nArray[n5]);
                        ++n5;
                    }
                } else {
                    int n6 = value.getInteger();
                    int n7 = 0;
                    while (n7 < this.numElements) {
                        ((ElementSphere)this.elements[n7]).setMaximumAngleU(n6);
                        ++n7;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n8 = 0;
                    while (n8 < this.numElements) {
                        ((ElementSphere)this.elements[n8]).setMinimumAngleV(nArray[n8]);
                        ++n8;
                    }
                } else {
                    int n9 = value.getInteger();
                    int n10 = 0;
                    while (n10 < this.numElements) {
                        ((ElementSphere)this.elements[n10]).setMinimumAngleV(n9);
                        ++n10;
                    }
                }
                break;
            }
            case 3: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n11 = 0;
                    while (n11 < this.numElements) {
                        ((ElementSphere)this.elements[n11]).setMaximumAngleV(nArray[n11]);
                        ++n11;
                    }
                } else {
                    int n12 = value.getInteger();
                    int n13 = 0;
                    while (n13 < this.numElements) {
                        ((ElementSphere)this.elements[n13]).setMaximumAngleV(n12);
                        ++n13;
                    }
                }
                break;
            }
            case 4: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n14 = 0;
                    while (n14 < this.numElements) {
                        ((ElementSphere)this.elements[n14]).setClosedTop(blArray[n14]);
                        ++n14;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n15 = 0;
                    while (n15 < this.numElements) {
                        ((ElementSphere)this.elements[n15]).setClosedTop(bl);
                        ++n15;
                    }
                }
                break;
            }
            case 5: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n16 = 0;
                    while (n16 < this.numElements) {
                        ((ElementSphere)this.elements[n16]).setClosedBottom(blArray[n16]);
                        ++n16;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n17 = 0;
                    while (n17 < this.numElements) {
                        ((ElementSphere)this.elements[n17]).setClosedBottom(bl);
                        ++n17;
                    }
                }
                break;
            }
            case 6: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n18 = 0;
                    while (n18 < this.numElements) {
                        ((ElementSphere)this.elements[n18]).setClosedLeft(blArray[n18]);
                        ++n18;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n19 = 0;
                    while (n19 < this.numElements) {
                        ((ElementSphere)this.elements[n19]).setClosedLeft(bl);
                        ++n19;
                    }
                }
                break;
            }
            case 7: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n20 = 0;
                    while (n20 < this.numElements) {
                        ((ElementSphere)this.elements[n20]).setClosedRight(blArray[n20]);
                        ++n20;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n21 = 0;
                    while (n21 < this.numElements) {
                        ((ElementSphere)this.elements[n21]).setClosedRight(bl);
                        ++n21;
                    }
                }
                break;
            }
            case 8: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n22 = 0;
                    while (n22 < this.numElements) {
                        ((ElementSphere)this.elements[n22]).setRadius(dArray[n22]);
                        ++n22;
                    }
                } else {
                    double d = value.getDouble();
                    int n23 = 0;
                    while (n23 < this.numElements) {
                        ((ElementSphere)this.elements[n23]).setRadius(d);
                        ++n23;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 9, value);
            }
        }
        this.refreshUnderEjs();
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    ((ElementSphere)this.elements[n2]).setMinimumAngleU(0);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    ((ElementSphere)this.elements[n3]).setMaximumAngleU(360);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    ((ElementSphere)this.elements[n4]).setMinimumAngleV(-90);
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < this.numElements) {
                    ((ElementSphere)this.elements[n5]).setMaximumAngleV(90);
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < this.numElements) {
                    ((ElementSphere)this.elements[n6]).setClosedTop(true);
                    ++n6;
                }
                break;
            }
            case 5: {
                int n7 = 0;
                while (n7 < this.numElements) {
                    ((ElementSphere)this.elements[n7]).setClosedBottom(true);
                    ++n7;
                }
                break;
            }
            case 6: {
                int n8 = 0;
                while (n8 < this.numElements) {
                    ((ElementSphere)this.elements[n8]).setClosedLeft(true);
                    ++n8;
                }
                break;
            }
            case 7: {
                int n9 = 0;
                while (n9 < this.numElements) {
                    ((ElementSphere)this.elements[n9]).setClosedRight(true);
                    ++n9;
                }
                break;
            }
            case 8: {
                int n10 = 0;
                while (n10 < this.numElements) {
                    ((ElementSphere)this.elements[n10]).setRadius(0.2);
                    ++n10;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 9);
            }
        }
        this.refreshUnderEjs();
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(n - 9);
    }
}

