/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.ResizableIcon;

public class Resource {
    private static String encoding = "UTF-8";
    private static Charset defaultCharset = Charset.forName(encoding);
    private URL url;
    private File file;
    private boolean isAnImage = true;
    private ImageIcon icon;
    private String string;
    private AudioClip clip;
    private BufferedImage image;
    private String zipContent;
    private URL contentURL;

    public static Charset getCharset() {
        return defaultCharset;
    }

    public Resource(URL url) {
        this.url = url;
    }

    public Resource(File file) {
        this.file = file;
    }

    protected Resource(URL zipURL, String content) {
        this.url = zipURL;
        this.zipContent = content;
        if (content != null) {
            try {
                String path = String.valueOf(zipURL.toExternalForm()) + "!/" + content;
                this.contentURL = new URL(path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String getAbsolutePath() {
        if (this.getFile() != null) {
            try {
                return XML.forwardSlash(this.getFile().getCanonicalPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return this.getFile().getAbsolutePath();
            }
        }
        if (this.getURL() != null) {
            String path = this.getURL().toExternalForm();
            return path;
        }
        return null;
    }

    public URL getURL() {
        if (this.url == null && this.file != null) {
            String path = this.getAbsolutePath();
            try {
                this.url = path.startsWith("/") ? new URL("file:" + path) : new URL("file:/" + path);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if (this.contentURL != null) {
            return this.contentURL;
        }
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Object getObject(Class<?> type) {
        if (ImageIcon.class.equals(type)) {
            return this.getIcon();
        }
        if (String.class.equals(type)) {
            return this.getString();
        }
        return null;
    }

    public InputStream openInputStream() {
        if (this.getFile() != null) {
            try {
                return new FileInputStream(this.getFile());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        if (this.url != null) {
            try {
                if (this.zipContent != null) {
                    BufferedInputStream bufIn = new BufferedInputStream(this.url.openStream());
                    ZipInputStream input = new ZipInputStream(bufIn);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = input.getNextEntry()) != null) {
                        String filename;
                        if (zipEntry.isDirectory() || !this.zipContent.contains(filename = zipEntry.getName())) continue;
                        return input;
                    }
                }
                return this.getURL().openStream();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public BufferedReader openReader() {
        return this.openReader(defaultCharset);
    }

    public BufferedReader openReader(Charset charset) {
        InputStream stream = this.openInputStream();
        if (stream == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(stream, charset));
    }

    public Icon getIcon() {
        if (this.icon == null && this.isAnImage) {
            this.icon = new ImageIcon(this.getURL());
            if (this.icon.getIconWidth() < 1) {
                this.icon = null;
                this.isAnImage = false;
                return null;
            }
        }
        return new ResizableIcon(this.icon);
    }

    public Image getImage() {
        Icon icon = this.getIcon();
        if (icon != null) {
            ResizableIcon ico = (ResizableIcon)icon;
            ImageIcon imageIcon = (ImageIcon)ico.getBaseIcon();
            return imageIcon.getImage();
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(1);
    }

    public BufferedImage getBufferedImage(int bufferedImageType) {
        if (this.isAnImage && (this.image == null || this.image.getType() != bufferedImageType)) {
            Image im = this.getImage();
            if (im == null) {
                this.isAnImage = false;
            } else {
                this.image = new BufferedImage(im.getWidth(null), im.getHeight(null), bufferedImageType);
                Graphics2D g2 = this.image.createGraphics();
                g2.drawImage(im, 0, 0, null);
            }
        }
        return this.image;
    }

    public String getString() {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader in = new BufferedReader(this.openReader());
                String line = in.readLine();
                while (line != null) {
                    buffer.append(String.valueOf(line) + XML.NEW_LINE);
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.string = buffer.toString();
        }
        return this.string;
    }

    public String getString(String encoding) {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            try {
                Charset charset = Charset.forName(encoding);
                BufferedReader in = new BufferedReader(this.openReader(charset));
                String line = in.readLine();
                while (line != null) {
                    buffer.append(String.valueOf(line) + XML.NEW_LINE);
                    line = in.readLine();
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.string = buffer.toString();
        }
        return this.string;
    }

    public AudioClip getAudioClip() {
        if (this.clip == null && this.getURL() != null) {
            this.clip = Applet.newAudioClip(this.getURL());
        }
        return this.clip;
    }
}

