/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;

public class EjsTool {
    private static final String INFO_FILE = ".Ejs.txt";
    public static final String GET_MODEL_METHOD = "_getEjsModel";
    public static final String GET_RESOURCES_METHOD = "_getEjsResources";
    public static final String GET_APPLET_DIMENSION_METHOD = "_getEjsAppletDimension";
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static boolean hasEjsModel(Class<?> _ejsClass) {
        try {
            Class[] c = new Class[]{};
            Method getModelMethod = _ejsClass.getMethod(GET_MODEL_METHOD, c);
            return getModelMethod != null;
        }
        catch (Exception _exc) {
            return false;
        }
    }

    public static Dimension getEjsAppletDimension(Class<?> _ejsClass) {
        Method getDimensionMethod;
        block3: {
            try {
                Class[] c = new Class[]{};
                getDimensionMethod = _ejsClass.getMethod(GET_APPLET_DIMENSION_METHOD, c);
                if (getDimensionMethod != null) break block3;
                return null;
            }
            catch (Exception _exc) {
                return null;
            }
        }
        Object[] o = new Object[]{};
        return (Dimension)getDimensionMethod.invoke(null, o);
    }

    public static boolean runEjs(Class<?> _ejsClass) {
        return EjsTool.runEjs(_ejsClass, null);
    }

    public static boolean runEjs(Class<?> _ejsClass, String _password) {
        try {
            Class[] c = new Class[]{};
            Method getModelMethod = _ejsClass.getMethod(GET_MODEL_METHOD, c);
            Method getResourcesMethod = _ejsClass.getMethod(GET_RESOURCES_METHOD, c);
            Object[] o = new Object[]{};
            String model = (String)getModelMethod.invoke(null, o);
            Set list = getResourcesMethod != null ? (Set)getResourcesMethod.invoke(null, o) : new HashSet();
            return EjsTool.doRunEjs(model, list, _ejsClass, _password);
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            String[] message = new String[]{res.getString("EjsTool.EjsNotRunning"), String.valueOf(res.getString("EjsTool.NoModel")) + " " + _ejsClass.getName()};
            JOptionPane.showMessageDialog(null, message, res.getString("EjsTool.Error"), 2);
            return false;
        }
    }

    public static void saveInformation(String _home, String _release) {
        try {
            String filename = System.getProperty("user.home").replace('\\', '/');
            if (!filename.endsWith("/")) {
                filename = String.valueOf(filename) + "/";
            }
            filename = String.valueOf(filename) + INFO_FILE;
            String dir = System.getProperty("user.dir");
            FileWriter fout = new FileWriter(filename);
            fout.write("directory = " + dir + "\n");
            fout.write("home = " + _home + "\n");
            fout.write("version = " + _release + "\n");
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void saveInformation(String _binDirectoryPath, String _sourceDirectoryPath, String _release) {
        try {
            String filename = System.getProperty("user.home").replace('\\', '/');
            if (!filename.endsWith("/")) {
                filename = String.valueOf(filename) + "/";
            }
            FileWriter fout = new FileWriter(String.valueOf(filename) + INFO_FILE);
            fout.write("ejs_root_directory = " + _binDirectoryPath + "\n");
            fout.write("source_directory = " + _sourceDirectoryPath + "\n");
            fout.write("version = " + _release + "\n");
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static String getPath(File _file) {
        int a;
        String path;
        try {
            path = _file.getCanonicalPath();
        }
        catch (Exception exc) {
            path = _file.getAbsolutePath();
        }
        if (OSPRuntime.isWindows() && (a = (path = path.replace('\\', '/')).indexOf(58)) > 0) {
            path = String.valueOf(path.substring(0, a).toUpperCase()) + path.substring(a);
        }
        if (_file.isDirectory() && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    /*
     * Exception decompiling
     */
    private static boolean doRunEjs(String _model, Set<String> _resources, Class<?> _ejsClass, String _password) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE], 2[SWITCH]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Object> ejsConfirmList(Component _target, Dimension _size, String _message, String _title, List<?> _list) {
        return EjsTool.ejsConfirmList(_target, _size, _message, _title, _list, null);
    }

    public static List<Object> ejsConfirmList(Component _target, Dimension _size, String _message, String _title, List<?> _list, JComponent _bottomComponent) {
        class ReturnValue {
            boolean value = false;

            ReturnValue() {
            }
        }
        final ReturnValue returnValue = new ReturnValue();
        final DefaultListModel listModel = new DefaultListModel();
        int i = 0;
        int n = _list.size();
        while (i < n) {
            listModel.addElement(_list.get(i));
            ++i;
        }
        final JList list = new JList(listModel);
        list.setEnabled(true);
        list.setSelectionMode(2);
        list.setSelectionInterval(0, listModel.getSize() - 1);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setPreferredSize(_size);
        final JDialog dialog = new JDialog();
        MouseAdapter mouseListener = new MouseAdapter(){
            {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                AbstractButton button = (AbstractButton)evt.getSource();
                String aCmd = button.getActionCommand();
                if (aCmd.equals("ok")) {
                    returnValue.value = true;
                    dialog.setVisible(false);
                } else if (aCmd.equals("cancel")) {
                    returnValue.value = false;
                    dialog.setVisible(false);
                } else if (aCmd.equals("selectall")) {
                    list.setSelectionInterval(0, listModel.getSize() - 1);
                } else if (aCmd.equals("selectnone")) {
                    list.removeSelectionInterval(0, listModel.getSize() - 1);
                }
            }
        };
        JButton okButton = new JButton(DisplayRes.getString("GUIUtils.Ok"));
        okButton.setActionCommand("ok");
        okButton.addMouseListener(mouseListener);
        JButton cancelButton = new JButton(DisplayRes.getString("GUIUtils.Cancel"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addMouseListener(mouseListener);
        JButton excludeButton = new JButton(DisplayRes.getString("GUIUtils.SelectAll"));
        excludeButton.setActionCommand("selectall");
        excludeButton.addMouseListener(mouseListener);
        JButton includeButton = new JButton(DisplayRes.getString("GUIUtils.SelectNone"));
        includeButton.setActionCommand("selectnone");
        includeButton.addMouseListener(mouseListener);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(okButton);
        buttonPanel.add(excludeButton);
        buttonPanel.add(includeButton);
        buttonPanel.add(cancelButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea(_message);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFont(textArea.getFont().deriveFont(1));
        textArea.setBackground(topPanel.getBackground());
        textArea.setBorder(new EmptyBorder(5, 5, 10, 5));
        topPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        topPanel.add((Component)textArea, "North");
        topPanel.add((Component)scrollPane, "Center");
        if (_bottomComponent != null) {
            topPanel.add((Component)_bottomComponent, "South");
        }
        JSeparator sep1 = new JSeparator(0);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)sep1, "North");
        southPanel.add((Component)buttonPanel, "South");
        dialog.getContentPane().setLayout(new BorderLayout(5, 0));
        dialog.getContentPane().add((Component)topPanel, "Center");
        dialog.getContentPane().add((Component)southPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){
            {
            }

            @Override
            public void windowClosing(WindowEvent event) {
                returnValue.value = false;
            }
        });
        dialog.validate();
        dialog.pack();
        dialog.setTitle(_title);
        dialog.setLocationRelativeTo(_target);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (!returnValue.value) {
            return null;
        }
        Object[] selection = list.getSelectedValues();
        ArrayList<Object> newList = new ArrayList<Object>();
        int i2 = 0;
        int n2 = selection.length;
        while (i2 < n2) {
            newList.add(selection[i2]);
            ++i2;
        }
        return newList;
    }
}

