/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_interpolation.StateHistory;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;

public abstract class SolverEngineDiscreteTime
implements SolverEngine {
    protected InterpolatorEventSolver.ERROR mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
    protected int mDimension;
    protected int mTimeIndex;
    protected long mAccumulatedEvaluations = 0L;
    protected double mStepSize = 0.1;
    protected double mMaximumStepSize = Double.POSITIVE_INFINITY;
    protected double mInitialTime = 0.0;
    protected double mFinalTime = 0.0;
    protected double[] mInitialState;
    protected double[] mInitialRate;
    protected double[] mFinalState;
    protected double[] mFinalRate;
    protected ODE mODE;
    protected InterpolatorEventSolver mEventSolver;
    protected StateHistory mStateHistory;

    protected abstract int getNumberOfEvaluations();

    protected abstract void allocateOtherArrays();

    protected abstract void computeIntermediateStep(double var1, double[] var3);

    protected abstract InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver var1, double var2, double[] var4);

    protected abstract IntervalData computeFinalRateAndCreateIntervalData();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setODE(InterpolatorEventSolver eventSolver, ODE ode) {
        this.mEventSolver = eventSolver;
        this.mODE = ode;
        double[] state = this.mODE.getState();
        this.mDimension = state.length;
        this.mTimeIndex = this.mDimension - 1;
        this.mStateHistory = new StateHistory(ode);
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation dde = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(dde.getMaximumDelay());
        }
    }

    @Override
    public final void initialize(double stepSize) {
        this.mStepSize = stepSize;
        double[] state = this.mODE.getState();
        if (this.mInitialState == null || this.mInitialState.length != state.length) {
            this.mDimension = state.length;
            this.mTimeIndex = this.mDimension - 1;
            this.mInitialState = new double[this.mDimension];
            this.mInitialRate = new double[this.mDimension];
            this.mFinalState = new double[this.mDimension];
            this.mFinalRate = new double[this.mDimension];
            this.allocateOtherArrays();
        }
        this.mAccumulatedEvaluations = 0L;
        this.mStateHistory.clearAll();
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation dde = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(Math.max(Math.abs(dde.getMaximumDelay()), Math.abs(stepSize)));
        } else {
            this.mStateHistory.setMinimumLength(stepSize);
        }
        this.reinitialize(state);
    }

    @Override
    public void reinitialize(double[] state) {
        this.mInitialTime = state[this.mTimeIndex];
        System.arraycopy(state, 0, this.mInitialState, 0, this.mDimension);
        this.mODE.getRate(this.mInitialState, this.mInitialRate);
        ++this.mAccumulatedEvaluations;
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
    }

    @Override
    public double[] getCurrentRate() {
        return this.mInitialRate;
    }

    @Override
    public final void setStepSize(double stepSize) {
        this.mStepSize = stepSize;
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation dde = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(Math.max(Math.abs(dde.getMaximumDelay()), Math.abs(stepSize)));
        } else {
            this.mStateHistory.setMinimumLength(stepSize);
        }
    }

    @Override
    public void setMaximumStepSize(double stepSize) {
        this.mMaximumStepSize = Math.abs(stepSize);
    }

    @Override
    public final double getStepSize() {
        return this.mStepSize;
    }

    @Override
    public final double getInternalStepSize() {
        return this.mFinalTime - this.mInitialTime;
    }

    @Override
    public void setEstimateFirstStep(boolean estimate) {
    }

    @Override
    public void setTolerances(double absTol, double relTol) {
    }

    @Override
    public final double getMaximumTime(boolean withDiscontinuities) {
        if (this.mErrorCode != InterpolatorEventSolver.ERROR.NO_ERROR) {
            return Double.NaN;
        }
        if (Double.isNaN(this.mFinalTime)) {
            this.computeOneStep(withDiscontinuities);
        }
        return this.mFinalTime;
    }

    @Override
    public final double internalStep(boolean withDiscontinuities) {
        this.mInitialTime = this.mFinalTime;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        System.arraycopy(this.mFinalState, 0, this.mInitialState, 0, this.mDimension);
        System.arraycopy(this.mFinalRate, 0, this.mInitialRate, 0, this.mDimension);
        this.computeOneStep(withDiscontinuities);
        return this.mFinalTime;
    }

    @Override
    public final long getCounter() {
        return this.mAccumulatedEvaluations;
    }

    @Override
    public StateHistory getStateHistory() {
        return this.mStateHistory;
    }

    @Override
    public double[] interpolate(double time, double[] state) {
        return this.mStateHistory.interpolate(time, state);
    }

    @Override
    public double[] bestInterpolate(double time, double[] state) {
        if (Double.isNaN(this.mFinalTime)) {
            return null;
        }
        if (time == this.mFinalTime) {
            System.arraycopy(this.mFinalState, 0, state, 0, this.mDimension);
            return state;
        }
        if (time == this.mInitialTime) {
            System.arraycopy(this.mInitialState, 0, state, 0, this.mDimension);
            return state;
        }
        this.computeIntermediateStep(time - this.mInitialTime, state);
        return state;
    }

    protected double getActualStepSize() {
        return this.mStepSize;
    }

    protected double findTheDiscontinuity(double step) {
        int counter = 0;
        double left = 0.0;
        double right = step;
        int maxAttempts = this.mEventSolver.getDDEIterations();
        while (counter < maxAttempts) {
            if (Math.abs(left - right) < InterpolatorEventSolver.EPSILON) break;
            double testPoint = (left + right) / 2.0;
            switch (this.computeIntermediateStep(this.mEventSolver, testPoint, this.mFinalState)) {
                default: {
                    return Double.NaN;
                }
                case NO_DISCONTINUITY_ALONG_STEP: {
                    left = testPoint;
                    break;
                }
                case DISCONTINUITY_EXACTLY_ON_STEP: {
                    return this.mFinalState[this.mTimeIndex];
                }
                case DISCONTINUITY_JUST_PASSED: {
                    right -= (right - left) / 4.0;
                    break;
                }
                case DISCONTINUITY_ALONG_STEP: {
                    right = testPoint;
                }
            }
            ++counter;
        }
        this.computeIntermediateStep(this.mEventSolver, left, this.mFinalState);
        return this.mFinalState[this.mTimeIndex];
    }

    protected void computeOneStep(boolean hasDiscontinuities) {
        double step = this.mStepSize;
        if (hasDiscontinuities) {
            switch (this.computeIntermediateStep(this.mEventSolver, step, this.mFinalState)) {
                case DISCONTINUITY_PRODUCED_ERROR: {
                    this.mFinalTime = Double.NaN;
                    return;
                }
                case NO_DISCONTINUITY_ALONG_STEP: 
                case DISCONTINUITY_EXACTLY_ON_STEP: {
                    this.mFinalTime = this.mFinalState[this.mTimeIndex];
                    break;
                }
                case DISCONTINUITY_ALONG_STEP: 
                case DISCONTINUITY_JUST_PASSED: {
                    this.mFinalTime = this.findTheDiscontinuity(step);
                }
            }
            if (Double.isNaN(this.mFinalTime)) {
                this.mErrorCode = InterpolatorEventSolver.ERROR.DISCONTINUITY_PRODUCED_ERROR;
                return;
            }
        } else {
            this.computeIntermediateStep(step, this.mFinalState);
            this.mFinalTime = this.mFinalState[this.mTimeIndex];
        }
        this.mAccumulatedEvaluations += (long)this.getNumberOfEvaluations();
        this.mStateHistory.clean(this.mInitialTime);
        this.mStateHistory.addIntervalData(this.computeFinalRateAndCreateIntervalData());
    }
}

