/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strNxt_ = new short[4096];
    short[] strHsh_ = new short[9973];
    short numStrings_;

    LZWStringTable() {
    }

    int AddCharString(short index, byte b) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int hshidx = LZWStringTable.Hash((short)index, b);
        while (this.strHsh_[hshidx] != -1) {
            hshidx = (hshidx + 2039) % 9973;
        }
        this.strHsh_[hshidx] = this.numStrings_;
        this.strChr_[this.numStrings_] = b;
        this.strNxt_[this.numStrings_] = index != -1 ? index : -1;
        short s = this.numStrings_;
        this.numStrings_ = (short)(s + 1);
        return s;
    }

    short FindCharString(short index, byte b) {
        short nxtidx;
        if (index == -1) {
            return b;
        }
        int hshidx = LZWStringTable.Hash(index, b);
        while ((nxtidx = this.strHsh_[hshidx]) != -1) {
            if (this.strNxt_[nxtidx] == index && this.strChr_[nxtidx] == b) {
                return nxtidx;
            }
            hshidx = (hshidx + 2039) % 9973;
        }
        return -1;
    }

    void ClearTable(int codesize) {
        this.numStrings_ = 0;
        int q = 0;
        while (q < 9973) {
            this.strHsh_[q] = -1;
            ++q;
        }
        int w = (1 << codesize) + 2;
        int q2 = 0;
        while (q2 < w) {
            this.AddCharString((short)-1, (byte)q2);
            ++q2;
        }
    }

    static int Hash(short index, byte lastbyte) {
        return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
    }
}

