/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoAdapter
implements Video {
    protected Image rawImage;
    protected Dimension size;
    protected BufferedImage bufferedImage;
    protected BufferedImage filteredImage;
    protected int frameCount;
    protected int frameNumber;
    protected int startFrameNumber;
    protected int endFrameNumber;
    protected double rate = 1.0;
    protected boolean playing = false;
    protected boolean looping = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean mouseEnabled = false;
    protected boolean visible = true;
    protected boolean isMeasured = false;
    protected boolean isValidMeasure = false;
    protected boolean widthDominates = true;
    protected boolean isValidImage = false;
    protected boolean isValidFilteredImage = false;
    protected ImageCoordSystem coords;
    protected DoubleArray aspects;
    protected PropertyChangeSupport support;
    protected HashMap<String, Object> properties = new HashMap();
    protected FilterStack filterStack = new FilterStack();
    protected Raster clearRaster;

    protected VideoAdapter() {
        this.initialize();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (panel instanceof VideoPanel && ((VideoPanel)panel).isDrawingInImageSpace() || this.isMeasured) {
            AffineTransform gat = g2.getTransform();
            g2.transform(panel.getPixelTransform());
            if (panel instanceof VideoPanel) {
                VideoPanel vidPanel = (VideoPanel)panel;
                if (!vidPanel.isDrawingInImageSpace()) {
                    ImageCoordSystem coords = vidPanel.getCoords();
                    g2.transform(coords.getToWorldTransform(this.frameNumber));
                }
            } else {
                g2.transform(this.coords.getToWorldTransform(this.frameNumber));
            }
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                g2.drawImage(this.rawImage, 0, 0, panel);
            } else {
                g2.drawImage((Image)this.getImage(), 0, 0, panel);
            }
            g2.setTransform(gat);
        } else {
            double centerX = (panel.getXMax() + panel.getXMin()) / 2.0;
            double centerY = (panel.getYMax() + panel.getYMin()) / 2.0;
            int xoffset = panel.xToPix(centerX) - this.size.width / 2;
            int yoffset = panel.yToPix(centerY) - this.size.height / 2;
            if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
                g2.drawImage(this.rawImage, xoffset, yoffset, panel);
            } else {
                g2.drawImage((Image)this.getImage(), xoffset, yoffset, panel);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("videoVisible", null, new Boolean(visible));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minX;
    }

    @Override
    public double getXMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxX;
    }

    @Override
    public double getYMin() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.minY;
    }

    @Override
    public double getYMax() {
        if (!this.isValidMeasure) {
            this.findMinMaxValues();
        }
        return this.maxY;
    }

    @Override
    public boolean isMeasured() {
        return this.isMeasured;
    }

    @Override
    public BufferedImage getImage() {
        if (!this.isValidImage) {
            this.isValidImage = true;
            Graphics2D g = this.bufferedImage.createGraphics();
            this.bufferedImage.setData(this.clearRaster);
            g.drawImage(this.rawImage, 0, 0, null);
        }
        if (this.filterStack.isEmpty() || !this.filterStack.isEnabled()) {
            return this.bufferedImage;
        }
        if (!this.isValidFilteredImage) {
            this.isValidFilteredImage = true;
            this.filteredImage = this.filterStack.getFilteredImage(this.bufferedImage);
        }
        return this.filteredImage;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.mouseEnabled) {
            return null;
        }
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mouseEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mouseEnabled;
    }

    @Override
    public void setFrameX(int n, double x) {
        this.setFrameXY(n, x, this.coords.imageToWorldY(n, 0.0, 0.0));
    }

    @Override
    public void setX(double x) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameX(n, x);
            ++n;
        }
    }

    @Override
    public void setFrameY(int n, double y) {
        this.setFrameXY(n, this.coords.imageToWorldX(n, 0.0, 0.0), y);
    }

    @Override
    public void setY(double y) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameY(n, y);
            ++n;
        }
    }

    @Override
    public double getX() {
        return this.coords.imageToWorldX(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public double getY() {
        return this.coords.imageToWorldY(this.frameNumber, 0.0, 0.0);
    }

    @Override
    public void setFrameXY(int n, double x, double y) {
        double sin = this.coords.getSine(n);
        double cos = this.coords.getCosine(n);
        double tx = this.coords.getScaleX(n) * (y * sin - x * cos);
        double ty = this.coords.getScaleY(n) * (y * cos + x * sin);
        this.coords.setOriginXY(n, tx, ty);
    }

    @Override
    public void setXY(double x, double y) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameXY(n, x, y);
            ++n;
        }
    }

    @Override
    public void setFrameRelativeAspect(int n, double relativeAspect) {
        if (relativeAspect < 0.001 || relativeAspect > 1000.0) {
            return;
        }
        this.aspects.set(n, Math.abs(relativeAspect));
        if (this.isMeasured) {
            if (this.widthDominates) {
                this.setFrameWidth(n, (double)this.size.width / this.coords.getScaleX(n));
            } else {
                this.setFrameHeight(n, (double)this.size.height / this.coords.getScaleY(n));
            }
        }
    }

    @Override
    public void setRelativeAspect(double relativeAspect) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameRelativeAspect(n, relativeAspect);
            ++n;
        }
    }

    @Override
    public double getRelativeAspect() {
        return this.aspects.get(this.frameNumber);
    }

    @Override
    public void setFrameWidth(int n, double width) {
        if (width == 0.0) {
            return;
        }
        width = Math.abs(width);
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double scaleX = (double)this.size.width / width;
        this.coords.setScaleX(n, scaleX);
        this.coords.setScaleY(n, scaleX * this.aspects.get(n));
        this.widthDominates = true;
        this.setFrameXY(n, x, y);
    }

    @Override
    public void setWidth(double width) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameWidth(n, width);
            ++n;
        }
    }

    @Override
    public double getWidth() {
        return (double)this.size.width / this.coords.getScaleX(this.frameNumber);
    }

    @Override
    public void setFrameHeight(int n, double height) {
        if (height == 0.0) {
            return;
        }
        height = Math.abs(height);
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double scaleY = (double)this.size.height / height;
        this.coords.setScaleY(n, scaleY);
        this.coords.setScaleX(n, scaleY / this.aspects.get(n));
        this.widthDominates = false;
        this.setFrameXY(n, x, y);
    }

    @Override
    public void setHeight(double height) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameHeight(n, height);
            ++n;
        }
    }

    @Override
    public double getHeight() {
        return (double)this.size.height / this.coords.getScaleY(this.frameNumber);
    }

    @Override
    public void setFrameAngle(int n, double theta) {
        double x = this.coords.imageToWorldX(n, 0.0, 0.0);
        double y = this.coords.imageToWorldY(n, 0.0, 0.0);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.coords.setCosineSine(n, cos, -sin);
        this.setFrameXY(n, x, y);
    }

    @Override
    public void setAngle(double theta) {
        int n = 0;
        while (n < this.frameCount) {
            this.setFrameAngle(n, theta);
            ++n;
        }
    }

    @Override
    public double getAngle() {
        return -this.coords.getAngle(this.frameNumber);
    }

    @Override
    public void step() {
        this.stop();
        this.setFrameNumber(this.frameNumber + 1);
    }

    @Override
    public void back() {
        this.stop();
        this.setFrameNumber(this.frameNumber - 1);
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public void setFrameNumber(int n) {
        if (n == this.frameNumber) {
            return;
        }
        n = Math.min(n, this.endFrameNumber);
        n = Math.max(n, this.startFrameNumber);
        this.firePropertyChange("nextframe", null, n);
        this.frameNumber = n;
    }

    @Override
    public int getStartFrameNumber() {
        return this.startFrameNumber;
    }

    @Override
    public void setStartFrameNumber(int n) {
        if (n == this.startFrameNumber) {
            return;
        }
        n = Math.max(0, n);
        this.startFrameNumber = Math.min(this.endFrameNumber, n);
        this.firePropertyChange("startframe", null, new Integer(this.startFrameNumber));
    }

    @Override
    public int getEndFrameNumber() {
        return this.endFrameNumber;
    }

    @Override
    public void setEndFrameNumber(int n) {
        if (n == this.endFrameNumber) {
            return;
        }
        if (this.frameCount > 1) {
            n = Math.min(this.frameCount - 1, n);
        }
        this.endFrameNumber = Math.max(this.startFrameNumber, n);
        this.firePropertyChange("endframe", null, new Integer(this.endFrameNumber));
    }

    @Override
    public double getFrameTime(int n) {
        return -1.0;
    }

    @Override
    public double getFrameDuration(int n) {
        if (this.frameCount == 1) {
            return this.getDuration();
        }
        if (n == this.frameCount - 1) {
            return this.getDuration() - this.getFrameTime(n);
        }
        return this.getFrameTime(n + 1) - this.getFrameTime(n);
    }

    @Override
    public void play() {
        this.playing = true;
    }

    @Override
    public void stop() {
        this.playing = false;
    }

    @Override
    public void reset() {
        this.stop();
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public double getTime() {
        return -1.0;
    }

    @Override
    public void setTime(double millis) {
    }

    @Override
    public double getStartTime() {
        return -1.0;
    }

    @Override
    public void setStartTime(double millis) {
    }

    @Override
    public double getEndTime() {
        return -1.0;
    }

    @Override
    public void setEndTime(double millis) {
    }

    @Override
    public double getDuration() {
        return -1.0;
    }

    @Override
    public void goToStart() {
        this.setFrameNumber(this.startFrameNumber);
    }

    @Override
    public void goToEnd() {
        this.setFrameNumber(this.endFrameNumber);
    }

    @Override
    public void setPlaying(boolean playing) {
        if (playing) {
            this.play();
        } else {
            this.stop();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void setLooping(boolean loops) {
        if (this.looping == loops) {
            return;
        }
        this.looping = loops;
        this.firePropertyChange("looping", null, new Boolean(this.looping));
    }

    @Override
    public boolean isLooping() {
        return this.looping;
    }

    @Override
    public void setRate(double rate) {
        if ((rate = Math.abs(rate)) == this.rate || rate == 0.0) {
            return;
        }
        this.rate = rate;
    }

    @Override
    public double getRate() {
        return this.rate;
    }

    @Override
    public void setCoords(ImageCoordSystem coords) {
        if (coords == this.coords) {
            return;
        }
        this.coords.removePropertyChangeListener(this);
        coords.addPropertyChangeListener(this);
        this.coords = coords;
        this.isMeasured = true;
        this.isValidMeasure = false;
        this.firePropertyChange("coords", null, coords);
    }

    @Override
    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    @Override
    public void setFilterStack(FilterStack stack) {
        this.filterStack.removePropertyChangeListener(this);
        this.filterStack = stack;
        this.filterStack.addPropertyChangeListener(this);
    }

    @Override
    public FilterStack getFilterStack() {
        return this.filterStack;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name.equals("measure")) {
            this.isValidMeasure = false;
        } else {
            this.properties.put(name, value);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(property, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    @Override
    public void dispose() {
        if (this.coords != null) {
            this.coords.removePropertyChangeListener(this);
        }
        this.getFilterStack().setInspectorsVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.coords) {
            this.isMeasured = true;
            this.isValidMeasure = false;
        } else if (e.getSource() == this.filterStack) {
            this.isValidFilteredImage = false;
            this.support.firePropertyChange(e);
        }
    }

    protected void firePropertyChange(String property, Object oldVal, Object newVal) {
        this.support.firePropertyChange(property, oldVal, newVal);
    }

    protected void finalize() {
        this.dispose();
    }

    protected void initialize() {
        this.support = new SwingPropertyChangeSupport(this);
        this.filterStack.addPropertyChangeListener(this);
    }

    protected void refreshBufferedImage() {
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != this.size.width || this.bufferedImage.getHeight() != this.size.height) {
            this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
            int clear = new Color(0, 0, 0, 0).getRGB();
            int[] rgb = new int[this.size.width * this.size.height];
            int i = 0;
            while (i < rgb.length) {
                rgb[i] = clear;
                ++i;
            }
            this.bufferedImage.setRGB(0, 0, this.size.width, this.size.height, rgb, 0, this.size.width);
            this.clearRaster = this.bufferedImage.getData();
            this.isValidImage = false;
        }
    }

    protected void findMinMaxValues() {
        VideoClip clip = (VideoClip)this.getProperty("videoclip");
        Point2D.Double corner = new Point2D.Double(0.0, 0.0);
        int start = 0;
        if (clip != null) {
            start = clip.getStartFrameNumber();
        }
        AffineTransform at = this.coords.getToWorldTransform(start);
        at.transform(corner, corner);
        this.maxX = this.minX = ((Point2D)corner).getX();
        this.maxY = this.minY = ((Point2D)corner).getY();
        int stepCount = this.frameCount;
        if (clip != null) {
            stepCount = clip.getStepCount();
        }
        int n = 0;
        while (n < stepCount) {
            at = clip == null ? this.coords.getToWorldTransform(n) : this.coords.getToWorldTransform(clip.stepToFrame(n));
            int i = 0;
            while (i < 4) {
                switch (i) {
                    case 0: {
                        ((Point2D)corner).setLocation(0.0, 0.0);
                        break;
                    }
                    case 1: {
                        ((Point2D)corner).setLocation(this.size.width, 0.0);
                        break;
                    }
                    case 2: {
                        ((Point2D)corner).setLocation(0.0, this.size.height);
                        break;
                    }
                    case 3: {
                        ((Point2D)corner).setLocation(this.size.width, this.size.height);
                    }
                }
                at.transform(corner, corner);
                this.minX = Math.min(((Point2D)corner).getX(), this.minX);
                this.maxX = Math.max(((Point2D)corner).getX(), this.maxX);
                this.minY = Math.min(((Point2D)corner).getY(), this.minY);
                this.maxY = Math.max(((Point2D)corner).getY(), this.maxY);
                ++i;
            }
            ++n;
        }
        this.isValidMeasure = true;
    }
}

