/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NumberField
extends JTextField {
    public static final Color DISABLED_COLOR = new Color(120, 120, 120);
    protected DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
    protected double prevValue;
    protected Double maxValue;
    protected Double minValue;
    protected int sigfigs;
    protected boolean fixedPattern = false;
    protected String[] patterns = new String[5];
    protected double[] ranges = new double[]{1.0, 10.0, 100.0, 1000.0};
    protected String units;
    protected double conversionFactor = 1.0;

    public NumberField(int columns) {
        this(columns, 4);
    }

    public NumberField(int columns, int sigfigs) {
        super(columns);
        this.setBackground(Color.white);
        this.setDisabledTextColor(DISABLED_COLOR);
        this.setText("0");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    Runnable runner = new Runnable(){

                        @Override
                        public synchronized void run() {
                            NumberField.this.setBackground(Color.white);
                            NumberField.this.setValue(NumberField.this.getValue());
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                } else {
                    NumberField.this.setBackground(Color.yellow);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                Runnable runner = new Runnable(){

                    @Override
                    public synchronized void run() {
                        NumberField.this.setBackground(Color.white);
                        NumberField.this.setValue(NumberField.this.getValue());
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!NumberField.this.isEditable()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    NumberField.this.selectAll();
                }
            }
        });
        this.setSigFigs(sigfigs);
    }

    public double getValue() {
        double retValue;
        String s = this.getText().trim();
        if (this.units != null && !this.units.equals("")) {
            int n = s.indexOf(this.units);
            while (n > -1) {
                s = s.substring(0, n);
                n = s.indexOf(this.units);
            }
        }
        if (s.equals(this.format.format(this.prevValue * this.conversionFactor))) {
            return this.prevValue;
        }
        try {
            retValue = this.format.parse(s).doubleValue() / this.conversionFactor;
            if (this.minValue != null && retValue < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && retValue > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return retValue;
    }

    public void setValue(double value) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minValue != null) {
            value = Math.max(value, this.minValue);
        }
        if (this.maxValue != null) {
            value = Math.min(value, this.maxValue);
        }
        this.prevValue = value;
        value = this.conversionFactor * value;
        this.setFormatFor(value);
        String s = this.format.format(value);
        if (this.units != null) {
            s = String.valueOf(s) + this.units;
        }
        if (!s.equals(this.getText())) {
            this.setText(s);
        }
    }

    public void setExpectedRange(double lower, double upper) {
        this.fixedPattern = true;
        double range = Math.max(Math.abs(lower), Math.abs(upper));
        char d = '.';
        if (range < 0.1 || range >= 1000.0) {
            String s = "";
            int i = 0;
            while (i < this.sigfigs - 1) {
                s = String.valueOf(s) + "0";
                ++i;
            }
            this.format.applyPattern("0" + d + s + "E0");
        } else {
            int n = range < 1.0 ? this.sigfigs : (range < 10.0 ? this.sigfigs - 1 : (range < 100.0 ? this.sigfigs - 2 : this.sigfigs - 3));
            String s = "";
            int i = 0;
            while (i < n) {
                s = String.valueOf(s) + "0";
                ++i;
            }
            if (s.equals("")) {
                this.format.applyPattern("0");
            } else {
                this.format.applyPattern("0" + d + s);
            }
        }
    }

    public void setSigFigs(int sigfigs) {
        if (this.sigfigs == sigfigs) {
            return;
        }
        this.ranges = new double[]{1.0, 10.0, 100.0, 1000.0};
        sigfigs = Math.max(sigfigs, 2);
        this.sigfigs = Math.min(sigfigs, 6);
        char d = '.';
        if (sigfigs == 2) {
            this.patterns[0] = "0" + d + "0E0";
            this.patterns[1] = "0" + d + "0";
            this.patterns[2] = "0";
            this.patterns[3] = "0" + d + "0E0";
            this.patterns[4] = "0" + d + "0E0";
        } else if (sigfigs == 3) {
            this.patterns[0] = "0" + d + "00E0";
            this.patterns[1] = "0" + d + "00";
            this.patterns[2] = "0" + d + "0";
            this.patterns[3] = "0";
            this.patterns[4] = "0" + d + "00E0";
        } else if (sigfigs >= 4) {
            this.patterns[0] = "0" + d + "000E0";
            this.patterns[1] = "0" + d + "000";
            this.patterns[2] = "0" + d + "00";
            this.patterns[3] = "0" + d + "0";
            this.patterns[4] = "0" + d + "000E0";
            int n = sigfigs - 4;
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < this.patterns.length) {
                    this.patterns[j] = "0" + d + "0" + this.patterns[j].substring(2);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setMinValue(double min) {
        this.minValue = Double.isNaN(min) ? null : new Double(min);
    }

    public void setMaxValue(double max) {
        this.maxValue = Double.isNaN(max) ? null : new Double(max);
    }

    public void setUnits(String units) {
        double val = this.getValue();
        this.units = units;
        this.setValue(val);
    }

    public String getUnits() {
        return this.units;
    }

    public void setConversionFactor(double factor) {
        this.conversionFactor = factor;
        this.setValue(this.prevValue);
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormatFor(double value) {
        if (this.fixedPattern) {
            return;
        }
        if ((value = Math.abs(value)) < this.ranges[0]) {
            this.format.applyPattern(this.patterns[0]);
        } else if (value < this.ranges[1]) {
            this.format.applyPattern(this.patterns[1]);
        } else if (value < this.ranges[2]) {
            this.format.applyPattern(this.patterns[2]);
        } else if (value < this.ranges[3]) {
            this.format.applyPattern(this.patterns[3]);
        } else {
            this.format.applyPattern(this.patterns[4]);
        }
    }

    public void setPatterns(String[] patterns) {
        this.setPatterns(patterns, new double[]{1.0, 10.0, 100.0, 1000.0});
    }

    public void setPatterns(String[] patterns, double[] limits) {
        if (patterns.length > 4 && limits.length > 3) {
            this.patterns = patterns;
            this.ranges = limits;
        }
    }
}

