/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideo
extends VideoAdapter {
    protected Component observer = new JPanel();
    protected BufferedImage[] images = new BufferedImage[0];
    protected String[] paths = new String[0];
    protected boolean readOnly = false;
    protected double deltaT = 100.0;

    public ImageVideo(String imageName) throws IOException {
        this.readOnly = true;
        this.append(imageName);
    }

    public ImageVideo(String imageName, boolean sequence) throws IOException {
        this(imageName, sequence, true);
    }

    public ImageVideo(String imageName, boolean sequence, boolean fileBased) throws IOException {
        this.readOnly = fileBased;
        this.append(imageName, sequence);
    }

    public ImageVideo(Image image) {
        if (image != null) {
            this.insert(new Image[]{image}, 0, null);
        }
    }

    public ImageVideo(Image[] images) {
        if (images != null && images.length > 0 && images[0] != null) {
            this.insert(images, 0, null);
        }
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        this.rawImage = this.getImageAtFrame(this.getFrameNumber(), this.rawImage);
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.firePropertyChange("framenumber", null, new Integer(this.getFrameNumber()));
    }

    @Override
    public double getTime() {
        return (double)this.getFrameNumber() * this.deltaT;
    }

    public void setFrameDuration(double millis) {
        this.deltaT = millis;
    }

    @Override
    public void setTime(double millis) {
        int frameNum = (int)(millis / this.deltaT);
        frameNum = Math.max(frameNum, 0);
        frameNum = Math.min(frameNum, this.getFrameCount() - 1);
        this.setFrameNumber(frameNum);
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public void setStartTime(double millis) {
    }

    @Override
    public double getEndTime() {
        return this.getDuration();
    }

    @Override
    public void setEndTime(double millis) {
    }

    @Override
    public double getDuration() {
        return (double)this.length() * this.deltaT;
    }

    @Override
    public double getFrameTime(int n) {
        return (double)n * this.deltaT;
    }

    public Image[] getImages() {
        return this.images;
    }

    public void append(String imageName) throws IOException {
        this.insert(imageName, this.length());
    }

    public void append(String imageName, boolean sequence) throws IOException {
        this.insert(imageName, this.length(), sequence);
    }

    public void insert(String imageName, int index) throws IOException {
        Object[] array = this.loadImages(imageName, true, true);
        Image[] images = (Image[])array[0];
        if (images.length > 0) {
            String[] paths = (String[])array[1];
            this.insert(images, index, paths);
        }
    }

    public void insert(String imageName, int index, boolean sequence) throws IOException {
        Object[] array = this.loadImages(imageName, false, sequence);
        Image[] images = (Image[])array[0];
        if (images.length > 0) {
            String[] paths = (String[])array[1];
            this.insert(images, index, paths);
        }
    }

    public void insert(Image image, int index) {
        if (image == null) {
            return;
        }
        this.insert(new Image[]{image}, index, null);
    }

    public String remove(int index) {
        if (this.readOnly) {
            return null;
        }
        int len = this.images.length;
        if (len == 1 || len <= index) {
            return null;
        }
        String removed = this.paths[index];
        BufferedImage[] newArray = new BufferedImage[len - 1];
        System.arraycopy(this.images, 0, newArray, 0, index);
        System.arraycopy(this.images, index + 1, newArray, index, len - 1 - index);
        this.images = newArray;
        String[] newPaths = new String[len - 1];
        System.arraycopy(this.paths, 0, newPaths, 0, index);
        System.arraycopy(this.paths, index + 1, newPaths, index, len - 1 - index);
        this.paths = newPaths;
        this.rawImage = index < len - 1 ? this.getImageAtFrame(index, this.rawImage) : this.getImageAtFrame(index - 1, this.rawImage);
        this.frameCount = this.images.length;
        this.endFrameNumber = this.frameCount - 1;
        Dimension newDim = this.getSize();
        if (newDim.height != this.size.height || newDim.width != this.size.width) {
            this.firePropertyChange("size", this.size, newDim);
            this.size = newDim;
            this.refreshBufferedImage();
        }
        return removed;
    }

    public Dimension getSize() {
        int w = this.images[0].getWidth(this.observer);
        int h = this.images[0].getHeight(this.observer);
        int i = 1;
        while (i < this.images.length) {
            w = Math.max(w, this.images[i].getWidth(this.observer));
            h = Math.max(h, this.images[i].getHeight(this.observer));
            ++i;
        }
        return new Dimension(w, h);
    }

    public boolean isFileBased() {
        return this.getValidPaths().length == this.paths.length;
    }

    public boolean isEditable() {
        return !this.readOnly;
    }

    public void setEditable(boolean edit) throws IOException {
        if (edit && this.isEditable()) {
            return;
        }
        if (!edit && !this.isEditable()) {
            return;
        }
        String imagePath = this.paths[0];
        boolean bl = this.readOnly = !edit;
        if (this.readOnly) {
            this.paths = new String[0];
        }
        this.images = new BufferedImage[0];
        System.gc();
        this.append(imagePath, true);
    }

    public boolean saveInvalidImages() {
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        int i = 0;
        while (i < this.paths.length) {
            if (this.paths[i].equals("")) {
                pathList.add(this.paths[i]);
                imageList.add(this.images[i]);
            }
            ++i;
        }
        if (pathList.isEmpty()) {
            return true;
        }
        int approved = JOptionPane.showConfirmDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message1")) + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message2"), MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Title"), 0, 2);
        if (approved == 0) {
            File file;
            block10: {
                ImageVideoRecorder recorder = new ImageVideoRecorder();
                recorder.setExpectedFrameCount(imageList.size());
                file = recorder.selectFile();
                if (file != null) break block10;
                return false;
            }
            try {
                String fileName = file.getAbsolutePath();
                BufferedImage[] imagesToSave = imageList.toArray(new BufferedImage[0]);
                String[] pathArray = ImageVideoRecorder.saveImages(fileName, imagesToSave);
                int j = 0;
                int i2 = 0;
                while (i2 < this.paths.length) {
                    if (this.paths[i2].equals("")) {
                        this.paths[i2] = pathArray[j++];
                    }
                    ++i2;
                }
                if (this.getProperty("name") == null) {
                    this.setProperty("name", XML.getName(fileName));
                    this.setProperty("path", fileName);
                    this.setProperty("absolutePath", fileName);
                }
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected void finalize() {
    }

    private Image getImageAtFrame(int frameNumber, Image defaultImage) {
        if (this.readOnly && frameNumber < this.paths.length) {
            Image image;
            if (!this.paths[frameNumber].equals("") && (image = ResourceLoader.getImage(this.paths[frameNumber])) != null) {
                return image;
            }
        } else if (frameNumber < this.images.length && this.images[frameNumber] != null) {
            return this.images[frameNumber];
        }
        return defaultImage;
    }

    private int length() {
        if (this.readOnly) {
            return this.paths.length;
        }
        return this.images.length;
    }

    private Object[] loadImages(String imagePath, boolean alwaysAsk, boolean sequence) throws IOException {
        Resource res = ResourceLoader.getResource(imagePath);
        if (res == null) {
            throw new IOException("Image " + imagePath + " not found");
        }
        Image image = res.getImage();
        if (image == null) {
            throw new IOException("\"" + imagePath + "\" is not an image");
        }
        if (this.getProperty("name") == null) {
            this.setProperty("name", XML.getName(imagePath));
            this.setProperty("path", imagePath);
            this.setProperty("absolutePath", res.getAbsolutePath());
        }
        if (!alwaysAsk && !sequence) {
            Image[] images = new Image[]{image};
            String[] paths = new String[]{imagePath};
            return new Object[]{images, paths};
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(imagePath);
        String name = XML.getName(imagePath);
        String extension = "";
        int i = imagePath.lastIndexOf(46);
        if (i > 0 && i < imagePath.length() - 1) {
            extension = imagePath.substring(i).toLowerCase();
            imagePath = imagePath.substring(0, i);
        }
        int len = imagePath.length();
        int n = 0;
        int digits = 1;
        while (digits < len) {
            try {
                n = Integer.parseInt(imagePath.substring(len - digits));
            }
            catch (NumberFormatException ex) {
                break;
            }
            ++digits;
        }
        if (--digits == 0) {
            Image[] images = new Image[]{image};
            String[] paths = new String[]{String.valueOf(imagePath) + extension};
            return new Object[]{images, paths};
        }
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(image);
        int limit = 10;
        digits = Math.min(digits, 4);
        switch (digits) {
            case 1: {
                limit = 10;
                break;
            }
            case 2: {
                limit = 100;
                break;
            }
            case 3: {
                limit = 1000;
                break;
            }
            case 4: {
                limit = 10000;
            }
        }
        String root = imagePath.substring(0, len - digits);
        try {
            boolean asked = false;
            while (n < limit - 1) {
                String num = String.valueOf(++n);
                int zeros = digits - num.length();
                int k = 0;
                while (k < zeros) {
                    num = "0" + num;
                    ++k;
                }
                imagePath = String.valueOf(root) + num + extension;
                if (this.readOnly && !imageList.isEmpty() ? ResourceLoader.getResource(imagePath) == null : (image = ResourceLoader.getImage(imagePath)) == null) break;
                if (!asked && alwaysAsk) {
                    asked = true;
                    int response = JOptionPane.showOptionDialog(null, "\"" + name + "\" " + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Message") + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Query"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Title"), 0, 3, null, new String[]{MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.SingleImage"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages")}, MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages"));
                    if (response == 0) break;
                }
                if (!this.readOnly || imageList.isEmpty()) {
                    imageList.add(image);
                }
                pathList.add(imagePath);
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        Image[] images = imageList.toArray(new Image[0]);
        String[] paths = pathList.toArray(new String[0]);
        return new Object[]{images, paths};
    }

    public String[] getValidPaths() {
        ArrayList<String> pathList = new ArrayList<String>();
        int i = 0;
        while (i < this.paths.length) {
            if (!this.paths[i].equals("")) {
                pathList.add(this.paths[i]);
            }
            ++i;
        }
        return pathList.toArray(new String[0]);
    }

    protected String[] getValidPathsRelativeTo(String base) {
        ArrayList<String> pathList = new ArrayList<String>();
        int i = 0;
        while (i < this.paths.length) {
            if (!this.paths[i].equals("")) {
                pathList.add(XML.getPathRelativeTo(this.paths[i], base));
            }
            ++i;
        }
        return pathList.toArray(new String[0]);
    }

    protected void insert(Image[] newImages, int index, String[] imagePaths) {
        if (this.readOnly && imagePaths == null) {
            return;
        }
        int len = this.length();
        index = Math.min(index, len);
        int n = newImages.length;
        BufferedImage[] buf = new BufferedImage[n];
        int i = 0;
        while (i < newImages.length) {
            Image im = newImages[i];
            if (im instanceof BufferedImage) {
                buf[i] = (BufferedImage)im;
            } else {
                int w = im.getWidth(null);
                int h = im.getHeight(null);
                buf[i] = new BufferedImage(w, h, 1);
                buf[i].createGraphics().drawImage(im, 0, 0, null);
            }
            ++i;
        }
        BufferedImage[] newArray = new BufferedImage[len + n];
        System.arraycopy(this.images, 0, newArray, 0, index);
        System.arraycopy(buf, 0, newArray, index, n);
        System.arraycopy(this.images, index, newArray, index + n, len - index);
        this.images = newArray;
        if (imagePaths == null) {
            imagePaths = new String[newImages.length];
            int i2 = 0;
            while (i2 < imagePaths.length) {
                imagePaths[i2] = "";
                ++i2;
            }
        }
        n = imagePaths.length;
        String[] newPaths = new String[len + n];
        System.arraycopy(this.paths, 0, newPaths, 0, index);
        System.arraycopy(imagePaths, 0, newPaths, index, n);
        System.arraycopy(this.paths, index, newPaths, index + n, len - index);
        this.paths = newPaths;
        this.rawImage = this.getImageAtFrame(index, this.rawImage);
        this.frameCount = this.length();
        this.endFrameNumber = this.frameCount - 1;
        if (this.coords == null) {
            this.size = new Dimension(this.rawImage.getWidth(this.observer), this.rawImage.getHeight(this.observer));
            this.refreshBufferedImage();
            this.coords = new ImageCoordSystem(this.frameCount);
            this.coords.addPropertyChangeListener(this);
            this.aspects = new DoubleArray(this.frameCount, 1.0);
        } else {
            this.coords.setLength(this.frameCount);
            this.aspects.setLength(this.frameCount);
        }
        Dimension newDim = this.getSize();
        if (newDim.height != this.size.height || newDim.width != this.size.width) {
            this.firePropertyChange("size", this.size, newDim);
            this.size = newDim;
            this.refreshBufferedImage();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ImageVideo video2 = (ImageVideo)obj;
            String base = (String)video2.getProperty("base");
            String[] paths = video2.getValidPathsRelativeTo(base);
            if (paths.length > 0) {
                control.setValue("paths", paths);
                control.setValue("path", paths[0]);
            }
            if (!video2.getFilterStack().isEmpty()) {
                control.setValue("filters", video2.getFilterStack().getFilters());
            }
            control.setValue("delta_t", video2.deltaT);
        }

        @Override
        public Object createObject(XMLControl control) {
            String path;
            String ext;
            VideoType type;
            boolean[] sequences;
            String[] paths = (String[])control.getObject("paths");
            if (paths == null) {
                try {
                    String path2 = control.getString("path");
                    boolean seq = control.getBoolean("sequence");
                    if (path2 != null) {
                        ImageVideo vid = new ImageVideo(path2, seq);
                        return vid;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if ((sequences = (boolean[])control.getObject("sequences")) != null) {
                try {
                    ImageVideo vid = new ImageVideo(paths[0], sequences[0]);
                    int i = 1;
                    while (i < paths.length) {
                        vid.append(paths[i], sequences[i]);
                        ++i;
                    }
                    return vid;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            if (paths.length == 0) {
                return null;
            }
            ImageVideo vid = null;
            ArrayList<String> badPaths = null;
            int i = 0;
            while (i < paths.length) {
                try {
                    if (vid == null) {
                        vid = new ImageVideo(paths[i], false);
                    } else {
                        vid.append(paths[i], false);
                    }
                }
                catch (Exception ex) {
                    if (badPaths == null) {
                        badPaths = new ArrayList<String>();
                    }
                    badPaths.add("\"" + paths[i] + "\"");
                }
                ++i;
            }
            if (badPaths != null) {
                String s = (String)badPaths.get(0);
                int i2 = 1;
                while (i2 < badPaths.size()) {
                    s = String.valueOf(s) + ", " + (String)badPaths.get(i2);
                    ++i2;
                }
                JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.MissingImages.Message")) + ":\n" + s, MediaRes.getString("ImageVideo.Dialog.MissingImages.Title"), 2);
            }
            if (vid == null) {
                return null;
            }
            vid.rawImage = vid.images[0];
            Collection filters = (Collection)Collection.class.cast(control.getObject("filters"));
            if (filters != null) {
                vid.getFilterStack().clear();
                for (Filter filter : filters) {
                    vid.getFilterStack().addFilter(filter);
                }
            }
            if ((type = VideoIO.getVideoType("image", ext = XML.getExtension(path = paths[0]))) != null) {
                vid.setProperty("video_type", type);
            }
            vid.deltaT = control.getDouble("delta_t");
            return vid;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            return obj;
        }
    }
}

