/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.TransformArray;

public class ImageCoordSystem {
    protected static NumberFormat decimal = NumberFormat.getNumberInstance(Locale.US);
    protected static NumberFormat sci = NumberFormat.getNumberInstance(Locale.US);
    private int length;
    protected PropertyChangeSupport support;
    private Point2D point = new Point2D.Double();
    private TransformArray toImage;
    private TransformArray toWorld;
    private DoubleArray scaleX;
    private DoubleArray scaleY;
    private DoubleArray originX;
    private DoubleArray originY;
    private DoubleArray cosine;
    private DoubleArray sine;
    TreeSet<Integer> keyFrames = new TreeSet();
    protected boolean firePropChange = true;
    private boolean isAdjusting = false;
    private boolean fixedOrigin = true;
    private boolean fixedAngle = true;
    private boolean fixedScale = true;
    private boolean locked = false;
    private boolean updateToKeyFrames = true;

    static {
        ((DecimalFormat)decimal).applyPattern("0.00");
        ((DecimalFormat)sci).applyPattern("0.###E0");
    }

    public ImageCoordSystem() {
        this(10);
    }

    public ImageCoordSystem(int length) {
        this.length = length;
        this.toImage = new TransformArray(length);
        this.toWorld = new TransformArray(length);
        this.scaleX = new DoubleArray(length, 1.0);
        this.scaleY = new DoubleArray(length, 1.0);
        this.originX = new DoubleArray(length, 0.0);
        this.originY = new DoubleArray(length, 0.0);
        this.cosine = new DoubleArray(length, 1.0);
        this.sine = new DoubleArray(length, 0.0);
        this.support = new SwingPropertyChangeSupport(this);
        this.updateAllTransforms();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.support.firePropertyChange("locked", null, new Boolean(locked));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setAllValuesToFrame(int n) {
        this.setAllOriginsXY(this.getOriginX(n), this.getOriginY(n));
        this.setAllCosineSines(this.getCosine(n), this.getSine(n));
        this.setAllScalesXY(this.getScaleX(n), this.getScaleY(n));
        this.keyFrames.clear();
    }

    public void setFixedOrigin(boolean fixed) {
        this.setFixedOrigin(fixed, 0);
    }

    public void setFixedOrigin(boolean fixed, int n) {
        if (fixed && this.fixedAngle && this.fixedScale) {
            this.keyFrames.clear();
        }
        if (this.fixedOrigin == fixed) {
            return;
        }
        this.fixedOrigin = fixed;
        if (fixed) {
            this.setAllOriginsXY(this.getOriginX(n), this.getOriginY(n));
        }
        this.support.firePropertyChange("fixed_origin", !fixed, fixed);
    }

    public boolean isFixedOrigin() {
        return this.fixedOrigin;
    }

    public void setFixedAngle(boolean fixed) {
        this.setFixedAngle(fixed, 0);
    }

    public void setFixedAngle(boolean fixed, int n) {
        if (fixed && this.fixedOrigin && this.fixedScale) {
            this.keyFrames.clear();
        }
        if (this.fixedAngle == fixed) {
            return;
        }
        this.fixedAngle = fixed;
        if (fixed) {
            this.setAllCosineSines(this.getCosine(n), this.getSine(n));
        }
        this.support.firePropertyChange("fixed_angle", !fixed, fixed);
    }

    public boolean isFixedAngle() {
        return this.fixedAngle;
    }

    public void setFixedScale(boolean fixed) {
        this.fixedScale = fixed;
    }

    public void setFixedScale(boolean fixed, int n) {
        if (fixed && this.fixedOrigin && this.fixedAngle) {
            this.keyFrames.clear();
        }
        if (this.fixedScale == fixed) {
            return;
        }
        this.fixedScale = fixed;
        if (fixed) {
            this.setAllScalesXY(this.getScaleX(n), this.getScaleY(n));
        }
        this.support.firePropertyChange("fixed_scale", !fixed, fixed);
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public double getScaleX(int n) {
        return this.scaleX.get(n);
    }

    public double getScaleY(int n) {
        return this.scaleY.get(n);
    }

    public void setScaleX(int n, double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesX(value);
            return;
        }
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        if (this.updateToKeyFrames) {
            int end = this.length - 1;
            for (int next : this.keyFrames) {
                if (next <= n) continue;
                end = next - 1;
                break;
            }
            this.setScalesX(n, end, value);
            this.keyFrames.add(n);
            return;
        }
        if (this.scaleX.set(n, value)) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setAllScalesX(double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleX.fill(value)) {
            this.updateAllTransforms();
        }
    }

    public void setScalesX(int start, int end, double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleX.fill(value, start, end)) {
            this.updateTransforms(start, end);
        }
    }

    public void setScaleY(int n, double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesY(value);
            return;
        }
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        if (this.updateToKeyFrames) {
            int end = this.length - 1;
            for (int next : this.keyFrames) {
                if (next <= n) continue;
                end = next - 1;
                break;
            }
            this.setScalesY(n, end, value);
            this.keyFrames.add(n);
            return;
        }
        if (this.scaleY.set(n, value)) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setAllScalesY(double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleY.fill(value)) {
            this.updateAllTransforms();
        }
    }

    public void setScalesY(int start, int end, double value) {
        if (this.isLocked()) {
            return;
        }
        if (this.scaleY.fill(value, start, end)) {
            this.updateTransforms(start, end);
        }
    }

    public void setScaleXY(int n, double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedScale()) {
            this.setAllScalesXY(valueX, valueY);
            return;
        }
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        if (this.updateToKeyFrames) {
            int end = this.length - 1;
            for (int next : this.keyFrames) {
                if (next <= n) continue;
                end = next - 1;
                break;
            }
            this.setScalesXY(n, end, valueX, valueY);
            this.keyFrames.add(n);
            return;
        }
        boolean changed = this.scaleX.set(n, valueX);
        boolean bl = changed = this.scaleY.set(n, valueY) || changed;
        if (changed) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setAllScalesXY(double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        boolean changed = this.scaleX.fill(valueX);
        boolean bl = changed = this.scaleY.fill(valueY) || changed;
        if (changed) {
            this.updateAllTransforms();
        }
    }

    public void setScalesXY(int start, int end, double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        boolean changed = this.scaleX.fill(valueX, start, end);
        boolean bl = changed = this.scaleY.fill(valueY, start, end) || changed;
        if (changed) {
            this.updateTransforms(start, end);
        }
    }

    public double getOriginX(int n) {
        return this.originX.get(n);
    }

    public double getOriginY(int n) {
        return this.originY.get(n);
    }

    public void setOriginXY(int n, double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedOrigin()) {
            this.setAllOriginsXY(valueX, valueY);
            return;
        }
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        if (this.updateToKeyFrames) {
            int end = this.length - 1;
            for (int next : this.keyFrames) {
                if (next <= n) continue;
                end = next - 1;
                break;
            }
            this.setOriginsXY(n, end, valueX, valueY);
            this.keyFrames.add(n);
            return;
        }
        boolean changed = this.originX.set(n, valueX);
        boolean bl = changed = this.originY.set(n, valueY) || changed;
        if (changed) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setAllOriginsXY(double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        boolean changed = this.originX.fill(valueX);
        boolean bl = changed = this.originY.fill(valueY) || changed;
        if (changed) {
            this.updateAllTransforms();
        }
    }

    public void setOriginsXY(int start, int end, double valueX, double valueY) {
        if (this.isLocked()) {
            return;
        }
        boolean changed = this.originX.fill(valueX, start, end);
        boolean bl = changed = this.originY.fill(valueY, start, end) || changed;
        if (changed) {
            this.updateTransforms(start, end);
        }
    }

    public double getCosine(int n) {
        return this.cosine.get(n);
    }

    public double getSine(int n) {
        return this.sine.get(n);
    }

    public void setCosineSine(int n, double cos, double sin) {
        boolean changed;
        if (this.isLocked()) {
            return;
        }
        if (this.isFixedAngle()) {
            this.setAllCosineSines(cos, sin);
            return;
        }
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        if (this.updateToKeyFrames) {
            int end = this.length - 1;
            for (int next : this.keyFrames) {
                if (next <= n) continue;
                end = next - 1;
                break;
            }
            this.setCosineSines(n, end, cos, sin);
            this.keyFrames.add(n);
            return;
        }
        double d = Math.sqrt(cos * cos + sin * sin);
        if (d == 0.0) {
            changed = this.cosine.set(n, 1.0);
            changed = this.sine.set(n, 0.0) || changed;
        } else {
            changed = this.cosine.set(n, cos / d);
            boolean bl = changed = this.sine.set(n, sin / d) || changed;
        }
        if (changed) {
            try {
                this.updateTransforms(n);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setAllCosineSines(double cos, double sin) {
        boolean changed;
        if (this.isLocked()) {
            return;
        }
        double d = Math.sqrt(cos * cos + sin * sin);
        if (d == 0.0) {
            changed = this.cosine.fill(1.0);
            changed = this.sine.fill(0.0) || changed;
        } else {
            changed = this.cosine.fill(cos / d);
            boolean bl = changed = this.sine.fill(sin / d) || changed;
        }
        if (changed) {
            this.updateAllTransforms();
        }
    }

    public void setCosineSines(int start, int end, double cos, double sin) {
        boolean changed;
        if (this.isLocked()) {
            return;
        }
        double d = Math.sqrt(cos * cos + sin * sin);
        if (d == 0.0) {
            changed = this.cosine.fill(1.0, start, end);
            changed = this.sine.fill(0.0, start, end) || changed;
        } else {
            changed = this.cosine.fill(cos / d, start, end);
            boolean bl = changed = this.sine.fill(sin / d, start, end) || changed;
        }
        if (changed) {
            this.updateTransforms(start, end);
        }
    }

    public double getAngle(int n) {
        return Math.atan2(this.getSine(n), this.getCosine(n));
    }

    public void setAngle(int n, double theta) {
        if (this.isLocked()) {
            return;
        }
        this.setCosineSine(n, Math.cos(theta), Math.sin(theta));
    }

    public void setAllAngles(double theta) {
        if (this.isLocked()) {
            return;
        }
        this.setAllCosineSines(Math.cos(theta), Math.sin(theta));
    }

    public void setLength(int count) {
        if (this.isLocked()) {
            return;
        }
        this.length = count;
        this.toImage.setLength(this.length);
        this.toWorld.setLength(this.length);
        this.scaleX.setLength(this.length);
        this.scaleY.setLength(this.length);
        this.originX.setLength(this.length);
        this.originY.setLength(this.length);
        this.cosine.setLength(this.length);
        this.sine.setLength(this.length);
    }

    public int getLength() {
        return this.length;
    }

    public double imageToWorldX(int n, double imageX, double imageY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(imageX, imageY);
        this.toWorld.get(n).transform(this.point, this.point);
        return this.point.getX();
    }

    public double imageToWorldY(int n, double imageX, double imageY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(imageX, imageY);
        this.toWorld.get(n).transform(this.point, this.point);
        return this.point.getY();
    }

    public double worldToImageX(int n, double worldX, double worldY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(worldX, worldY);
        this.toImage.get(n).transform(this.point, this.point);
        return this.point.getX();
    }

    public double worldToImageY(int n, double worldX, double worldY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(worldX, worldY);
        this.toImage.get(n).transform(this.point, this.point);
        return this.point.getY();
    }

    public double imageToWorldXComponent(int n, double imageX, double imageY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(imageX, imageY);
        this.toWorld.get(n).deltaTransform(this.point, this.point);
        return this.point.getX();
    }

    public double imageToWorldYComponent(int n, double imageX, double imageY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(imageX, imageY);
        this.toWorld.get(n).deltaTransform(this.point, this.point);
        return this.point.getY();
    }

    public double worldToImageXComponent(int n, double worldX, double worldY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(worldX, worldY);
        this.toImage.get(n).deltaTransform(this.point, this.point);
        return this.point.getX();
    }

    public double worldToImageYComponent(int n, double worldX, double worldY) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        this.point.setLocation(worldX, worldY);
        this.toImage.get(n).deltaTransform(this.point, this.point);
        return this.point.getY();
    }

    public AffineTransform getToImageTransform(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return (AffineTransform)this.toImage.get(n).clone();
    }

    public AffineTransform getToWorldTransform(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return (AffineTransform)this.toWorld.get(n).clone();
    }

    public void setAdjusting(boolean adjusting) {
        if (this.isAdjusting == adjusting) {
            return;
        }
        this.isAdjusting = adjusting;
        this.support.firePropertyChange("adjusting", null, (Object)adjusting);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public String getDataString(int n) {
        String originXStr = decimal.format(this.getOriginX(n));
        String originYStr = decimal.format(this.getOriginY(n));
        String thetaStr = decimal.format(this.getAngle(n));
        String scaleXStr = sci.format(this.getScaleX(n));
        String scaleYStr = sci.format(this.getScaleY(n));
        return String.valueOf(n) + "\t" + originXStr + "\t" + originYStr + "\t" + thetaStr + "\t" + scaleXStr + "\t" + scaleYStr;
    }

    public TreeSet<Integer> getKeyFrames() {
        return this.keyFrames;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private void updateAllTransforms() {
        try {
            this.firePropChange = false;
            int i = 0;
            while (i < this.length) {
                this.updateTransforms(i);
                ++i;
            }
            this.firePropChange = true;
            this.support.firePropertyChange("transform", null, null);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    private void updateTransforms(int n) throws NoninvertibleTransformException {
        AffineTransform at = this.toImage.get(n);
        double tx = this.originX.get(n);
        double ty = this.originY.get(n);
        double sx = this.scaleX.get(n);
        double sy = this.scaleY.get(n);
        double cos = this.cosine.get(n);
        double sin = this.sine.get(n);
        at.setTransform(sx * cos, -sy * sin, -sx * sin, -sy * cos, tx, ty);
        this.toWorld.get(n).setTransform(at.createInverse());
        if (this.firePropChange) {
            this.support.firePropertyChange("transform", null, new Integer(n));
        }
    }

    private void updateTransforms(int start, int end) {
        try {
            this.firePropChange = false;
            int i = start;
            while (i < this.length) {
                this.updateTransforms(i);
                ++i;
            }
            this.firePropChange = true;
            this.support.firePropertyChange("transform", null, null);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    public static class FrameData {
        double xo;
        double yo;
        double an;
        double xs;
        double ys;

        FrameData() {
        }

        FrameData(ImageCoordSystem coords, int n) {
            this.xo = coords.getOriginX(n);
            this.yo = coords.getOriginY(n);
            this.an = coords.getAngle(n) * 180.0 / Math.PI;
            this.xs = coords.getScaleX(n);
            this.ys = coords.getScaleY(n);
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            control.setValue("xorigin", data.xo);
            control.setValue("yorigin", data.yo);
            control.setValue("angle", data.an);
            control.setValue("xscale", data.xs);
            control.setValue("yscale", data.ys);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            data.xo = control.getDouble("xorigin");
            data.yo = control.getDouble("yorigin");
            data.an = control.getDouble("angle");
            data.xs = control.getDouble("xscale");
            data.ys = control.getDouble("yscale");
            return obj;
        }
    }

    public static class Loader
    implements XML.ObjectLoader {
        @Override
        public void saveObject(XMLControl control, Object obj) {
            ImageCoordSystem coords = (ImageCoordSystem)obj;
            control.setValue("fixedorigin", coords.isFixedOrigin());
            control.setValue("fixedangle", coords.isFixedAngle());
            control.setValue("fixedscale", coords.isFixedScale());
            control.setValue("locked", coords.isLocked());
            int count = coords.getLength();
            if (coords.isFixedAngle() && coords.isFixedOrigin() && coords.isFixedScale()) {
                count = 1;
            }
            FrameData[] data = new FrameData[count];
            int n = 0;
            while (n < count) {
                if (n == 0 || coords.keyFrames.contains(n)) {
                    data[n] = new FrameData(coords, n);
                }
                ++n;
            }
            control.setValue("framedata", data);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new ImageCoordSystem();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ImageCoordSystem coords = (ImageCoordSystem)obj;
            coords.setLocked(false);
            coords.setFixedOrigin(control.getBoolean("fixedorigin"));
            coords.setFixedAngle(control.getBoolean("fixedangle"));
            coords.setFixedScale(control.getBoolean("fixedscale"));
            FrameData[] data = (FrameData[])control.getObject("framedata");
            coords.setLength(Math.max(coords.getLength(), data.length));
            int n = 0;
            while (n < data.length) {
                if (data[n] != null) {
                    coords.setOriginXY(n, data[n].xo, data[n].yo);
                    coords.setAngle(n, data[n].an * Math.PI / 180.0);
                    coords.setScaleXY(n, data[n].xs, data[n].ys);
                }
                ++n;
            }
            coords.setLocked(control.getBoolean("locked"));
            return obj;
        }
    }
}

