/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import org.opensourcephysics.media.core.Filter;

public class FilterStack
extends Filter
implements PropertyChangeListener {
    private ArrayList<Filter> filters = new ArrayList();
    private Filter postFilter;
    private int indexRemoved = -1;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public void insertFilter(Filter filter, int index) {
        index = Math.min(index, this.filters.size());
        index = Math.max(index, 0);
        this.filters.add(index, filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public int lastIndexRemoved() {
        return this.indexRemoved;
    }

    public void setPostFilter(Filter filter) {
        if (this.postFilter != null) {
            this.postFilter.removePropertyChangeListener(this);
        }
        this.postFilter = filter;
        if (filter != null) {
            filter.addPropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", null, filter);
        }
    }

    public Filter getPostFilter() {
        return this.postFilter;
    }

    public Filter getFilter(Class<?> filterClass) {
        for (Filter filter : this.filters) {
            if (filter.getClass() != filterClass) continue;
            return filter;
        }
        return null;
    }

    public void removeFilter(Filter filter) {
        this.indexRemoved = this.filters.indexOf(filter);
        if (this.indexRemoved > -1) {
            this.filters.remove(filter);
            filter.stack = null;
            filter.removePropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", filter, null);
        }
    }

    @Override
    public void clear() {
        for (Filter filter : this.filters) {
            filter.stack = null;
            filter.removePropertyChangeListener(this);
        }
        this.filters.clear();
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, null);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty() && this.postFilter == null;
    }

    public ArrayList<Filter> getFilters() {
        return new ArrayList<Filter>(this.filters);
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage image) {
        if (!this.isEnabled()) {
            return image;
        }
        for (Filter filter : this.filters) {
            image = filter.getFilteredImage(image);
        }
        if (this.postFilter != null) {
            image = this.postFilter.getFilteredImage(image);
        }
        return image;
    }

    @Override
    public JDialog getInspector() {
        return null;
    }

    public void setInspectorsVisible(boolean vis) {
        ArrayList<Filter> filters = this.getFilters();
        for (Filter filter : filters) {
            JDialog inspector = filter.getInspector();
            if (inspector == null) continue;
            if (!vis) {
                filter.inspectorVisible = inspector.isVisible();
                inspector.setVisible(false);
                continue;
            }
            if (inspector.isModal()) continue;
            inspector.setVisible(filter.inspectorVisible);
            filter.inspectorVisible = false;
        }
    }

    @Override
    public void refresh() {
        Iterator<Filter> it = this.getFilters().iterator();
        while (it.hasNext()) {
            it.next().refresh();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.support.firePropertyChange("image", null, null);
    }
}

