/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.StepperClipControl;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;

public abstract class ClipControl
implements PropertyChangeListener {
    protected int stepNumber = 0;
    protected int videoFrameNumber = 0;
    protected final VideoClip clip;
    protected Video video;
    protected double rate = 1.0;
    protected boolean looping = false;
    protected PropertyChangeSupport support;
    protected double timeStretch = 1.0;
    protected DataTrack timeSource;
    protected double savedFrameDuration;

    public static ClipControl getControl(VideoClip clip) {
        Video video2 = clip.getVideo();
        if (clip.isPlayAllSteps() || video2 == null || video2 instanceof ImageVideo) {
            return new StepperClipControl(clip);
        }
        return new VideoClipControl(clip);
    }

    protected ClipControl(VideoClip videoClip) {
        this.clip = videoClip;
        this.video = this.clip.getVideo();
        this.support = new SwingPropertyChangeSupport(this);
    }

    public VideoClip getVideoClip() {
        return this.clip;
    }

    public void play() {
    }

    public void stop() {
    }

    public void step() {
    }

    public void back() {
    }

    public void setFrameNumber(int n) {
        if (this.clip.includesFrame(n)) {
            this.stepNumber = this.clip.frameToStep(n);
            this.videoFrameNumber = n = Math.max(0, n + this.clip.getFrameShift());
        }
    }

    public void setStepNumber(int n) {
        this.stepNumber = n;
        this.videoFrameNumber = n = Math.max(0, this.clip.stepToFrame(n) + this.clip.getFrameShift());
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setRate(double newRate) {
        this.rate = newRate;
    }

    public double getRate() {
        return this.rate;
    }

    public void setLooping(boolean loops) {
        this.looping = loops;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public int getFrameNumber() {
        int n = this.videoFrameNumber - this.clip.getFrameShift();
        n = Math.max(0, n);
        return n;
    }

    public DataTrack getTimeSource() {
        return this.timeSource;
    }

    public void setTimeSource(DataTrack source) {
        DataTrack prev = this.timeSource;
        this.timeSource = source;
        if (prev == null && this.timeSource != null) {
            this.clip.savedStartTime = this.clip.isDefaultStartTime ? Double.NaN : this.clip.getStartTime();
            this.clip.startTimeIsSaved = true;
            this.savedFrameDuration = this.getMeanFrameDuration();
        } else if (prev != null && this.timeSource == null) {
            this.clip.setStartTime(this.clip.savedStartTime);
            this.clip.startTimeIsSaved = false;
            this.setFrameDuration(this.savedFrameDuration);
        }
        if (this.timeSource != null && this.timeSource.isTimeDataAvailable()) {
            this.clip.setStartTime(this.timeSource.getVideoStartTime() * 1000.0);
            this.setFrameDuration(this.timeSource.getFrameDuration() * 1000.0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("startframe")) {
            int n = this.getFrameNumber();
            this.stepNumber = this.clip.frameToStep(n);
        }
    }

    public abstract boolean isPlaying();

    public abstract double getTime();

    public abstract double getStepTime(int var1);

    public abstract void setFrameDuration(double var1);

    public abstract double getMeanFrameDuration();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    public void dispose() {
    }

    public static boolean isTimeSource(DataTrack track) {
        if (track.getVideoPanel() == null) {
            return false;
        }
        return track == track.getVideoPanel().getPlayer().getClipControl().getTimeSource();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ClipControl clipControl = (ClipControl)obj;
            control.setValue("rate", clipControl.getRate());
            control.setValue("delta_t", clipControl.getTimeSource() != null ? clipControl.savedFrameDuration : clipControl.getMeanFrameDuration());
            if (clipControl.isLooping()) {
                control.setValue("looping", true);
            }
            control.setValue("frame", clipControl.getFrameNumber());
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double dt;
            ClipControl clipControl = (ClipControl)obj;
            double rate = control.getDouble("rate");
            if (rate != Double.NaN) {
                clipControl.setRate(rate);
            }
            if ((dt = control.getDouble("delta_t")) != Double.NaN) {
                clipControl.setFrameDuration(dt);
            }
            clipControl.setLooping(control.getBoolean("looping"));
            if (control.getPropertyNames().contains("frame")) {
                int n = control.getInt("frame");
                n = clipControl.getVideoClip().frameToStep(n);
                clipControl.setStepNumber(n);
            }
            return obj;
        }
    }
}

