/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.axes.CartesianCoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarCoordinateStringBuilder;

public abstract class CoordinateStringBuilder {
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected String xLabel = "x=";
    protected String yLabel = "  y=";

    public void setCoordinateLabels(String xLabel, String yLabel) {
        this.xLabel = TeXParser.parseTeX(xLabel);
        this.yLabel = TeXParser.parseTeX(yLabel);
    }

    public abstract String getCoordinateString(DrawingPanel var1, MouseEvent var2);

    public static CoordinateStringBuilder createCartesian() {
        return new CartesianCoordinateStringBuilder();
    }

    public static CoordinateStringBuilder createPolar() {
        return new PolarCoordinateStringBuilder();
    }

    public static CoordinateStringBuilder createPolar(String rLabel, String phiLabel, double phiOffset) {
        return new PolarCoordinateStringBuilder(rLabel, phiLabel, phiOffset);
    }
}

